/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLFunctionRegistry {
    private final Dialect dialect;
    private final Map<String, SQLFunction> userFunctions;

    public SQLFunctionRegistry(Dialect dialect, Map<String, SQLFunction> map) {
        this.dialect = dialect;
        this.userFunctions = new HashMap<String, SQLFunction>();
        this.userFunctions.putAll(map);
    }

    public SQLFunction findSQLFunction(String string) {
        String string2 = string.toLowerCase();
        SQLFunction sQLFunction = this.userFunctions.get(string2);
        return sQLFunction != null ? sQLFunction : this.dialect.getFunctions().get(string2);
    }

    public boolean hasFunction(String string) {
        String string2 = string.toLowerCase();
        return this.userFunctions.containsKey(string2) || this.dialect.getFunctions().containsKey(string2);
    }
}

