/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Iterator;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class DerbyConcatFunction
implements SQLFunction {
    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Type getReturnType(Type type, Mapping mapping) throws QueryException {
        return StandardBasicTypes.STRING;
    }

    public String render(Type type, List list, SessionFactoryImplementor sessionFactoryImplementor) throws QueryException {
        boolean bl = true;
        for (String string : list) {
            if ("?".equals(string)) continue;
            bl = false;
            break;
        }
        if (bl) {
            return DerbyConcatFunction.join(list.iterator(), new StringTransformer(){

                public String transform(String string) {
                    return "cast( ? as varchar(32672) )";
                }
            }, new StringJoinTemplate(){

                public String getBeginning() {
                    return "varchar( ";
                }

                public String getSeparator() {
                    return " || ";
                }

                public String getEnding() {
                    return " )";
                }
            });
        }
        return DerbyConcatFunction.join(list.iterator(), new StringTransformer(){

            public String transform(String string) {
                return string;
            }
        }, new StringJoinTemplate(){

            public String getBeginning() {
                return "(";
            }

            public String getSeparator() {
                return "||";
            }

            public String getEnding() {
                return ")";
            }
        });
    }

    private static String join(Iterator iterator, StringTransformer stringTransformer, StringJoinTemplate stringJoinTemplate) {
        StringBuilder stringBuilder = new StringBuilder(stringJoinTemplate.getBeginning());
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuilder.append(stringTransformer.transform(string));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(stringJoinTemplate.getSeparator());
        }
        return stringBuilder.append(stringJoinTemplate.getEnding()).toString();
    }

    private static interface StringJoinTemplate {
        public String getBeginning();

        public String getSeparator();

        public String getEnding();
    }

    private static interface StringTransformer {
        public String transform(String var1);
    }
}

