/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.MappingException;
import org.hibernate.internal.util.StringHelper;

public class TypeNames {
    private Map<Integer, Map<Long, String>> weighted = new HashMap<Integer, Map<Long, String>>();
    private Map<Integer, String> defaults = new HashMap<Integer, String>();

    public String get(int n) throws MappingException {
        String string = this.defaults.get(n);
        if (string == null) {
            throw new MappingException("No Dialect mapping for JDBC type: " + n);
        }
        return string;
    }

    public String get(int n, long l, int n2, int n3) throws MappingException {
        Map<Long, String> map = this.weighted.get(n);
        if (map != null && map.size() > 0) {
            for (Map.Entry<Long, String> entry : map.entrySet()) {
                if (l > entry.getKey()) continue;
                return TypeNames.replace(entry.getValue(), l, n2, n3);
            }
        }
        return TypeNames.replace(this.get(n), l, n2, n3);
    }

    private static String replace(String string, long l, int n, int n2) {
        string = StringHelper.replaceOnce(string, "$s", Integer.toString(n2));
        string = StringHelper.replaceOnce(string, "$l", Long.toString(l));
        return StringHelper.replaceOnce(string, "$p", Integer.toString(n));
    }

    public void put(int n, long l, String string) {
        Map<Long, String> map = this.weighted.get(n);
        if (map == null) {
            map = new TreeMap<Long, String>();
            this.weighted.put(n, map);
        }
        map.put(l, string);
    }

    public void put(int n, String string) {
        this.defaults.put(n, string);
    }
}

