/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.type.ObjectType;
import org.hibernate.type.descriptor.sql.BlobTypeDescriptor;
import org.hibernate.type.descriptor.sql.ClobTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class SybaseDialect
extends AbstractTransactSQLDialect {
    private static final int PARAM_LIST_SIZE_LIMIT = 250000;

    public SybaseDialect() {
        this.registerFunction("convert", new SQLFunctionTemplate(ObjectType.INSTANCE, "convert(?1, ?2)"));
    }

    public int getInExpressionCountLimit() {
        return 250000;
    }

    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int n) {
        switch (n) {
            case 2004: {
                return BlobTypeDescriptor.PRIMITIVE_ARRAY_BINDING;
            }
            case 2005: {
                return ClobTypeDescriptor.STREAM_BINDING_EXTRACTING;
            }
        }
        return super.getSqlTypeDescriptorOverride(n);
    }

    public String getNullColumnString() {
        return " null";
    }

    public String getAlterColumnNullableString(String string, boolean bl) {
        return "modify " + string + (!bl ? " not" : "") + " null";
    }
}

