/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NullPrecedence;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.function.AnsiTrimEmulationFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.sql.SmallIntTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class SQLServerDialect
extends AbstractTransactSQLDialect {
    private static final int PARAM_LIST_SIZE_LIMIT = 2100;

    public SQLServerDialect() {
        this.registerColumnType(-3, "image");
        this.registerColumnType(-3, 8000L, "varbinary($l)");
        this.registerColumnType(-4, "image");
        this.registerColumnType(-1, "text");
        this.registerColumnType(16, "bit");
        this.registerFunction("second", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "datepart(second, ?1)"));
        this.registerFunction("minute", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "datepart(minute, ?1)"));
        this.registerFunction("hour", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "datepart(hour, ?1)"));
        this.registerFunction("locate", new StandardSQLFunction("charindex", StandardBasicTypes.INTEGER));
        this.registerFunction("extract", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "datepart(?1, ?3)"));
        this.registerFunction("mod", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "?1 % ?2"));
        this.registerFunction("bit_length", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "datalength(?1) * 8"));
        this.registerFunction("trim", new AnsiTrimEmulationFunction());
        this.registerKeyword("top");
    }

    public String getNoColumnsInsertString() {
        return "default values";
    }

    static int getAfterSelectInsertPoint(String string) {
        int n = string.toLowerCase().indexOf("select");
        int n2 = string.toLowerCase().indexOf("select distinct");
        return n + (n2 == n ? 15 : 6);
    }

    public String getLimitString(String string, int n, int n2) {
        if (n > 0) {
            throw new UnsupportedOperationException("query result offset is not supported");
        }
        return new StringBuilder(string.length() + 8).append(string).insert(SQLServerDialect.getAfterSelectInsertPoint(string), " top " + n2).toString();
    }

    public String appendIdentitySelectToInsert(String string) {
        return string + " select scope_identity()";
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    public char closeQuote() {
        return ']';
    }

    public char openQuote() {
        return '[';
    }

    public String appendLockHint(LockOptions lockOptions, String string) {
        LockMode lockMode = lockOptions.getLockMode();
        switch (lockMode) {
            case UPGRADE: 
            case UPGRADE_NOWAIT: 
            case PESSIMISTIC_WRITE: 
            case WRITE: {
                return string + " with (updlock, rowlock)";
            }
            case PESSIMISTIC_READ: {
                return string + " with (holdlock, rowlock)";
            }
        }
        return string;
    }

    public String getCurrentTimestampSelectString() {
        return "select current_timestamp";
    }

    public boolean areStringComparisonsCaseInsensitive() {
        return true;
    }

    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }

    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int n) {
        return n == -6 ? SmallIntTypeDescriptor.INSTANCE : super.getSqlTypeDescriptorOverride(n);
    }

    public int getInExpressionCountLimit() {
        return 2100;
    }

    public String getAlterColumnDefinitionString(String string, String string2) {
        return "alter column " + string + " " + string2;
    }

    public String getIdentityColumnString(int n, int n2, int n3) throws MappingException {
        if (n2 == -1 && n3 == -1) {
            return super.getIdentityColumnString(n, n2, n3);
        }
        StringBuffer stringBuffer = new StringBuffer("identity(");
        if (n2 != -1) {
            stringBuffer.append(String.valueOf(n2));
        }
        if (n3 != -1) {
            if (n2 != -1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(String.valueOf(n3));
        }
        stringBuffer.append(") not null");
        return stringBuffer.toString();
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public String renderOrderByElement(String string, String string2, String string3, NullPrecedence nullPrecedence) {
        StringBuilder stringBuilder = new StringBuilder();
        if (nullPrecedence != NullPrecedence.NONE) {
            stringBuilder.append("case when ").append(string).append(" is null then ");
            if (nullPrecedence == NullPrecedence.FIRST) {
                stringBuilder.append("0 else 1");
            } else {
                stringBuilder.append("1 else 0");
            }
            stringBuilder.append(" end, ");
        }
        stringBuilder.append(super.renderOrderByElement(string, string2, string3, NullPrecedence.NONE));
        return stringBuilder.toString();
    }

    public String getLowercaseExpression(String string, String string2) {
        if ("text".equals(string2)) {
            return super.getLowercaseExpression("cast (" + string + " as varchar)", string2);
        }
        return super.getLowercaseExpression(string, string2);
    }
}

