/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryTimeoutException;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.SQLServer2005LimitHandler;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.type.StandardBasicTypes;

public class SQLServer2005Dialect
extends SQLServerDialect {
    private static final int MAX_LENGTH = 8000;

    public SQLServer2005Dialect() {
        this.registerColumnType(2004, "varbinary(MAX)");
        this.registerColumnType(-3, "varbinary(MAX)");
        this.registerColumnType(-3, 8000L, "varbinary($l)");
        this.registerColumnType(-4, "varbinary(MAX)");
        this.registerColumnType(2005, "varchar(MAX)");
        this.registerColumnType(-1, "varchar(MAX)");
        this.registerColumnType(12, "varchar(MAX)");
        this.registerColumnType(12, 8000L, "varchar($l)");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(-7, "bit");
        this.registerFunction("row_number", new NoArgSQLFunction("row_number", StandardBasicTypes.INTEGER, true));
    }

    public LimitHandler buildLimitHandler(String string, RowSelection rowSelection) {
        return new SQLServer2005LimitHandler(string, rowSelection);
    }

    public String appendLockHint(LockOptions lockOptions, String string) {
        if (lockOptions.getLockMode() == LockMode.UPGRADE_NOWAIT) {
            return string + " with (updlock, rowlock, nowait)";
        }
        LockMode lockMode = lockOptions.getLockMode();
        boolean bl = lockOptions.getTimeOut() == 0;
        String string2 = bl ? ", nowait" : "";
        switch (lockMode) {
            case UPGRADE_NOWAIT: {
                return string + " with (updlock, rowlock, nowait)";
            }
            case UPGRADE: 
            case PESSIMISTIC_WRITE: 
            case WRITE: {
                return string + " with (updlock, rowlock" + string2 + " )";
            }
            case PESSIMISTIC_READ: {
                return string + " with (holdlock, rowlock" + string2 + " )";
            }
        }
        return string;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new SQLExceptionConversionDelegate(){

            public JDBCException convert(SQLException sQLException, String string, String string2) {
                String string3 = JdbcExceptionHelper.extractSqlState(sQLException);
                int n = JdbcExceptionHelper.extractErrorCode(sQLException);
                if ("HY008".equals(string3)) {
                    throw new QueryTimeoutException(string, sQLException, string2);
                }
                if (1222 == n) {
                    throw new LockTimeoutException(string, sQLException, string2);
                }
                return null;
            }
        };
    }
}

