/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.PessimisticLockException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.PositionSubstringFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.sql.BlobTypeDescriptor;
import org.hibernate.type.descriptor.sql.ClobTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class PostgreSQL81Dialect
extends Dialect {
    private static ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sQLException) {
            try {
                int n = Integer.valueOf(JdbcExceptionHelper.extractSqlState(sQLException));
                switch (n) {
                    case 23514: {
                        return this.extractUsingTemplate("violates check constraint \"", "\"", sQLException.getMessage());
                    }
                    case 23505: {
                        return this.extractUsingTemplate("violates unique constraint \"", "\"", sQLException.getMessage());
                    }
                    case 23503: {
                        return this.extractUsingTemplate("violates foreign key constraint \"", "\"", sQLException.getMessage());
                    }
                    case 23502: {
                        return this.extractUsingTemplate("null value in column \"", "\" violates not-null constraint", sQLException.getMessage());
                    }
                    case 23001: {
                        return null;
                    }
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    };

    public PostgreSQL81Dialect() {
        this.registerColumnType(-7, "bool");
        this.registerColumnType(-5, "int8");
        this.registerColumnType(5, "int2");
        this.registerColumnType(-6, "int2");
        this.registerColumnType(4, "int4");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float4");
        this.registerColumnType(8, "float8");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "bytea");
        this.registerColumnType(-2, "bytea");
        this.registerColumnType(-1, "text");
        this.registerColumnType(-4, "bytea");
        this.registerColumnType(2005, "text");
        this.registerColumnType(2004, "oid");
        this.registerColumnType(2, "numeric($p, $s)");
        this.registerColumnType(1111, "uuid");
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("sign", new StandardSQLFunction("sign", StandardBasicTypes.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction("acos", StandardBasicTypes.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction("asin", StandardBasicTypes.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction("atan", StandardBasicTypes.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction("cos", StandardBasicTypes.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction("cot", StandardBasicTypes.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction("exp", StandardBasicTypes.DOUBLE));
        this.registerFunction("ln", new StandardSQLFunction("ln", StandardBasicTypes.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction("log", StandardBasicTypes.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction("sin", StandardBasicTypes.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", StandardBasicTypes.DOUBLE));
        this.registerFunction("cbrt", new StandardSQLFunction("cbrt", StandardBasicTypes.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction("tan", StandardBasicTypes.DOUBLE));
        this.registerFunction("radians", new StandardSQLFunction("radians", StandardBasicTypes.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction("degrees", StandardBasicTypes.DOUBLE));
        this.registerFunction("stddev", new StandardSQLFunction("stddev", StandardBasicTypes.DOUBLE));
        this.registerFunction("variance", new StandardSQLFunction("variance", StandardBasicTypes.DOUBLE));
        this.registerFunction("random", new NoArgSQLFunction("random", StandardBasicTypes.DOUBLE));
        this.registerFunction("rand", new NoArgSQLFunction("random", StandardBasicTypes.DOUBLE));
        this.registerFunction("round", new StandardSQLFunction("round"));
        this.registerFunction("trunc", new StandardSQLFunction("trunc"));
        this.registerFunction("ceil", new StandardSQLFunction("ceil"));
        this.registerFunction("floor", new StandardSQLFunction("floor"));
        this.registerFunction("chr", new StandardSQLFunction("chr", StandardBasicTypes.CHARACTER));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("substr", new StandardSQLFunction("substr", StandardBasicTypes.STRING));
        this.registerFunction("initcap", new StandardSQLFunction("initcap"));
        this.registerFunction("to_ascii", new StandardSQLFunction("to_ascii"));
        this.registerFunction("quote_ident", new StandardSQLFunction("quote_ident", StandardBasicTypes.STRING));
        this.registerFunction("quote_literal", new StandardSQLFunction("quote_literal", StandardBasicTypes.STRING));
        this.registerFunction("md5", new StandardSQLFunction("md5", StandardBasicTypes.STRING));
        this.registerFunction("ascii", new StandardSQLFunction("ascii", StandardBasicTypes.INTEGER));
        this.registerFunction("char_length", new StandardSQLFunction("char_length", StandardBasicTypes.LONG));
        this.registerFunction("bit_length", new StandardSQLFunction("bit_length", StandardBasicTypes.LONG));
        this.registerFunction("octet_length", new StandardSQLFunction("octet_length", StandardBasicTypes.LONG));
        this.registerFunction("age", new StandardSQLFunction("age"));
        this.registerFunction("current_date", new NoArgSQLFunction("current_date", StandardBasicTypes.DATE, false));
        this.registerFunction("current_time", new NoArgSQLFunction("current_time", StandardBasicTypes.TIME, false));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("current_timestamp", StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("date_trunc", new StandardSQLFunction("date_trunc", StandardBasicTypes.TIMESTAMP));
        this.registerFunction("localtime", new NoArgSQLFunction("localtime", StandardBasicTypes.TIME, false));
        this.registerFunction("localtimestamp", new NoArgSQLFunction("localtimestamp", StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("now", new NoArgSQLFunction("now", StandardBasicTypes.TIMESTAMP));
        this.registerFunction("timeofday", new NoArgSQLFunction("timeofday", StandardBasicTypes.STRING));
        this.registerFunction("current_user", new NoArgSQLFunction("current_user", StandardBasicTypes.STRING, false));
        this.registerFunction("session_user", new NoArgSQLFunction("session_user", StandardBasicTypes.STRING, false));
        this.registerFunction("user", new NoArgSQLFunction("user", StandardBasicTypes.STRING, false));
        this.registerFunction("current_database", new NoArgSQLFunction("current_database", StandardBasicTypes.STRING, true));
        this.registerFunction("current_schema", new NoArgSQLFunction("current_schema", StandardBasicTypes.STRING, true));
        this.registerFunction("to_char", new StandardSQLFunction("to_char", StandardBasicTypes.STRING));
        this.registerFunction("to_date", new StandardSQLFunction("to_date", StandardBasicTypes.DATE));
        this.registerFunction("to_timestamp", new StandardSQLFunction("to_timestamp", StandardBasicTypes.TIMESTAMP));
        this.registerFunction("to_number", new StandardSQLFunction("to_number", StandardBasicTypes.BIG_DECIMAL));
        this.registerFunction("concat", new VarArgsSQLFunction(StandardBasicTypes.STRING, "(", "||", ")"));
        this.registerFunction("locate", new PositionSubstringFunction());
        this.registerFunction("str", new SQLFunctionTemplate(StandardBasicTypes.STRING, "cast(?1 as varchar)"));
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.jdbc.lob.non_contextual_creation", "true");
    }

    public SqlTypeDescriptor getSqlTypeDescriptorOverride(int n) {
        SqlTypeDescriptor sqlTypeDescriptor;
        switch (n) {
            case 2004: {
                sqlTypeDescriptor = BlobTypeDescriptor.BLOB_BINDING;
                break;
            }
            case 2005: {
                sqlTypeDescriptor = ClobTypeDescriptor.CLOB_BINDING;
                break;
            }
            default: {
                sqlTypeDescriptor = super.getSqlTypeDescriptorOverride(n);
            }
        }
        return sqlTypeDescriptor;
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getDropColumnString() {
        return "drop column";
    }

    public String getSequenceNextValString(String string) {
        return "select " + this.getSelectSequenceNextValString(string);
    }

    public String getSelectSequenceNextValString(String string) {
        return "nextval ('" + string + "')";
    }

    public String getCreateSequenceString(String string) {
        return "create sequence " + string;
    }

    public String getDropSequenceString(String string) {
        return "drop sequence " + string;
    }

    public String getCascadeConstraintsString() {
        return " cascade";
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getQuerySequencesString() {
        return "select relname from pg_class where relkind='S'";
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String string, boolean bl) {
        return new StringBuilder(string.length() + 20).append(string).append(bl ? " limit ? offset ?" : " limit ?").toString();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getForUpdateString(String string) {
        return this.getForUpdateString() + " of " + string;
    }

    public String getIdentitySelectString(String string, String string2, int n) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer().append("select currval('");
        if (string.indexOf("\"") == -1) {
            string = string.toLowerCase();
        }
        if (string2.indexOf("\"") == -1) {
            string2 = string2.toLowerCase();
        }
        if ((string3 = new StringBuffer().append(string).append('_').append(string2).append("_seq").toString()).indexOf("\"") != -1) {
            string3 = string3.replaceAll("\\\"", "");
            string3 = "\"" + string3 + "\"";
        }
        stringBuffer.append(string3);
        stringBuffer.append("')");
        return stringBuffer.toString();
    }

    public String getIdentityColumnString(int n) {
        return n == -5 ? "bigserial not null" : "serial not null";
    }

    public boolean hasDataTypeInIdentityColumn() {
        return false;
    }

    public String getNoColumnsInsertString() {
        return "default values";
    }

    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    public Class getNativeIdentifierGeneratorClass() {
        return SequenceGenerator.class;
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public String getSelectClauseNullString(int n) {
        String string = this.getTypeName(n, 1L, 1, 0);
        int n2 = string.indexOf(40);
        if (n2 > -1) {
            string = string.substring(0, n2);
        }
        return "null::" + string;
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String getCreateTemporaryTableString() {
        return "create temporary table";
    }

    public String getCreateTemporaryTablePostfix() {
        return "on commit drop";
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public String toBooleanValueString(boolean bl) {
        return bl ? "true" : "false";
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new SQLExceptionConversionDelegate(){

            public JDBCException convert(SQLException sQLException, String string, String string2) {
                String string3 = JdbcExceptionHelper.extractSqlState(sQLException);
                if ("40P01".equals(string3)) {
                    return new LockAcquisitionException(string, sQLException, string2);
                }
                if ("55P03".equals(string3)) {
                    return new PessimisticLockException(string, sQLException, string2);
                }
                return null;
            }
        };
    }

    public int registerResultSetOutParameter(CallableStatement callableStatement, int n) throws SQLException {
        callableStatement.registerOutParameter(n++, 1111);
        return n;
    }

    public ResultSet getResultSet(CallableStatement callableStatement) throws SQLException {
        callableStatement.execute();
        return (ResultSet)callableStatement.getObject(1);
    }

    public boolean supportsPooledSequences() {
        return true;
    }

    protected String getCreateSequenceString(String string, int n, int n2) {
        return this.getCreateSequenceString(string) + " start " + n + " increment " + n2;
    }

    public String getAlterColumnDefaultValueString(String string, String string2) {
        return "alter column " + string + " set default " + string2;
    }

    public String getAlterColumnNullableString(String string, boolean bl) {
        return "alter column " + string + " " + (bl ? "drop" : "set") + " not null";
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return true;
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    public String getForUpdateString() {
        return " for update";
    }

    public String getWriteLockString(int n) {
        if (n == 0) {
            return " for update nowait";
        }
        return " for update";
    }

    public String getReadLockString(int n) {
        if (n == 0) {
            return " for share nowait";
        }
        return " for share";
    }

    public boolean supportsRowValueConstructorSyntax() {
        return true;
    }

    public String getForUpdateNowaitString() {
        return this.getForUpdateString() + " nowait ";
    }

    public String getForUpdateNowaitString(String string) {
        return this.getForUpdateString(string) + " nowait ";
    }

    public String getCreateTableInTablespaceKeyword() {
        return "tablespace";
    }

    public boolean supportPrimaryKeyTablespace() {
        return true;
    }
}

