/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NullPrecedence;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.ColumnAliasExtractor;
import org.hibernate.dialect.LobMergeStrategy;
import org.hibernate.dialect.TypeNames;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardAnsiSqlAggregationFunctions;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadSelectLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteSelectLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.pagination.LegacyLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.unique.DefaultUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.exception.spi.ConversionContext;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.id.TableHiLoGenerator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.io.StreamCopier;
import org.hibernate.metamodel.spi.TypeContributions;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ANSICaseFragment;
import org.hibernate.sql.ANSIJoinFragment;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.sql.ClobTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Dialect
implements ConversionContext {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, Dialect.class.getName());
    public static final String DEFAULT_BATCH_SIZE = "15";
    public static final String NO_BATCH = "0";
    public static final String QUOTE = "`\"[";
    public static final String CLOSED_QUOTE = "`\"]";
    private final TypeNames typeNames = new TypeNames();
    private final TypeNames hibernateTypeNames = new TypeNames();
    private final Properties properties = new Properties();
    private final Map<String, SQLFunction> sqlFunctions = new HashMap<String, SQLFunction>();
    private final Set<String> sqlKeywords = new HashSet<String>();
    private final UniqueDelegate uniqueDelegate;
    protected static final LobMergeStrategy LEGACY_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        public Blob mergeBlob(Blob blob, Blob blob2, SessionImplementor sessionImplementor) {
            return blob2;
        }

        public Clob mergeClob(Clob clob, Clob clob2, SessionImplementor sessionImplementor) {
            return clob2;
        }

        public NClob mergeNClob(NClob nClob, NClob nClob2, SessionImplementor sessionImplementor) {
            return nClob2;
        }
    };
    protected static final LobMergeStrategy STREAM_XFER_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        public Blob mergeBlob(Blob blob, Blob blob2, SessionImplementor sessionImplementor) {
            if (blob != blob2) {
                try {
                    OutputStream outputStream = blob2.setBinaryStream(1L);
                    InputStream inputStream = blob.getBinaryStream();
                    StreamCopier.copy(inputStream, outputStream);
                    return blob2;
                }
                catch (SQLException sQLException) {
                    throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "unable to merge BLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeBlob(blob, blob2, sessionImplementor);
        }

        public Clob mergeClob(Clob clob, Clob clob2, SessionImplementor sessionImplementor) {
            if (clob != clob2) {
                try {
                    OutputStream outputStream = clob2.setAsciiStream(1L);
                    InputStream inputStream = clob.getAsciiStream();
                    StreamCopier.copy(inputStream, outputStream);
                    return clob2;
                }
                catch (SQLException sQLException) {
                    throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "unable to merge CLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeClob(clob, clob2, sessionImplementor);
        }

        public NClob mergeNClob(NClob nClob, NClob nClob2, SessionImplementor sessionImplementor) {
            if (nClob != nClob2) {
                try {
                    OutputStream outputStream = nClob2.setAsciiStream(1L);
                    InputStream inputStream = nClob.getAsciiStream();
                    StreamCopier.copy(inputStream, outputStream);
                    return nClob2;
                }
                catch (SQLException sQLException) {
                    throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "unable to merge NCLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeNClob(nClob, nClob2, sessionImplementor);
        }
    };
    protected static final LobMergeStrategy NEW_LOCATOR_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        public Blob mergeBlob(Blob blob, Blob blob2, SessionImplementor sessionImplementor) {
            if (blob == null && blob2 == null) {
                return null;
            }
            try {
                LobCreator lobCreator = sessionImplementor.getFactory().getJdbcServices().getLobCreator(sessionImplementor);
                return blob == null ? lobCreator.createBlob(ArrayHelper.EMPTY_BYTE_ARRAY) : lobCreator.createBlob(blob.getBinaryStream(), blob.length());
            }
            catch (SQLException sQLException) {
                throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "unable to merge BLOB data");
            }
        }

        public Clob mergeClob(Clob clob, Clob clob2, SessionImplementor sessionImplementor) {
            if (clob == null && clob2 == null) {
                return null;
            }
            try {
                LobCreator lobCreator = sessionImplementor.getFactory().getJdbcServices().getLobCreator(sessionImplementor);
                return clob == null ? lobCreator.createClob("") : lobCreator.createClob(clob.getCharacterStream(), clob.length());
            }
            catch (SQLException sQLException) {
                throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "unable to merge CLOB data");
            }
        }

        public NClob mergeNClob(NClob nClob, NClob nClob2, SessionImplementor sessionImplementor) {
            if (nClob == null && nClob2 == null) {
                return null;
            }
            try {
                LobCreator lobCreator = sessionImplementor.getFactory().getJdbcServices().getLobCreator(sessionImplementor);
                return nClob == null ? lobCreator.createNClob("") : lobCreator.createNClob(nClob.getCharacterStream(), nClob.length());
            }
            catch (SQLException sQLException) {
                throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "unable to merge NCLOB data");
            }
        }
    };
    private static final ViolatedConstraintNameExtracter EXTRACTER = new ViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sQLException) {
            return null;
        }
    };

    protected Dialect() {
        LOG.usingDialect(this);
        StandardAnsiSqlAggregationFunctions.primeFunctionMap(this.sqlFunctions);
        this.registerFunction("substring", new SQLFunctionTemplate(StandardBasicTypes.STRING, "substring(?1, ?2, ?3)"));
        this.registerFunction("locate", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "locate(?1, ?2, ?3)"));
        this.registerFunction("trim", new SQLFunctionTemplate(StandardBasicTypes.STRING, "trim(?1 ?2 ?3 ?4)"));
        this.registerFunction("length", new StandardSQLFunction("length", StandardBasicTypes.INTEGER));
        this.registerFunction("bit_length", new StandardSQLFunction("bit_length", StandardBasicTypes.INTEGER));
        this.registerFunction("coalesce", new StandardSQLFunction("coalesce"));
        this.registerFunction("nullif", new StandardSQLFunction("nullif"));
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("mod", new StandardSQLFunction("mod", StandardBasicTypes.INTEGER));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", StandardBasicTypes.DOUBLE));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("cast", new CastFunction());
        this.registerFunction("extract", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "extract(?1 ?2 ?3)"));
        this.registerFunction("second", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "extract(second from ?1)"));
        this.registerFunction("minute", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "extract(minute from ?1)"));
        this.registerFunction("hour", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "extract(hour from ?1)"));
        this.registerFunction("day", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "extract(day from ?1)"));
        this.registerFunction("month", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "extract(month from ?1)"));
        this.registerFunction("year", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "extract(year from ?1)"));
        this.registerFunction("str", new SQLFunctionTemplate(StandardBasicTypes.STRING, "cast(?1 as char)"));
        this.registerColumnType(-7, "bit");
        this.registerColumnType(16, "boolean");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(6, "float($p)");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(7, "real");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "bit varying($l)");
        this.registerColumnType(-4, "bit varying($l)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-1, "varchar($l)");
        this.registerColumnType(2005, "clob");
        this.registerColumnType(-15, "nchar($l)");
        this.registerColumnType(-9, "nvarchar($l)");
        this.registerColumnType(-16, "nvarchar($l)");
        this.registerColumnType(2011, "nclob");
        this.registerHibernateType(-5, StandardBasicTypes.BIG_INTEGER.getName());
        this.registerHibernateType(-2, StandardBasicTypes.BINARY.getName());
        this.registerHibernateType(-7, StandardBasicTypes.BOOLEAN.getName());
        this.registerHibernateType(16, StandardBasicTypes.BOOLEAN.getName());
        this.registerHibernateType(1, StandardBasicTypes.CHARACTER.getName());
        this.registerHibernateType(1, 1L, StandardBasicTypes.CHARACTER.getName());
        this.registerHibernateType(1, 255L, StandardBasicTypes.STRING.getName());
        this.registerHibernateType(91, StandardBasicTypes.DATE.getName());
        this.registerHibernateType(8, StandardBasicTypes.DOUBLE.getName());
        this.registerHibernateType(6, StandardBasicTypes.FLOAT.getName());
        this.registerHibernateType(4, StandardBasicTypes.INTEGER.getName());
        this.registerHibernateType(5, StandardBasicTypes.SHORT.getName());
        this.registerHibernateType(-6, StandardBasicTypes.BYTE.getName());
        this.registerHibernateType(92, StandardBasicTypes.TIME.getName());
        this.registerHibernateType(93, StandardBasicTypes.TIMESTAMP.getName());
        this.registerHibernateType(12, StandardBasicTypes.STRING.getName());
        this.registerHibernateType(-3, StandardBasicTypes.BINARY.getName());
        this.registerHibernateType(-1, StandardBasicTypes.TEXT.getName());
        this.registerHibernateType(-4, StandardBasicTypes.IMAGE.getName());
        this.registerHibernateType(2, StandardBasicTypes.BIG_DECIMAL.getName());
        this.registerHibernateType(3, StandardBasicTypes.BIG_DECIMAL.getName());
        this.registerHibernateType(2004, StandardBasicTypes.BLOB.getName());
        this.registerHibernateType(2005, StandardBasicTypes.CLOB.getName());
        this.registerHibernateType(7, StandardBasicTypes.FLOAT.getName());
        this.uniqueDelegate = new DefaultUniqueDelegate(this);
    }

    public static Dialect getDialect() throws HibernateException {
        String string = Environment.getProperties().getProperty("hibernate.dialect");
        return Dialect.instantiateDialect(string);
    }

    public static Dialect getDialect(Properties properties) throws HibernateException {
        String string = properties.getProperty("hibernate.dialect");
        if (string == null) {
            return Dialect.getDialect();
        }
        return Dialect.instantiateDialect(string);
    }

    private static Dialect instantiateDialect(String string) throws HibernateException {
        if (string == null) {
            throw new HibernateException("The dialect was not set. Set the property hibernate.dialect.");
        }
        try {
            return (Dialect)ReflectHelper.classForName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("Dialect class not found: " + string);
        }
        catch (Exception exception) {
            throw new HibernateException("Could not instantiate given dialect class: " + string, exception);
        }
    }

    public final Properties getDefaultProperties() {
        return this.properties;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
    }

    public String getTypeName(int n) throws HibernateException {
        String string = this.typeNames.get(n);
        if (string == null) {
            throw new HibernateException("No default type mapping for (java.sql.Types) " + n);
        }
        return string;
    }

    public String getTypeName(int n, long l, int n2, int n3) throws HibernateException {
        String string = this.typeNames.get(n, l, n2, n3);
        if (string == null) {
            throw new HibernateException(String.format("No type mapping for java.sql.Types code: %s, length: %s", n, l));
        }
        return string;
    }

    public String getCastTypeName(int n) {
        return this.getTypeName(n, 255L, 19, 2);
    }

    public String cast(String string, int n, int n2, int n3, int n4) {
        if (n == 1) {
            return "cast(" + string + " as char(" + n2 + "))";
        }
        return "cast(" + string + "as " + this.getTypeName(n, n2, n3, n4) + ")";
    }

    public String cast(String string, int n, int n2) {
        return this.cast(string, n, n2, 19, 2);
    }

    public String cast(String string, int n, int n2, int n3) {
        return this.cast(string, n, 255, n2, n3);
    }

    protected void registerColumnType(int n, long l, String string) {
        this.typeNames.put(n, l, string);
    }

    protected void registerColumnType(int n, String string) {
        this.typeNames.put(n, string);
    }

    public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        if (sqlTypeDescriptor == null) {
            throw new IllegalArgumentException("sqlTypeDescriptor is null");
        }
        if (!sqlTypeDescriptor.canBeRemapped()) {
            return sqlTypeDescriptor;
        }
        SqlTypeDescriptor sqlTypeDescriptor2 = this.getSqlTypeDescriptorOverride(sqlTypeDescriptor.getSqlType());
        return sqlTypeDescriptor2 == null ? sqlTypeDescriptor : sqlTypeDescriptor2;
    }

    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int n) {
        ClobTypeDescriptor clobTypeDescriptor;
        switch (n) {
            case 2005: {
                clobTypeDescriptor = this.useInputStreamToInsertBlob() ? ClobTypeDescriptor.STREAM_BINDING : null;
                break;
            }
            default: {
                clobTypeDescriptor = null;
            }
        }
        return clobTypeDescriptor;
    }

    public LobMergeStrategy getLobMergeStrategy() {
        return NEW_LOCATOR_LOB_MERGE_STRATEGY;
    }

    public String getHibernateTypeName(int n) throws HibernateException {
        String string = this.hibernateTypeNames.get(n);
        if (string == null) {
            throw new HibernateException("No Hibernate type mapping for java.sql.Types code: " + n);
        }
        return string;
    }

    public String getHibernateTypeName(int n, int n2, int n3, int n4) throws HibernateException {
        String string = this.hibernateTypeNames.get(n, n2, n3, n4);
        if (string == null) {
            throw new HibernateException("No Hibernate type mapping for java.sql.Types code: " + n + ", length: " + n2);
        }
        return string;
    }

    protected void registerHibernateType(int n, long l, String string) {
        this.hibernateTypeNames.put(n, l, string);
    }

    protected void registerHibernateType(int n, String string) {
        this.hibernateTypeNames.put(n, string);
    }

    protected void registerFunction(String string, SQLFunction sQLFunction) {
        this.sqlFunctions.put(string.toLowerCase(), sQLFunction);
    }

    public final Map<String, SQLFunction> getFunctions() {
        return this.sqlFunctions;
    }

    protected void registerKeyword(String string) {
        this.sqlKeywords.add(string);
    }

    public Set<String> getKeywords() {
        return this.sqlKeywords;
    }

    public Class getNativeIdentifierGeneratorClass() {
        if (this.supportsIdentityColumns()) {
            return IdentityGenerator.class;
        }
        if (this.supportsSequences()) {
            return SequenceGenerator.class;
        }
        return TableHiLoGenerator.class;
    }

    public boolean supportsIdentityColumns() {
        return false;
    }

    public boolean supportsInsertSelectIdentity() {
        return false;
    }

    public boolean hasDataTypeInIdentityColumn() {
        return true;
    }

    public String appendIdentitySelectToInsert(String string) {
        return string;
    }

    public String getIdentitySelectString(String string, String string2, int n) throws MappingException {
        return this.getIdentitySelectString();
    }

    protected String getIdentitySelectString() throws MappingException {
        throw new MappingException(this.getClass().getName() + " does not support identity key generation");
    }

    public String getIdentityColumnString(int n) throws MappingException {
        return this.getIdentityColumnString();
    }

    protected String getIdentityColumnString() throws MappingException {
        throw new MappingException(this.getClass().getName() + " does not support identity key generation");
    }

    public String getIdentityInsertString() {
        return null;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsPooledSequences() {
        return false;
    }

    public String getSequenceNextValString(String string) throws MappingException {
        throw new MappingException(this.getClass().getName() + " does not support sequences");
    }

    public String getSelectSequenceNextValString(String string) throws MappingException {
        throw new MappingException(this.getClass().getName() + " does not support sequences");
    }

    @Deprecated
    public String[] getCreateSequenceStrings(String string) throws MappingException {
        return new String[]{this.getCreateSequenceString(string)};
    }

    public String[] getCreateSequenceStrings(String string, int n, int n2) throws MappingException {
        return new String[]{this.getCreateSequenceString(string, n, n2)};
    }

    protected String getCreateSequenceString(String string) throws MappingException {
        throw new MappingException(this.getClass().getName() + " does not support sequences");
    }

    protected String getCreateSequenceString(String string, int n, int n2) throws MappingException {
        if (this.supportsPooledSequences()) {
            return this.getCreateSequenceString(string) + " start with " + n + " increment by " + n2;
        }
        throw new MappingException(this.getClass().getName() + " does not support pooled sequences");
    }

    public String[] getDropSequenceStrings(String string) throws MappingException {
        return new String[]{this.getDropSequenceString(string)};
    }

    protected String getDropSequenceString(String string) throws MappingException {
        throw new MappingException(this.getClass().getName() + " does not support sequences");
    }

    public String getQuerySequencesString() {
        return null;
    }

    public String getSelectGUIDString() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support GUIDs");
    }

    @Deprecated
    public boolean supportsLimit() {
        return false;
    }

    @Deprecated
    public boolean supportsLimitOffset() {
        return this.supportsLimit();
    }

    @Deprecated
    public boolean supportsVariableLimit() {
        return this.supportsLimit();
    }

    @Deprecated
    public boolean bindLimitParametersInReverseOrder() {
        return false;
    }

    @Deprecated
    public boolean bindLimitParametersFirst() {
        return false;
    }

    @Deprecated
    public boolean useMaxForLimit() {
        return false;
    }

    @Deprecated
    public boolean forceLimitUsage() {
        return false;
    }

    @Deprecated
    public String getLimitString(String string, int n, int n2) {
        return this.getLimitString(string, n > 0 || this.forceLimitUsage());
    }

    @Deprecated
    protected String getLimitString(String string, boolean bl) {
        throw new UnsupportedOperationException("Paged queries not supported by " + this.getClass().getName());
    }

    @Deprecated
    public int convertToFirstRowValue(int n) {
        return n;
    }

    public LimitHandler buildLimitHandler(String string, RowSelection rowSelection) {
        return new LegacyLimitHandler(this, string, rowSelection);
    }

    public boolean supportsLockTimeouts() {
        return true;
    }

    public boolean isLockTimeoutParameterized() {
        return false;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_FORCE_INCREMENT: {
                return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_WRITE: {
                return new PessimisticWriteSelectLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_READ: {
                return new PessimisticReadSelectLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC: {
                return new OptimisticLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    public String getForUpdateString(LockOptions lockOptions) {
        LockMode lockMode = lockOptions.getLockMode();
        return this.getForUpdateString(lockMode, lockOptions.getTimeOut());
    }

    private String getForUpdateString(LockMode lockMode, int n) {
        switch (lockMode) {
            case UPGRADE: {
                return this.getForUpdateString();
            }
            case PESSIMISTIC_READ: {
                return this.getReadLockString(n);
            }
            case PESSIMISTIC_WRITE: {
                return this.getWriteLockString(n);
            }
            case PESSIMISTIC_FORCE_INCREMENT: 
            case UPGRADE_NOWAIT: 
            case FORCE: {
                return this.getForUpdateNowaitString();
            }
        }
        return "";
    }

    public String getForUpdateString(LockMode lockMode) {
        return this.getForUpdateString(lockMode, -1);
    }

    public String getForUpdateString() {
        return " for update";
    }

    public String getWriteLockString(int n) {
        return this.getForUpdateString();
    }

    public String getReadLockString(int n) {
        return this.getForUpdateString();
    }

    public boolean forUpdateOfColumns() {
        return false;
    }

    public boolean supportsOuterJoinForUpdate() {
        return true;
    }

    public String getForUpdateString(String string) {
        return this.getForUpdateString();
    }

    public String getForUpdateString(String string, LockOptions lockOptions) {
        LockMode lockMode = lockOptions.getLockMode();
        Iterator iterator = lockOptions.getAliasLockIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            LockMode lockMode2 = (LockMode)((Object)entry.getValue());
            if (!lockMode2.greaterThan(lockMode)) continue;
            lockMode = lockMode2;
        }
        lockOptions.setLockMode(lockMode);
        return this.getForUpdateString(lockOptions);
    }

    public String getForUpdateNowaitString() {
        return this.getForUpdateString();
    }

    public String getForUpdateNowaitString(String string) {
        return this.getForUpdateString(string);
    }

    @Deprecated
    public String appendLockHint(LockMode lockMode, String string) {
        return this.appendLockHint(new LockOptions(lockMode), string);
    }

    public String appendLockHint(LockOptions lockOptions, String string) {
        return string;
    }

    public String applyLocksToSql(String string, LockOptions lockOptions, Map<String, String[]> map) {
        return string + new ForUpdateFragment(this, lockOptions, map).toFragmentString();
    }

    public String getCreateTableString() {
        return "create table";
    }

    public String getCreateMultisetTableString() {
        return this.getCreateTableString();
    }

    public boolean supportsTemporaryTables() {
        return false;
    }

    public String generateTemporaryTableName(String string) {
        return "HT_" + string;
    }

    public String getCreateTemporaryTableString() {
        return "create table";
    }

    public String getCreateTemporaryTablePostfix() {
        return "";
    }

    public String getDropTemporaryTableString() {
        return "drop table";
    }

    public Boolean performTemporaryTableDDLInIsolation() {
        return null;
    }

    public boolean dropTemporaryTableAfterUse() {
        return true;
    }

    public int registerResultSetOutParameter(CallableStatement callableStatement, int n) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement callableStatement) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public boolean supportsCurrentTimestampSelection() {
        return false;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    public String getCurrentTimestampSelectString() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "current_timestamp";
    }

    @Deprecated
    public SQLExceptionConverter buildSQLExceptionConverter() {
        return null;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return null;
    }

    @Override
    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public String getSelectClauseNullString(int n) {
        return "null";
    }

    public boolean supportsUnionAll() {
        return false;
    }

    public JoinFragment createOuterJoinFragment() {
        return new ANSIJoinFragment();
    }

    public CaseFragment createCaseFragment() {
        return new ANSICaseFragment();
    }

    public String getNoColumnsInsertString() {
        return "values ( )";
    }

    public String getLowercaseFunction() {
        return "lower";
    }

    public String getCaseInsensitiveLike() {
        return "like";
    }

    public boolean supportsCaseInsensitiveLike() {
        return false;
    }

    public String transformSelectString(String string) {
        return string;
    }

    public int getMaxAliasLength() {
        return 10;
    }

    public String toBooleanValueString(boolean bl) {
        return bl ? "1" : NO_BATCH;
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public final String quote(String string) {
        if (string == null) {
            return null;
        }
        if (string.charAt(0) == '`') {
            return this.openQuote() + string.substring(1, string.length() - 1) + this.closeQuote();
        }
        return string;
    }

    public boolean hasAlterTable() {
        return true;
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public String getAddColumnString() {
        throw new UnsupportedOperationException("No add column syntax supported by " + this.getClass().getName());
    }

    public String getDropColumnString() {
        throw new UnsupportedOperationException("No drop column syntax supported by Dialect");
    }

    public String getDropForeignKeyString() {
        return " drop constraint ";
    }

    public String getTableTypeString() {
        return "";
    }

    public String getAddForeignKeyConstraintString(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(30);
        stringBuilder.append(" add constraint ").append(string).append(" foreign key (").append(StringHelper.join(", ", stringArray)).append(") references ").append(string2);
        if (!bl) {
            stringBuilder.append(" (").append(StringHelper.join(", ", stringArray2)).append(')');
        }
        return stringBuilder.toString();
    }

    public String getAddPrimaryKeyConstraintString(String string) {
        return " add constraint " + string + " primary key ";
    }

    public boolean hasSelfReferentialForeignKeyBug() {
        return false;
    }

    public String getNullColumnString() {
        return "";
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public String getTableComment(String string) {
        return "";
    }

    public String getColumnComment(String string) {
        return "";
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public String getDropTableString(String string) {
        StringBuilder stringBuilder = new StringBuilder("drop table ");
        if (this.supportsIfExistsBeforeTableName()) {
            stringBuilder.append("if exists ");
        }
        stringBuilder.append(string).append(this.getCascadeConstraintsString());
        if (this.supportsIfExistsAfterTableName()) {
            stringBuilder.append(" if exists");
        }
        return stringBuilder.toString();
    }

    public boolean supportsColumnCheck() {
        return true;
    }

    public boolean supportsTableCheck() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public String getAlterColumnDefaultValueString(String string, String string2) {
        throw new UnsupportedOperationException("No alter column default value supported by Dialect");
    }

    public String getAlterColumnNullableString(String string, boolean bl) {
        return null;
    }

    public String getAlterColumnDefinitionString(String string, String string2) {
        throw new UnsupportedOperationException("No alter column definition supported by Dialect");
    }

    public boolean supportConstraintName() {
        return true;
    }

    public String getReferenceOnUpdateDeleteString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.length() > 0) {
            stringBuffer.append(" on update ").append(string);
        }
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(" on delete ").append(string2);
        }
        return stringBuffer.toString();
    }

    public String getCrossJoinSeparator() {
        return " cross join ";
    }

    public ColumnAliasExtractor getColumnAliasExtractor() {
        return ColumnAliasExtractor.COLUMN_LABEL_EXTRACTOR;
    }

    public boolean supportsEmptyInList() {
        return true;
    }

    public boolean areStringComparisonsCaseInsensitive() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    public boolean useInputStreamToInsertBlob() {
        return true;
    }

    public boolean supportsParametersInInsertSelect() {
        return true;
    }

    public boolean replaceResultVariableInOrderByClauseWithPosition() {
        return false;
    }

    public String renderOrderByElement(String string, String string2, String string3, NullPrecedence nullPrecedence) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string2 != null) {
            stringBuilder.append(" ").append(string2);
        }
        if (string3 != null) {
            stringBuilder.append(" ").append(string3);
        }
        if (nullPrecedence != NullPrecedence.NONE) {
            stringBuilder.append(" nulls ").append(nullPrecedence.name().toLowerCase());
        }
        return stringBuilder.toString();
    }

    public boolean requiresCastingOfParametersInSelectClause() {
        return false;
    }

    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return true;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return true;
    }

    public boolean supportsSubselectAsInPredicateLHS() {
        return true;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return true;
    }

    public boolean supportsLobValueChangePropogation() {
        return true;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return true;
    }

    public boolean supportsSubqueryOnMutatingTable() {
        return true;
    }

    public boolean supportsExistsInSelect() {
        return true;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }

    public boolean supportsBindAsCallableArgument() {
        return true;
    }

    public boolean supportsTupleCounts() {
        return false;
    }

    public boolean supportsTupleDistinctCounts() {
        return true;
    }

    public int getInExpressionCountLimit() {
        return 0;
    }

    public boolean forceLobAsLastValue() {
        return false;
    }

    public boolean useFollowOnLocking() {
        return false;
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Deprecated
    public boolean supportsUnique() {
        return true;
    }

    @Deprecated
    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return true;
    }

    public boolean supportsIndexConstraintInCreateAlterTable() {
        return false;
    }

    @Deprecated
    public String getAddUniqueConstraintString(String string) {
        return " add constraint " + string + " unique ";
    }

    @Deprecated
    public boolean supportsNotNullUnique() {
        return true;
    }

    public String getNotExpression(String string) {
        return "not " + string;
    }

    public String getCreateTableInTablespaceKeyword() {
        return null;
    }

    public boolean supportPrimaryKeyTablespace() {
        return false;
    }

    public boolean createForeignKeyInCreateTable() {
        return false;
    }

    public String getIdentityColumnString(int n, int n2, int n3) throws MappingException {
        return this.getIdentityColumnString(n);
    }

    public String getLowercaseExpression(String string, String string2) {
        return this.getLowercaseFunction() + '(' + string + ')';
    }

    public String getDropPrimaryKeyString(String string) {
        return "drop constraint " + string;
    }

    public String getAddPrimaryKeyString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("add primary key(");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

