/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Method;
import org.hibernate.MappingException;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.function.AnsiTrimFunction;
import org.hibernate.dialect.function.DerbyConcatFunction;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DerbyCaseFragment;
import org.jboss.logging.Logger;

@Deprecated
public class DerbyDialect
extends DB2Dialect {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DerbyDialect.class.getName());
    private int driverVersionMajor;
    private int driverVersionMinor;

    public DerbyDialect() {
        if (this.getClass() == DerbyDialect.class) {
            LOG.deprecatedDerbyDialect();
        }
        this.registerFunction("concat", new DerbyConcatFunction());
        this.registerFunction("trim", new AnsiTrimFunction());
        this.registerColumnType(2004, "blob");
        this.determineDriverVersion();
        if (this.driverVersionMajor > 10 || this.driverVersionMajor == 10 && this.driverVersionMinor >= 7) {
            this.registerColumnType(16, "boolean");
        }
    }

    private void determineDriverVersion() {
        try {
            Class clazz = ReflectHelper.classForName("org.apache.derby.tools.sysinfo", this.getClass());
            Method method = clazz.getMethod("getMajorVersion", ReflectHelper.NO_PARAM_SIGNATURE);
            Method method2 = clazz.getMethod("getMinorVersion", ReflectHelper.NO_PARAM_SIGNATURE);
            this.driverVersionMajor = (Integer)method.invoke(null, ReflectHelper.NO_PARAMS);
            this.driverVersionMinor = (Integer)method2.invoke(null, ReflectHelper.NO_PARAMS);
        }
        catch (Exception exception) {
            LOG.unableToLoadDerbyDriver(exception.getMessage());
            this.driverVersionMajor = -1;
            this.driverVersionMinor = -1;
        }
    }

    private boolean isTenPointFiveReleaseOrNewer() {
        return this.driverVersionMajor > 10 || this.driverVersionMajor == 10 && this.driverVersionMinor >= 5;
    }

    public String getCrossJoinSeparator() {
        return ", ";
    }

    public CaseFragment createCaseFragment() {
        return new DerbyCaseFragment();
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean supportsSequences() {
        return this.driverVersionMajor > 10 || this.driverVersionMajor == 10 && this.driverVersionMinor >= 6;
    }

    public String getSequenceNextValString(String string) {
        if (this.supportsSequences()) {
            return "values next value for " + string;
        }
        throw new MappingException("Derby does not support sequence prior to release 10.6.1.0");
    }

    public boolean supportsLimit() {
        return this.isTenPointFiveReleaseOrNewer();
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return this.isTenPointFiveReleaseOrNewer();
    }

    public String getForUpdateString() {
        return " for update with rs";
    }

    public String getWriteLockString(int n) {
        return " for update with rs";
    }

    public String getReadLockString(int n) {
        return " for read only with rs";
    }

    public String getLimitString(String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 50);
        String string2 = string.toLowerCase().trim();
        int n3 = string2.lastIndexOf("for update");
        if (this.hasForUpdateClause(n3)) {
            stringBuilder.append(string.substring(0, n3 - 1));
        } else if (this.hasWithClause(string2)) {
            stringBuilder.append(string.substring(0, this.getWithIndex(string) - 1));
        } else {
            stringBuilder.append(string);
        }
        if (n == 0) {
            stringBuilder.append(" fetch first ");
        } else {
            stringBuilder.append(" offset ").append(n).append(" rows fetch next ");
        }
        stringBuilder.append(n2).append(" rows only");
        if (this.hasForUpdateClause(n3)) {
            stringBuilder.append(' ');
            stringBuilder.append(string.substring(n3));
        } else if (this.hasWithClause(string2)) {
            stringBuilder.append(' ').append(string.substring(this.getWithIndex(string)));
        }
        return stringBuilder.toString();
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    private boolean hasForUpdateClause(int n) {
        return n >= 0;
    }

    private boolean hasWithClause(String string) {
        return string.startsWith("with ", string.length() - 7);
    }

    private int getWithIndex(String string) {
        int n = string.lastIndexOf("with ");
        if (n < 0) {
            n = string.lastIndexOf("WITH ");
        }
        return n;
    }

    public String getQuerySequencesString() {
        return null;
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    public String getAlterColumnNullableString(String string, boolean bl) {
        return "alter column " + string + (!bl ? " not" : "") + " null";
    }
}

