/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Projection;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.Type;

public class SQLProjection
implements Projection {
    private final String sql;
    private final String groupBy;
    private final Type[] types;
    private String[] aliases;
    private String[] columnAliases;
    private boolean grouped;

    public String toSqlString(Criteria criteria, int n, CriteriaQuery criteriaQuery) throws HibernateException {
        return StringHelper.replace(this.sql, "{alias}", criteriaQuery.getSQLAlias(criteria));
    }

    public String toGroupSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return StringHelper.replace(this.groupBy, "{alias}", criteriaQuery.getSQLAlias(criteria));
    }

    public Type[] getTypes(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return this.types;
    }

    public String toString() {
        return this.sql;
    }

    protected SQLProjection(String string, String[] stringArray, Type[] typeArray) {
        this(string, null, stringArray, typeArray);
    }

    protected SQLProjection(String string, String string2, String[] stringArray, Type[] typeArray) {
        this.sql = string;
        this.types = typeArray;
        this.aliases = stringArray;
        this.columnAliases = stringArray;
        this.grouped = string2 != null;
        this.groupBy = string2;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String[] getColumnAliases(int n) {
        return this.columnAliases;
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public Type[] getTypes(String string, Criteria criteria, CriteriaQuery criteriaQuery) {
        return null;
    }

    public String[] getColumnAliases(String string, int n) {
        return null;
    }
}

