/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.Type;

public class SQLCriterion
implements Criterion {
    private final String sql;
    private final TypedValue[] typedValues;

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return StringHelper.replace(this.sql, "{alias}", criteriaQuery.getSQLAlias(criteria));
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return this.typedValues;
    }

    public String toString() {
        return this.sql;
    }

    protected SQLCriterion(String string, Object[] objectArray, Type[] typeArray) {
        this.sql = string;
        this.typedValues = new TypedValue[objectArray.length];
        for (int i = 0; i < this.typedValues.length; ++i) {
            this.typedValues[i] = new TypedValue(typeArray[i], objectArray[i], EntityMode.POJO);
        }
    }
}

