/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.SimpleProjection;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.Type;

public class PropertyProjection
extends SimpleProjection {
    private String propertyName;
    private boolean grouped;

    protected PropertyProjection(String string, boolean bl) {
        this.propertyName = string;
        this.grouped = bl;
    }

    protected PropertyProjection(String string) {
        this(string, false);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return this.propertyName;
    }

    public Type[] getTypes(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return new Type[]{criteriaQuery.getType(criteria, this.propertyName)};
    }

    public String toSqlString(Criteria criteria, int n, CriteriaQuery criteriaQuery) throws HibernateException {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = criteriaQuery.getColumns(this.propertyName, criteria);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]).append(" as y").append(n + i).append('_');
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public String toGroupSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        if (!this.grouped) {
            return super.toGroupSqlString(criteria, criteriaQuery);
        }
        return StringHelper.join(", ", criteriaQuery.getColumns(this.propertyName, criteria));
    }
}

