/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.util.StringHelper;

public class PropertyExpression
implements Criterion {
    private final String propertyName;
    private final String otherPropertyName;
    private final String op;
    private static final TypedValue[] NO_TYPED_VALUES = new TypedValue[0];

    protected PropertyExpression(String string, String string2, String string3) {
        this.propertyName = string;
        this.otherPropertyName = string2;
        this.op = string3;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String[] stringArray = criteriaQuery.findColumns(this.propertyName, criteria);
        String[] stringArray2 = criteriaQuery.findColumns(this.otherPropertyName, criteria);
        String string = StringHelper.join(" and ", StringHelper.add(stringArray, this.getOp(), stringArray2));
        if (stringArray.length > 1) {
            string = '(' + string + ')';
        }
        return string;
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return NO_TYPED_VALUES;
    }

    public String toString() {
        return this.propertyName + this.getOp() + this.otherPropertyName;
    }

    public String getOp() {
        return this.op;
    }
}

