/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.io.Serializable;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.NullPrecedence;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class Order
implements Serializable {
    private boolean ascending;
    private boolean ignoreCase;
    private String propertyName;
    private NullPrecedence nullPrecedence;

    public String toString() {
        return this.propertyName + ' ' + (this.ascending ? "asc" : "desc") + (this.nullPrecedence != null ? ' ' + this.nullPrecedence.name().toLowerCase() : "");
    }

    public Order ignoreCase() {
        this.ignoreCase = true;
        return this;
    }

    public Order nulls(NullPrecedence nullPrecedence) {
        this.nullPrecedence = nullPrecedence;
        return this;
    }

    protected Order(String string, boolean bl) {
        this.propertyName = string;
        this.ascending = bl;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String[] stringArray = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
        Type type = criteriaQuery.getTypeUsingProjection(criteria, this.propertyName);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            StringBuilder stringBuilder2 = new StringBuilder();
            SessionFactoryImplementor sessionFactoryImplementor = criteriaQuery.getFactory();
            boolean bl = false;
            if (this.ignoreCase) {
                int n = type.sqlTypes(sessionFactoryImplementor)[i];
                boolean bl2 = bl = n == 12 || n == 1 || n == -1;
            }
            if (bl) {
                stringBuilder2.append(sessionFactoryImplementor.getDialect().getLowercaseFunction()).append('(');
            }
            stringBuilder2.append(stringArray[i]);
            if (bl) {
                stringBuilder2.append(')');
            }
            stringBuilder.append(sessionFactoryImplementor.getDialect().renderOrderByElement(stringBuilder2.toString(), null, this.ascending ? "asc" : "desc", this.nullPrecedence != null ? this.nullPrecedence : sessionFactoryImplementor.getSettings().getDefaultNullPrecedence()));
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public static Order asc(String string) {
        return new Order(string, true);
    }

    public static Order desc(String string) {
        return new Order(string, false);
    }
}

