/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.util.StringHelper;

public class NotNullExpression
implements Criterion {
    private final String propertyName;
    private static final TypedValue[] NO_VALUES = new TypedValue[0];

    protected NotNullExpression(String string) {
        this.propertyName = string;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String[] stringArray = criteriaQuery.findColumns(this.propertyName, criteria);
        String string = StringHelper.join(" or ", StringHelper.suffix(stringArray, " is not null"));
        if (stringArray.length > 1) {
            string = '(' + string + ')';
        }
        return string;
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return NO_VALUES;
    }

    public String toString() {
        return this.propertyName + " is not null";
    }
}

