/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Junction
implements Criterion {
    private final Nature nature;
    private final List<Criterion> conditions = new ArrayList<Criterion>();

    protected Junction(Nature nature) {
        this.nature = nature;
    }

    public Junction add(Criterion criterion) {
        this.conditions.add(criterion);
        return this;
    }

    public Nature getNature() {
        return this.nature;
    }

    public Iterable<Criterion> conditions() {
        return this.conditions;
    }

    @Override
    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        ArrayList arrayList = new ArrayList();
        for (Criterion criterion : this.conditions) {
            TypedValue[] typedValueArray = criterion.getTypedValues(criteria, criteriaQuery);
            Collections.addAll(arrayList, typedValueArray);
        }
        return arrayList.toArray(new TypedValue[arrayList.size()]);
    }

    @Override
    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        if (this.conditions.size() == 0) {
            return "1=1";
        }
        StringBuilder stringBuilder = new StringBuilder().append('(');
        Iterator<Criterion> iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toSqlString(criteria, criteriaQuery));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(' ').append(this.nature.getOperator()).append(' ');
        }
        return stringBuilder.append(')').toString();
    }

    public String toString() {
        return '(' + StringHelper.join(' ' + this.nature.getOperator() + ' ', this.conditions.iterator()) + ')';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Nature {
        AND,
        OR;


        public String getOperator() {
            return this.name().toLowerCase();
        }
    }
}

