/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.util.ArrayList;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class InExpression
implements Criterion {
    private final String propertyName;
    private final Object[] values;

    protected InExpression(String string, Object[] objectArray) {
        this.propertyName = string;
        this.values = objectArray;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String[] stringArray = criteriaQuery.findColumns(this.propertyName, criteria);
        if (criteriaQuery.getFactory().getDialect().supportsRowValueConstructorSyntaxInInList() || stringArray.length <= 1) {
            String string = StringHelper.repeat("?, ", stringArray.length - 1) + "?";
            if (stringArray.length > 1) {
                string = '(' + string + ')';
            }
            String string2 = this.values.length > 0 ? StringHelper.repeat(string + ", ", this.values.length - 1) + string : "";
            String string3 = StringHelper.join(", ", stringArray);
            if (stringArray.length > 1) {
                string3 = '(' + string3 + ')';
            }
            return string3 + " in (" + string2 + ')';
        }
        String string = " ( " + StringHelper.join(" = ? and ", stringArray) + "= ? ) ";
        string = this.values.length > 0 ? StringHelper.repeat(string + "or ", this.values.length - 1) + string : "";
        string = " ( " + string + " ) ";
        return string;
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        ArrayList<TypedValue> arrayList = new ArrayList<TypedValue>();
        Type type = criteriaQuery.getTypeUsingProjection(criteria, this.propertyName);
        if (type.isComponentType()) {
            CompositeType compositeType = (CompositeType)type;
            Type[] typeArray = compositeType.getSubtypes();
            for (int i = 0; i < this.values.length; ++i) {
                for (int j = 0; j < typeArray.length; ++j) {
                    Object object = this.values[i] == null ? null : compositeType.getPropertyValues(this.values[i], EntityMode.POJO)[j];
                    arrayList.add(new TypedValue(typeArray[j], object, EntityMode.POJO));
                }
            }
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                arrayList.add(new TypedValue(type, this.values[i], EntityMode.POJO));
            }
        }
        return arrayList.toArray(new TypedValue[arrayList.size()]);
    }

    public String toString() {
        return this.propertyName + " in (" + StringHelper.toString(this.values) + ')';
    }
}

