/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.SimpleProjection;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.Type;

public class IdentifierProjection
extends SimpleProjection {
    private boolean grouped;

    protected IdentifierProjection(boolean bl) {
        this.grouped = bl;
    }

    protected IdentifierProjection() {
        this(false);
    }

    public String toString() {
        return "id";
    }

    public Type[] getTypes(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return new Type[]{criteriaQuery.getIdentifierType(criteria)};
    }

    public String toSqlString(Criteria criteria, int n, CriteriaQuery criteriaQuery) throws HibernateException {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = criteriaQuery.getIdentifierColumns(criteria);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]).append(" as y").append(n + i).append('_');
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public String toGroupSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        if (!this.grouped) {
            return super.toGroupSqlString(criteria, criteriaQuery);
        }
        return StringHelper.join(", ", criteriaQuery.getIdentifierColumns(criteria));
    }
}

