/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LikeExpression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.NullExpression;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class Example
implements Criterion {
    private final Object entity;
    private final Set excludedProperties = new HashSet();
    private PropertySelector selector;
    private boolean isLikeEnabled;
    private Character escapeCharacter;
    private boolean isIgnoreCaseEnabled;
    private MatchMode matchMode;
    private static final PropertySelector NOT_NULL = new NotNullPropertySelector();
    private static final PropertySelector ALL = new AllPropertySelector();
    private static final PropertySelector NOT_NULL_OR_ZERO = new NotNullOrZeroPropertySelector();
    private static final Object[] TYPED_VALUES = new TypedValue[0];

    public Example setEscapeCharacter(Character c) {
        this.escapeCharacter = c;
        return this;
    }

    public Example setPropertySelector(PropertySelector propertySelector) {
        this.selector = propertySelector;
        return this;
    }

    public Example excludeZeroes() {
        this.setPropertySelector(NOT_NULL_OR_ZERO);
        return this;
    }

    public Example excludeNone() {
        this.setPropertySelector(ALL);
        return this;
    }

    public Example enableLike(MatchMode matchMode) {
        this.isLikeEnabled = true;
        this.matchMode = matchMode;
        return this;
    }

    public Example enableLike() {
        return this.enableLike(MatchMode.EXACT);
    }

    public Example ignoreCase() {
        this.isIgnoreCaseEnabled = true;
        return this;
    }

    public Example excludeProperty(String string) {
        this.excludedProperties.add(string);
        return this;
    }

    public static Example create(Object object) {
        if (object == null) {
            throw new NullPointerException("null example");
        }
        return new Example(object, NOT_NULL);
    }

    protected Example(Object object, PropertySelector propertySelector) {
        this.entity = object;
        this.selector = propertySelector;
    }

    public String toString() {
        return "example (" + this.entity + ')';
    }

    private boolean isPropertyIncluded(Object object, String string, Type type) {
        return !this.excludedProperties.contains(string) && !type.isAssociationType() && this.selector.include(object, string, type);
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        StringBuilder stringBuilder = new StringBuilder().append('(');
        EntityPersister entityPersister = criteriaQuery.getFactory().getEntityPersister(criteriaQuery.getEntityName(criteria));
        String[] stringArray = entityPersister.getPropertyNames();
        Type[] typeArray = entityPersister.getPropertyTypes();
        Object[] objectArray = entityPersister.getPropertyValues(this.entity);
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl;
            Object object = objectArray[i];
            String string = stringArray[i];
            boolean bl2 = bl = i != entityPersister.getVersionProperty() && this.isPropertyIncluded(object, string, typeArray[i]);
            if (!bl) continue;
            if (typeArray[i].isComponentType()) {
                this.appendComponentCondition(string, object, (CompositeType)typeArray[i], criteria, criteriaQuery, stringBuilder);
                continue;
            }
            this.appendPropertyCondition(string, object, criteria, criteriaQuery, stringBuilder);
        }
        if (stringBuilder.length() == 1) {
            stringBuilder.append("1=1");
        }
        return stringBuilder.append(')').toString();
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        EntityPersister entityPersister = criteriaQuery.getFactory().getEntityPersister(criteriaQuery.getEntityName(criteria));
        String[] stringArray = entityPersister.getPropertyNames();
        Type[] typeArray = entityPersister.getPropertyTypes();
        Object[] objectArray = entityPersister.getPropertyValues(this.entity);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl;
            Object object = objectArray[i];
            Type type = typeArray[i];
            String string = stringArray[i];
            boolean bl2 = bl = i != entityPersister.getVersionProperty() && this.isPropertyIncluded(object, string, type);
            if (!bl) continue;
            if (typeArray[i].isComponentType()) {
                this.addComponentTypedValues(string, object, (CompositeType)type, arrayList, criteria, criteriaQuery);
                continue;
            }
            this.addPropertyTypedValue(object, type, arrayList);
        }
        return (TypedValue[])arrayList.toArray(TYPED_VALUES);
    }

    private EntityMode getEntityMode(Criteria criteria, CriteriaQuery criteriaQuery) {
        EntityPersister entityPersister = criteriaQuery.getFactory().getEntityPersister(criteriaQuery.getEntityName(criteria));
        EntityMode entityMode = entityPersister.getEntityMode();
        if (!entityPersister.getEntityMetamodel().getTuplizer().isInstance(this.entity)) {
            throw new ClassCastException(this.entity.getClass().getName());
        }
        return entityMode;
    }

    protected void addPropertyTypedValue(Object object, Type type, List list) {
        if (object != null) {
            if (object instanceof String) {
                String string = (String)object;
                if (this.isIgnoreCaseEnabled) {
                    string = string.toLowerCase();
                }
                if (this.isLikeEnabled) {
                    string = this.matchMode.toMatchString(string);
                }
                object = string;
            }
            list.add(new TypedValue(type, object, null));
        }
    }

    protected void addComponentTypedValues(String string, Object object, CompositeType compositeType, List list, Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        if (object != null) {
            String[] stringArray = compositeType.getPropertyNames();
            Type[] typeArray = compositeType.getSubtypes();
            Object[] objectArray = compositeType.getPropertyValues(object, this.getEntityMode(criteria, criteriaQuery));
            for (int i = 0; i < stringArray.length; ++i) {
                Object object2 = objectArray[i];
                Type type = typeArray[i];
                String string2 = StringHelper.qualify(string, stringArray[i]);
                if (!this.isPropertyIncluded(object2, string2, type)) continue;
                if (type.isComponentType()) {
                    this.addComponentTypedValues(string2, object2, (CompositeType)type, list, criteria, criteriaQuery);
                    continue;
                }
                this.addPropertyTypedValue(object2, type, list);
            }
        }
    }

    protected void appendPropertyCondition(String string, Object object, Criteria criteria, CriteriaQuery criteriaQuery, StringBuilder stringBuilder) throws HibernateException {
        Criterion criterion;
        if (object != null) {
            boolean bl = object instanceof String;
            criterion = this.isLikeEnabled && bl ? new LikeExpression(string, (String)object, this.matchMode, this.escapeCharacter, this.isIgnoreCaseEnabled) : new SimpleExpression(string, object, "=", this.isIgnoreCaseEnabled && bl);
        } else {
            criterion = new NullExpression(string);
        }
        String string2 = criterion.toSqlString(criteria, criteriaQuery);
        if (stringBuilder.length() > 1 && string2.trim().length() > 0) {
            stringBuilder.append(" and ");
        }
        stringBuilder.append(string2);
    }

    protected void appendComponentCondition(String string, Object object, CompositeType compositeType, Criteria criteria, CriteriaQuery criteriaQuery, StringBuilder stringBuilder) throws HibernateException {
        if (object != null) {
            String[] stringArray = compositeType.getPropertyNames();
            Object[] objectArray = compositeType.getPropertyValues(object, this.getEntityMode(criteria, criteriaQuery));
            Type[] typeArray = compositeType.getSubtypes();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object2 = objectArray[i];
                String string2 = StringHelper.qualify(string, stringArray[i]);
                if (!this.isPropertyIncluded(object2, string2, typeArray[i])) continue;
                Type type = typeArray[i];
                if (type.isComponentType()) {
                    this.appendComponentCondition(string2, object2, (CompositeType)type, criteria, criteriaQuery, stringBuilder);
                    continue;
                }
                this.appendPropertyCondition(string2, object2, criteria, criteriaQuery, stringBuilder);
            }
        }
    }

    static final class NotNullOrZeroPropertySelector
    implements PropertySelector {
        NotNullOrZeroPropertySelector() {
        }

        public boolean include(Object object, String string, Type type) {
            return object != null && (!(object instanceof Number) || ((Number)object).longValue() != 0L);
        }

        private Object readResolve() {
            return NOT_NULL_OR_ZERO;
        }
    }

    static final class NotNullPropertySelector
    implements PropertySelector {
        NotNullPropertySelector() {
        }

        public boolean include(Object object, String string, Type type) {
            return object != null;
        }

        private Object readResolve() {
            return NOT_NULL;
        }
    }

    static final class AllPropertySelector
    implements PropertySelector {
        AllPropertySelector() {
        }

        public boolean include(Object object, String string, Type type) {
            return true;
        }

        private Object readResolve() {
            return ALL;
        }
    }

    public static interface PropertySelector
    extends Serializable {
        public boolean include(Object var1, String var2, Type var3);
    }
}

