/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.util.Collections;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.SimpleProjection;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.type.Type;

public class AggregateProjection
extends SimpleProjection {
    protected final String propertyName;
    private final String functionName;

    protected AggregateProjection(String string, String string2) {
        this.functionName = string;
        this.propertyName = string2;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return this.functionName + "(" + this.propertyName + ')';
    }

    public Type[] getTypes(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return new Type[]{this.getFunction(criteriaQuery).getReturnType(criteriaQuery.getType(criteria, this.getPropertyName()), criteriaQuery.getFactory())};
    }

    public String toSqlString(Criteria criteria, int n, CriteriaQuery criteriaQuery) throws HibernateException {
        String string = this.getFunction(criteriaQuery).render(criteriaQuery.getType(criteria, this.getPropertyName()), this.buildFunctionParameterList(criteria, criteriaQuery), criteriaQuery.getFactory());
        return string + " as y" + n + '_';
    }

    protected SQLFunction getFunction(CriteriaQuery criteriaQuery) {
        return this.getFunction(this.getFunctionName(), criteriaQuery);
    }

    protected SQLFunction getFunction(String string, CriteriaQuery criteriaQuery) {
        SQLFunction sQLFunction = criteriaQuery.getFactory().getSqlFunctionRegistry().findSQLFunction(string);
        if (sQLFunction == null) {
            throw new HibernateException("Unable to locate mapping for function named [" + string + "]");
        }
        return sQLFunction;
    }

    protected List buildFunctionParameterList(Criteria criteria, CriteriaQuery criteriaQuery) {
        return this.buildFunctionParameterList(criteriaQuery.getColumn(criteria, this.getPropertyName()));
    }

    protected List buildFunctionParameterList(String string) {
        return Collections.singletonList(string);
    }
}

