/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.sql.ConditionFragment;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public abstract class AbstractEmptinessExpression
implements Criterion {
    private static final TypedValue[] NO_VALUES = new TypedValue[0];
    protected final String propertyName;

    protected AbstractEmptinessExpression(String string) {
        this.propertyName = string;
    }

    protected abstract boolean excludeEmpty();

    public final String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String string = criteriaQuery.getEntityName(criteria, this.propertyName);
        String string2 = criteriaQuery.getPropertyName(this.propertyName);
        String string3 = criteriaQuery.getSQLAlias(criteria, this.propertyName);
        SessionFactoryImplementor sessionFactoryImplementor = criteriaQuery.getFactory();
        QueryableCollection queryableCollection = this.getQueryableCollection(string, string2, sessionFactoryImplementor);
        String[] stringArray = queryableCollection.getKeyColumnNames();
        String[] stringArray2 = ((Loadable)sessionFactoryImplementor.getEntityPersister(string)).getIdentifierColumnNames();
        String string4 = "(select 1 from " + queryableCollection.getTableName() + " where " + new ConditionFragment().setTableAlias(string3).setCondition(stringArray2, stringArray).toFragmentString() + ")";
        return this.excludeEmpty() ? "exists " + string4 : "not exists " + string4;
    }

    protected QueryableCollection getQueryableCollection(String string, String string2, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        PropertyMapping propertyMapping = (PropertyMapping)((Object)sessionFactoryImplementor.getEntityPersister(string));
        Type type = propertyMapping.toType(string2);
        if (!type.isCollectionType()) {
            throw new MappingException("Property path [" + string + "." + string2 + "] does not reference a collection");
        }
        String string3 = ((CollectionType)type).getRole();
        try {
            return (QueryableCollection)sessionFactoryImplementor.getCollectionPersister(string3);
        }
        catch (ClassCastException classCastException) {
            throw new QueryException("collection role is not queryable: " + string3);
        }
        catch (Exception exception) {
            throw new QueryException("collection role not found: " + string3);
        }
    }

    public final TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return NO_VALUES;
    }

    public final String toString() {
        return this.propertyName + (this.excludeEmpty() ? " is not empty" : " is empty");
    }
}

