/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.context.spi;

import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.context.TenantIdentifierMismatchException;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.compare.EqualsHelper;

public abstract class AbstractCurrentSessionContext
implements CurrentSessionContext {
    private final SessionFactoryImplementor factory;

    protected AbstractCurrentSessionContext(SessionFactoryImplementor sessionFactoryImplementor) {
        this.factory = sessionFactoryImplementor;
    }

    public SessionFactoryImplementor factory() {
        return this.factory;
    }

    protected SessionBuilder baseSessionBuilder() {
        SessionBuilderImplementor sessionBuilderImplementor = this.factory.withOptions();
        CurrentTenantIdentifierResolver currentTenantIdentifierResolver = this.factory.getCurrentTenantIdentifierResolver();
        if (currentTenantIdentifierResolver != null) {
            sessionBuilderImplementor.tenantIdentifier(currentTenantIdentifierResolver.resolveCurrentTenantIdentifier());
        }
        return sessionBuilderImplementor;
    }

    protected void validateExistingSession(Session session) {
        CurrentTenantIdentifierResolver currentTenantIdentifierResolver = this.factory.getCurrentTenantIdentifierResolver();
        if (currentTenantIdentifierResolver != null && currentTenantIdentifierResolver.validateExistingCurrentSessions()) {
            String string = currentTenantIdentifierResolver.resolveCurrentTenantIdentifier();
            if (!EqualsHelper.equals(session.getTenantIdentifier(), string)) {
                throw new TenantIdentifierMismatchException(String.format("Reported current tenant identifier [%s] did not match tenant identifier from existing session [%s]", string, session.getTenantIdentifier()));
            }
        }
    }
}

