/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.context.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Synchronization;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.spi.AbstractCurrentSessionContext;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class ThreadLocalSessionContext
extends AbstractCurrentSessionContext {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, ThreadLocalSessionContext.class.getName());
    private static final Class[] SESSION_PROXY_INTERFACES = new Class[]{Session.class, SessionImplementor.class, EventSource.class, TransactionContext.class, LobCreationContext.class};
    private static final ThreadLocal<Map> context = new ThreadLocal();

    public ThreadLocalSessionContext(SessionFactoryImplementor sessionFactoryImplementor) {
        super(sessionFactoryImplementor);
    }

    public final Session currentSession() throws HibernateException {
        Session session = ThreadLocalSessionContext.existingSession(this.factory());
        if (session == null) {
            session = this.buildOrObtainSession();
            session.getTransaction().registerSynchronization(this.buildCleanupSynch());
            if (this.needsWrapping(session)) {
                session = this.wrap(session);
            }
            ThreadLocalSessionContext.doBind(session, this.factory());
        } else {
            this.validateExistingSession(session);
        }
        return session;
    }

    private boolean needsWrapping(Session session) {
        return session != null && !Proxy.isProxyClass(session.getClass()) || Proxy.getInvocationHandler(session) != null && !(Proxy.getInvocationHandler(session) instanceof TransactionProtectionWrapper);
    }

    protected SessionFactoryImplementor getFactory() {
        return this.factory();
    }

    protected Session buildOrObtainSession() {
        return this.baseSessionBuilder().autoClose(this.isAutoCloseEnabled()).connectionReleaseMode(this.getConnectionReleaseMode()).flushBeforeCompletion(this.isAutoFlushEnabled()).openSession();
    }

    protected CleanupSynch buildCleanupSynch() {
        return new CleanupSynch(this.factory());
    }

    protected boolean isAutoCloseEnabled() {
        return true;
    }

    protected boolean isAutoFlushEnabled() {
        return true;
    }

    protected ConnectionReleaseMode getConnectionReleaseMode() {
        return this.factory().getSettings().getConnectionReleaseMode();
    }

    protected Session wrap(Session session) {
        TransactionProtectionWrapper transactionProtectionWrapper = new TransactionProtectionWrapper(session);
        Session session2 = (Session)Proxy.newProxyInstance(Session.class.getClassLoader(), SESSION_PROXY_INTERFACES, (InvocationHandler)transactionProtectionWrapper);
        transactionProtectionWrapper.setWrapped(session2);
        return session2;
    }

    public static void bind(Session session) {
        SessionFactory sessionFactory = session.getSessionFactory();
        ThreadLocalSessionContext.cleanupAnyOrphanedSession(sessionFactory);
        ThreadLocalSessionContext.doBind(session, sessionFactory);
    }

    private static void cleanupAnyOrphanedSession(SessionFactory sessionFactory) {
        Session session = ThreadLocalSessionContext.doUnbind(sessionFactory, false);
        if (session != null) {
            LOG.alreadySessionBound();
            try {
                if (session.getTransaction() != null && session.getTransaction().isActive()) {
                    try {
                        session.getTransaction().rollback();
                    }
                    catch (Throwable throwable) {
                        LOG.debug("Unable to rollback transaction for orphaned session", throwable);
                    }
                }
                session.close();
            }
            catch (Throwable throwable) {
                LOG.debug("Unable to close orphaned session", throwable);
            }
        }
    }

    public static Session unbind(SessionFactory sessionFactory) {
        return ThreadLocalSessionContext.doUnbind(sessionFactory, true);
    }

    private static Session existingSession(SessionFactory sessionFactory) {
        Map map = ThreadLocalSessionContext.sessionMap();
        if (map == null) {
            return null;
        }
        return (Session)map.get(sessionFactory);
    }

    protected static Map sessionMap() {
        return context.get();
    }

    private static void doBind(Session session, SessionFactory sessionFactory) {
        HashMap<SessionFactory, Session> hashMap = ThreadLocalSessionContext.sessionMap();
        if (hashMap == null) {
            hashMap = new HashMap<SessionFactory, Session>();
            context.set(hashMap);
        }
        hashMap.put(sessionFactory, session);
    }

    private static Session doUnbind(SessionFactory sessionFactory, boolean bl) {
        Map map = ThreadLocalSessionContext.sessionMap();
        Session session = null;
        if (map != null) {
            session = (Session)map.remove(sessionFactory);
            if (bl && map.isEmpty()) {
                context.set(null);
            }
        }
        return session;
    }

    private class TransactionProtectionWrapper
    implements InvocationHandler,
    Serializable {
        private final Session realSession;
        private Session wrappedSession;

        public TransactionProtectionWrapper(Session session) {
            this.realSession = session;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            try {
                if ("close".equals(string)) {
                    ThreadLocalSessionContext.unbind(this.realSession.getSessionFactory());
                } else if (!("toString".equals(string) || "equals".equals(string) || "hashCode".equals(string) || "getStatistics".equals(string) || "isOpen".equals(string) || "getListeners".equals(string) || !this.realSession.isOpen() || this.realSession.getTransaction().isActive())) {
                    if ("beginTransaction".equals(string) || "getTransaction".equals(string) || "isTransactionInProgress".equals(string) || "setFlushMode".equals(string) || "getFactory".equals(string) || "getSessionFactory".equals(string) || "getTenantIdentifier".equals(string)) {
                        LOG.tracev("Allowing method [{0}] in non-transacted context", (Object)string);
                    } else if (!"reconnect".equals(string) && !"disconnect".equals(string)) {
                        throw new HibernateException(string + " is not valid without active transaction");
                    }
                }
                LOG.tracev("Allowing proxied method [{0}] to proceed to real session", (Object)string);
                return method.invoke((Object)this.realSession, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getTargetException();
                }
                throw invocationTargetException;
            }
        }

        public void setWrapped(Session session) {
            this.wrappedSession = session;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            if (ThreadLocalSessionContext.existingSession(ThreadLocalSessionContext.this.factory()) == this.wrappedSession) {
                ThreadLocalSessionContext.unbind(ThreadLocalSessionContext.this.factory());
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.realSession.getTransaction().registerSynchronization(ThreadLocalSessionContext.this.buildCleanupSynch());
            ThreadLocalSessionContext.doBind(this.wrappedSession, ThreadLocalSessionContext.this.factory());
        }
    }

    protected static class CleanupSynch
    implements Synchronization,
    Serializable {
        protected final SessionFactory factory;

        public CleanupSynch(SessionFactory sessionFactory) {
            this.factory = sessionFactory;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int n) {
            ThreadLocalSessionContext.unbind(this.factory);
        }
    }
}

