/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.context.internal;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.spi.AbstractCurrentSessionContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedSessionContext
extends AbstractCurrentSessionContext {
    private static final ThreadLocal<Map<SessionFactory, Session>> context = new ThreadLocal();

    public ManagedSessionContext(SessionFactoryImplementor sessionFactoryImplementor) {
        super(sessionFactoryImplementor);
    }

    @Override
    public Session currentSession() {
        Session session = ManagedSessionContext.existingSession(this.factory());
        if (session == null) {
            throw new HibernateException("No session currently bound to execution context");
        }
        this.validateExistingSession(session);
        return session;
    }

    public static boolean hasBind(SessionFactory sessionFactory) {
        return ManagedSessionContext.existingSession(sessionFactory) != null;
    }

    public static Session bind(Session session) {
        return ManagedSessionContext.sessionMap(true).put(session.getSessionFactory(), session);
    }

    public static Session unbind(SessionFactory sessionFactory) {
        Session session = null;
        Map<SessionFactory, Session> map = ManagedSessionContext.sessionMap();
        if (map != null) {
            session = map.remove(sessionFactory);
            ManagedSessionContext.doCleanup();
        }
        return session;
    }

    private static Session existingSession(SessionFactory sessionFactory) {
        Map<SessionFactory, Session> map = ManagedSessionContext.sessionMap();
        if (map == null) {
            return null;
        }
        return map.get(sessionFactory);
    }

    protected static Map<SessionFactory, Session> sessionMap() {
        return ManagedSessionContext.sessionMap(false);
    }

    private static synchronized Map<SessionFactory, Session> sessionMap(boolean bl) {
        Map<SessionFactory, Session> map = context.get();
        if (map == null && bl) {
            map = new HashMap<SessionFactory, Session>();
            context.set(map);
        }
        return map;
    }

    private static synchronized void doCleanup() {
        Map<SessionFactory, Session> map = ManagedSessionContext.sessionMap(false);
        if (map != null && map.isEmpty()) {
            context.set(null);
        }
    }
}

