/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.context.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.context.spi.AbstractCurrentSessionContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.jboss.logging.Logger;

public class JTASessionContext
extends AbstractCurrentSessionContext {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JTASessionContext.class.getName());
    private transient Map<Object, Session> currentSessionMap = new ConcurrentHashMap<Object, Session>();

    public JTASessionContext(SessionFactoryImplementor sessionFactoryImplementor) {
        super(sessionFactoryImplementor);
    }

    public Session currentSession() throws HibernateException {
        Transaction transaction;
        JtaPlatform jtaPlatform = this.factory().getServiceRegistry().getService(JtaPlatform.class);
        TransactionManager transactionManager = jtaPlatform.retrieveTransactionManager();
        if (transactionManager == null) {
            throw new HibernateException("No TransactionManagerLookup specified");
        }
        try {
            transaction = transactionManager.getTransaction();
            if (transaction == null) {
                throw new HibernateException("Unable to locate current JTA transaction");
            }
            if (!JtaStatusHelper.isActive(transaction.getStatus())) {
                throw new HibernateException("Current transaction is not in progress");
            }
        }
        catch (HibernateException hibernateException) {
            throw hibernateException;
        }
        catch (Throwable throwable) {
            throw new HibernateException("Problem locating/validating JTA transaction", throwable);
        }
        Object object = jtaPlatform.getTransactionIdentifier(transaction);
        Session session = this.currentSessionMap.get(object);
        if (session == null) {
            session = this.buildOrObtainSession();
            try {
                transaction.registerSynchronization(this.buildCleanupSynch(object));
            }
            catch (Throwable throwable) {
                try {
                    session.close();
                }
                catch (Throwable throwable2) {
                    LOG.debug("Unable to release generated current-session on failed synch registration", throwable2);
                }
                throw new HibernateException("Unable to register cleanup Synchronization with TransactionManager");
            }
            this.currentSessionMap.put(object, session);
        } else {
            this.validateExistingSession(session);
        }
        return session;
    }

    private CleanupSynch buildCleanupSynch(Object object) {
        return new CleanupSynch(object, this);
    }

    protected Session buildOrObtainSession() {
        return this.baseSessionBuilder().autoClose(this.isAutoCloseEnabled()).connectionReleaseMode(this.getConnectionReleaseMode()).flushBeforeCompletion(this.isAutoFlushEnabled()).openSession();
    }

    protected boolean isAutoCloseEnabled() {
        return true;
    }

    protected boolean isAutoFlushEnabled() {
        return true;
    }

    protected ConnectionReleaseMode getConnectionReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    protected static class CleanupSynch
    implements Synchronization {
        private Object transactionIdentifier;
        private JTASessionContext context;

        public CleanupSynch(Object object, JTASessionContext jTASessionContext) {
            this.transactionIdentifier = object;
            this.context = jTASessionContext;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int n) {
            this.context.currentSessionMap.remove(this.transactionIdentifier);
        }
    }
}

