/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeMap;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.collection.internal.PersistentSet;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.collection.BasicCollectionPersister;

public class PersistentSortedSet
extends PersistentSet
implements SortedSet {
    protected Comparator comparator;

    protected Serializable snapshot(BasicCollectionPersister basicCollectionPersister, EntityMode entityMode) throws HibernateException {
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(this.comparator);
        Iterator iterator = this.set.iterator();
        while (iterator.hasNext()) {
            Object object = basicCollectionPersister.getElementType().deepCopy(iterator.next(), basicCollectionPersister.getFactory());
            treeMap.put(object, object);
        }
        return treeMap;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public PersistentSortedSet(SessionImplementor sessionImplementor) {
        super(sessionImplementor);
    }

    public PersistentSortedSet(SessionImplementor sessionImplementor, SortedSet sortedSet) {
        super(sessionImplementor, sortedSet);
        this.comparator = sortedSet.comparator();
    }

    public PersistentSortedSet() {
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public SortedSet subSet(Object object, Object object2) {
        this.read();
        SortedSet<Object> sortedSet = ((SortedSet)this.set).subSet(object, object2);
        return new SubSetProxy(sortedSet);
    }

    public SortedSet headSet(Object object) {
        this.read();
        SortedSet<Object> sortedSet = ((SortedSet)this.set).headSet(object);
        return new SubSetProxy(sortedSet);
    }

    public SortedSet tailSet(Object object) {
        this.read();
        SortedSet<Object> sortedSet = ((SortedSet)this.set).tailSet(object);
        return new SubSetProxy(sortedSet);
    }

    public Object first() {
        this.read();
        return ((SortedSet)this.set).first();
    }

    public Object last() {
        this.read();
        return ((SortedSet)this.set).last();
    }

    class SubSetProxy
    extends AbstractPersistentCollection.SetProxy
    implements SortedSet {
        SubSetProxy(SortedSet sortedSet) {
            super(PersistentSortedSet.this, sortedSet);
        }

        public Comparator comparator() {
            return ((SortedSet)this.set).comparator();
        }

        public Object first() {
            return ((SortedSet)this.set).first();
        }

        public SortedSet headSet(Object object) {
            return new SubSetProxy(((SortedSet)this.set).headSet(object));
        }

        public Object last() {
            return ((SortedSet)this.set).last();
        }

        public SortedSet subSet(Object object, Object object2) {
            return new SubSetProxy(((SortedSet)this.set).subSet(object, object2));
        }

        public SortedSet tailSet(Object object) {
            return new SubSetProxy(((SortedSet)this.set).tailSet(object));
        }
    }
}

