/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

public class PersistentMap
extends AbstractPersistentCollection
implements Map {
    protected Map map;
    private transient List<Object[]> loadingEntries;

    public PersistentMap() {
    }

    public PersistentMap(SessionImplementor sessionImplementor) {
        super(sessionImplementor);
    }

    public PersistentMap(SessionImplementor sessionImplementor, Map map) {
        super(sessionImplementor);
        this.map = map;
        this.setInitialized();
        this.setDirectlyAccessible(true);
    }

    public Serializable getSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        HashMap hashMap = new HashMap(this.map.size());
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            Object object = collectionPersister.getElementType().deepCopy(entry2.getValue(), collectionPersister.getFactory());
            hashMap.put(entry2.getKey(), object);
        }
        return hashMap;
    }

    public Collection getOrphans(Serializable serializable, String string) throws HibernateException {
        Map map = (Map)((Object)serializable);
        return PersistentMap.getOrphans(map.values(), this.map.values(), string, this.getSession());
    }

    public boolean equalsSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        Type type = collectionPersister.getElementType();
        Map map = (Map)((Object)this.getSnapshot());
        if (map.size() != this.map.size()) {
            return false;
        }
        for (Map.Entry entry : this.map.entrySet()) {
            if (!type.isDirty(entry.getValue(), map.get(entry.getKey()), this.getSession())) continue;
            return false;
        }
        return true;
    }

    public boolean isSnapshotEmpty(Serializable serializable) {
        return ((Map)((Object)serializable)).isEmpty();
    }

    public boolean isWrapper(Object object) {
        return this.map == object;
    }

    public void beforeInitialize(CollectionPersister collectionPersister, int n) {
        this.map = (Map)collectionPersister.getCollectionType().instantiate(n);
    }

    public int size() {
        return this.readSize() ? this.getCachedSize() : this.map.size();
    }

    public boolean isEmpty() {
        return this.readSize() ? this.getCachedSize() == 0 : this.map.isEmpty();
    }

    public boolean containsKey(Object object) {
        Boolean bl = this.readIndexExistence(object);
        return bl == null ? this.map.containsKey(object) : bl.booleanValue();
    }

    public boolean containsValue(Object object) {
        Boolean bl = this.readElementExistence(object);
        return bl == null ? this.map.containsValue(object) : bl.booleanValue();
    }

    public Object get(Object object) {
        Object object2 = this.readElementByIndex(object);
        return object2 == UNKNOWN ? this.map.get(object) : object2;
    }

    public Object put(Object object, Object object2) {
        Object object3;
        if (this.isPutQueueEnabled() && (object3 = this.readElementByIndex(object)) != UNKNOWN) {
            this.queueOperation(new Put(object, object2, object3));
            return object3;
        }
        this.initialize(true);
        object3 = this.map.put(object, object2);
        if (object2 != object3) {
            this.dirty();
        }
        return object3;
    }

    public Object remove(Object object) {
        Object object2;
        if (this.isPutQueueEnabled() && (object2 = this.readElementByIndex(object)) != UNKNOWN) {
            this.queueOperation(new Remove(object, object2));
            return object2;
        }
        this.initialize(true);
        if (this.map.containsKey(object)) {
            this.dirty();
        }
        return this.map.remove(object);
    }

    public void putAll(Map map) {
        if (map.size() > 0) {
            this.initialize(true);
            for (Map.Entry entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void clear() {
        if (this.isClearQueueEnabled()) {
            this.queueOperation(new Clear());
        } else {
            this.initialize(true);
            if (!this.map.isEmpty()) {
                this.dirty();
                this.map.clear();
            }
        }
    }

    public Set keySet() {
        this.read();
        return new AbstractPersistentCollection.SetProxy(this, this.map.keySet());
    }

    public Collection values() {
        this.read();
        return new AbstractPersistentCollection.SetProxy(this, this.map.values());
    }

    public Set entrySet() {
        this.read();
        return new EntrySetProxy(this.map.entrySet());
    }

    public boolean empty() {
        return this.map.isEmpty();
    }

    public String toString() {
        this.read();
        return this.map.toString();
    }

    public Object readFrom(ResultSet resultSet, CollectionPersister collectionPersister, CollectionAliases collectionAliases, Object object) throws HibernateException, SQLException {
        Object object2 = collectionPersister.readElement(resultSet, object, collectionAliases.getSuffixedElementAliases(), this.getSession());
        if (object2 != null) {
            Object object3 = collectionPersister.readIndex(resultSet, collectionAliases.getSuffixedIndexAliases(), this.getSession());
            if (this.loadingEntries == null) {
                this.loadingEntries = new ArrayList<Object[]>();
            }
            this.loadingEntries.add(new Object[]{object3, object2});
        }
        return object2;
    }

    public boolean endRead() {
        if (this.loadingEntries != null) {
            for (Object[] objectArray : this.loadingEntries) {
                this.map.put(objectArray[0], objectArray[1]);
            }
            this.loadingEntries = null;
        }
        return super.endRead();
    }

    public Iterator entries(CollectionPersister collectionPersister) {
        return this.map.entrySet().iterator();
    }

    public void initializeFromCache(CollectionPersister collectionPersister, Serializable serializable, Object object) throws HibernateException {
        Serializable[] serializableArray = (Serializable[])serializable;
        int n = serializableArray.length;
        this.beforeInitialize(collectionPersister, n);
        for (int i = 0; i < n; i += 2) {
            this.map.put(collectionPersister.getIndexType().assemble(serializableArray[i], this.getSession(), object), collectionPersister.getElementType().assemble(serializableArray[i + 1], this.getSession(), object));
        }
    }

    public Serializable disassemble(CollectionPersister collectionPersister) throws HibernateException {
        Serializable[] serializableArray = new Serializable[this.map.size() * 2];
        Iterator iterator = this.map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            serializableArray[n++] = collectionPersister.getIndexType().disassemble(entry.getKey(), this.getSession(), null);
            serializableArray[n++] = collectionPersister.getElementType().disassemble(entry.getValue(), this.getSession(), null);
        }
        return serializableArray;
    }

    public Iterator getDeletes(CollectionPersister collectionPersister, boolean bl) throws HibernateException {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : ((Map)((Object)this.getSnapshot())).entrySet()) {
            Object k = entry.getKey();
            if (entry.getValue() == null || this.map.get(k) != null) continue;
            arrayList.add(bl ? entry.getValue() : k);
        }
        return arrayList.iterator();
    }

    public boolean needsInserting(Object object, int n, Type type) throws HibernateException {
        Map map = (Map)((Object)this.getSnapshot());
        Map.Entry entry = (Map.Entry)object;
        return entry.getValue() != null && map.get(entry.getKey()) == null;
    }

    public boolean needsUpdating(Object object, int n, Type type) throws HibernateException {
        Map map = (Map)((Object)this.getSnapshot());
        Map.Entry entry = (Map.Entry)object;
        Object v = map.get(entry.getKey());
        return entry.getValue() != null && v != null && type.isDirty(v, entry.getValue(), this.getSession());
    }

    public Object getIndex(Object object, int n, CollectionPersister collectionPersister) {
        return ((Map.Entry)object).getKey();
    }

    public Object getElement(Object object) {
        return ((Map.Entry)object).getValue();
    }

    public Object getSnapshotElement(Object object, int n) {
        Map map = (Map)((Object)this.getSnapshot());
        return map.get(((Map.Entry)object).getKey());
    }

    public boolean equals(Object object) {
        this.read();
        return this.map.equals(object);
    }

    public int hashCode() {
        this.read();
        return this.map.hashCode();
    }

    public boolean entryExists(Object object, int n) {
        return ((Map.Entry)object).getValue() != null;
    }

    final class Remove
    implements AbstractPersistentCollection.DelayedOperation {
        private Object index;
        private Object old;

        public Remove(Object object, Object object2) {
            this.index = object;
            this.old = object2;
        }

        public void operate() {
            PersistentMap.this.map.remove(this.index);
        }

        public Object getAddedInstance() {
            return null;
        }

        public Object getOrphan() {
            return this.old;
        }
    }

    final class Put
    implements AbstractPersistentCollection.DelayedOperation {
        private Object index;
        private Object value;
        private Object old;

        public Put(Object object, Object object2, Object object3) {
            this.index = object;
            this.value = object2;
            this.old = object3;
        }

        public void operate() {
            PersistentMap.this.map.put(this.index, this.value);
        }

        public Object getAddedInstance() {
            return this.value;
        }

        public Object getOrphan() {
            return this.old;
        }
    }

    final class Clear
    implements AbstractPersistentCollection.DelayedOperation {
        Clear() {
        }

        public void operate() {
            PersistentMap.this.map.clear();
        }

        public Object getAddedInstance() {
            return null;
        }

        public Object getOrphan() {
            throw new UnsupportedOperationException("queued clear cannot be used with orphan delete");
        }
    }

    final class MapEntryProxy
    implements Map.Entry {
        private final Map.Entry me;

        MapEntryProxy(Map.Entry entry) {
            this.me = entry;
        }

        public Object getKey() {
            return this.me.getKey();
        }

        public Object getValue() {
            return this.me.getValue();
        }

        public boolean equals(Object object) {
            return this.me.equals(object);
        }

        public int hashCode() {
            return this.me.hashCode();
        }

        public Object setValue(Object object) {
            PersistentMap.this.write();
            return this.me.setValue(object);
        }
    }

    final class EntryIteratorProxy
    implements Iterator {
        private final Iterator iter;

        EntryIteratorProxy(Iterator iterator) {
            this.iter = iterator;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return new MapEntryProxy((Map.Entry)this.iter.next());
        }

        public void remove() {
            PersistentMap.this.write();
            this.iter.remove();
        }
    }

    class EntrySetProxy
    implements Set {
        private final Set set;

        EntrySetProxy(Set set) {
            this.set = set;
        }

        public boolean add(Object object) {
            return this.set.add(object);
        }

        public boolean addAll(Collection collection) {
            return this.set.addAll(collection);
        }

        public void clear() {
            PersistentMap.this.write();
            this.set.clear();
        }

        public boolean contains(Object object) {
            return this.set.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.set.containsAll(collection);
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public Iterator iterator() {
            return new EntryIteratorProxy(this.set.iterator());
        }

        public boolean remove(Object object) {
            PersistentMap.this.write();
            return this.set.remove(object);
        }

        public boolean removeAll(Collection collection) {
            PersistentMap.this.write();
            return this.set.removeAll(collection);
        }

        public boolean retainAll(Collection collection) {
            PersistentMap.this.write();
            return this.set.retainAll(collection);
        }

        public int size() {
            return this.set.size();
        }

        public Object[] toArray() {
            return this.set.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.set.toArray(objectArray);
        }
    }
}

