/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class PersistentList
extends AbstractPersistentCollection
implements List {
    protected List list;
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, PersistentList.class.getName());
    private int _nullCount = 0;
    private String _roleName = null;

    public Serializable getSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        EntityMode entityMode = collectionPersister.getOwnerEntityPersister().getEntityMode();
        ArrayList<Object> arrayList = new ArrayList<Object>(this.list.size());
        for (Object e : this.list) {
            Object object = collectionPersister.getElementType().deepCopy(e, collectionPersister.getFactory());
            arrayList.add(object);
        }
        return arrayList;
    }

    public Collection getOrphans(Serializable serializable, String string) throws HibernateException {
        List list = (List)((Object)serializable);
        return PersistentList.getOrphans(list, this.list, string, this.getSession());
    }

    public boolean equalsSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        Type type = collectionPersister.getElementType();
        List list = (List)((Object)this.getSnapshot());
        if (list.size() != this.list.size()) {
            return false;
        }
        Iterator iterator = this.list.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            if (!type.isDirty(iterator.next(), iterator2.next(), this.getSession())) continue;
            return false;
        }
        return true;
    }

    public boolean isSnapshotEmpty(Serializable serializable) {
        return ((Collection)((Object)serializable)).isEmpty();
    }

    public PersistentList(SessionImplementor sessionImplementor) {
        super(sessionImplementor);
    }

    public PersistentList(SessionImplementor sessionImplementor, List list) {
        super(sessionImplementor);
        this.list = list;
        this.setInitialized();
        this.setDirectlyAccessible(true);
    }

    public void beforeInitialize(CollectionPersister collectionPersister, int n) {
        this.list = (List)collectionPersister.getCollectionType().instantiate(n);
    }

    public boolean isWrapper(Object object) {
        return this.list == object;
    }

    public PersistentList() {
    }

    public int size() {
        return this.readSize() ? this.getCachedSize() : this.list.size();
    }

    public boolean isEmpty() {
        return this.readSize() ? this.getCachedSize() == 0 : this.list.isEmpty();
    }

    public boolean contains(Object object) {
        Boolean bl = this.readElementExistence(object);
        return bl == null ? this.list.contains(object) : bl.booleanValue();
    }

    public Iterator iterator() {
        this.read();
        return new AbstractPersistentCollection.IteratorProxy(this, this.list.iterator());
    }

    public Object[] toArray() {
        this.read();
        return this.list.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        this.read();
        return this.list.toArray(objectArray);
    }

    public boolean add(Object object) {
        if (!this.isOperationQueueEnabled()) {
            this.write();
            return this.list.add(object);
        }
        this.queueOperation(new SimpleAdd(object));
        return true;
    }

    public boolean remove(Object object) {
        Boolean bl;
        Boolean bl2 = bl = this.isPutQueueEnabled() ? this.readElementExistence(object) : null;
        if (bl == null) {
            this.initialize(true);
            if (this.list.remove(object)) {
                this.dirty();
                return true;
            }
            return false;
        }
        if (bl.booleanValue()) {
            this.queueOperation(new SimpleRemove(object));
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        this.read();
        return this.list.containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        if (collection.size() == 0) {
            return false;
        }
        if (!this.isOperationQueueEnabled()) {
            this.write();
            return this.list.addAll(collection);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.queueOperation(new SimpleAdd(iterator.next()));
        }
        return collection.size() > 0;
    }

    public boolean addAll(int n, Collection collection) {
        if (collection.size() > 0) {
            this.write();
            return this.list.addAll(n, collection);
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        if (collection.size() > 0) {
            this.initialize(true);
            if (this.list.removeAll(collection)) {
                this.dirty();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean retainAll(Collection collection) {
        this.initialize(true);
        if (this.list.retainAll(collection)) {
            this.dirty();
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.isClearQueueEnabled()) {
            this.queueOperation(new Clear());
        } else {
            this.initialize(true);
            if (!this.list.isEmpty()) {
                this.list.clear();
                this.dirty();
            }
        }
    }

    public Object get(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("negative index");
        }
        Object object = this.readElementByIndex(n);
        return object == UNKNOWN ? this.list.get(n) : object;
    }

    public Object set(int n, Object object) {
        Object object2;
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("negative index");
        }
        Object object3 = object2 = this.isPutQueueEnabled() ? this.readElementByIndex(n) : UNKNOWN;
        if (object2 == UNKNOWN) {
            this.write();
            return this.list.set(n, object);
        }
        this.queueOperation(new Set(n, object, object2));
        return object2;
    }

    public void add(int n, Object object) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("negative index");
        }
        if (!this.isOperationQueueEnabled()) {
            this.write();
            this.list.add(n, object);
        } else {
            this.queueOperation(new Add(n, object));
        }
    }

    public Object remove(int n) {
        Object object;
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("negative index");
        }
        Object object2 = object = this.isPutQueueEnabled() ? this.readElementByIndex(n) : UNKNOWN;
        if (object == UNKNOWN) {
            this.write();
            return this.list.remove(n);
        }
        this.queueOperation(new Remove(n, object));
        return object;
    }

    public int indexOf(Object object) {
        this.read();
        return this.list.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        this.read();
        return this.list.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this, this.list.listIterator());
    }

    public ListIterator listIterator(int n) {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this, this.list.listIterator(n));
    }

    public List subList(int n, int n2) {
        this.read();
        return new AbstractPersistentCollection.ListProxy(this, this.list.subList(n, n2));
    }

    public boolean empty() {
        return this.list.isEmpty();
    }

    public String toString() {
        this.read();
        return this.list.toString();
    }

    public Object readFrom(ResultSet resultSet, CollectionPersister collectionPersister, CollectionAliases collectionAliases, Object object) throws HibernateException, SQLException {
        Object object2 = collectionPersister.readElement(resultSet, object, collectionAliases.getSuffixedElementAliases(), this.getSession());
        int n = (Integer)collectionPersister.readIndex(resultSet, collectionAliases.getSuffixedIndexAliases(), this.getSession());
        for (int i = this.list.size(); i <= n; ++i) {
            this.list.add(i, null);
            ++this._nullCount;
        }
        if (this.list.get(n) == null) {
            --this._nullCount;
        } else {
            LOG.warn("Duplicated index (" + n + ") in list " + this.getRoleName(collectionPersister.getCollectionMetadata().getRole()) + ", list entry will be overwritten!");
        }
        if (this._nullCount > 0 && this._roleName == null) {
            this._roleName = this.getRoleName(collectionPersister.getCollectionMetadata().getRole());
        }
        this.list.set(n, object2);
        return object2;
    }

    public Iterator entries(CollectionPersister collectionPersister) {
        return this.list.iterator();
    }

    public void initializeFromCache(CollectionPersister collectionPersister, Serializable serializable, Object object) throws HibernateException {
        Serializable[] serializableArray = (Serializable[])serializable;
        int n = serializableArray.length;
        this.beforeInitialize(collectionPersister, n);
        for (int i = 0; i < n; ++i) {
            this.list.add(collectionPersister.getElementType().assemble(serializableArray[i], this.getSession(), object));
        }
    }

    public Serializable disassemble(CollectionPersister collectionPersister) throws HibernateException {
        int n = this.list.size();
        Serializable[] serializableArray = new Serializable[n];
        for (int i = 0; i < n; ++i) {
            serializableArray[i] = collectionPersister.getElementType().disassemble(this.list.get(i), this.getSession(), null);
        }
        return serializableArray;
    }

    public Iterator getDeletes(CollectionPersister collectionPersister, boolean bl) throws HibernateException {
        int n;
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List list = (List)((Object)this.getSnapshot());
        if (list.size() > this.list.size()) {
            for (n2 = this.list.size(); n2 < list.size(); ++n2) {
                arrayList.add((Integer)(bl ? list.get(n2) : Integer.valueOf(n2)));
            }
            n = this.list.size();
        } else {
            n = list.size();
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (this.list.get(n2) != null || list.get(n2) == null) continue;
            arrayList.add((Integer)(bl ? list.get(n2) : Integer.valueOf(n2)));
        }
        return arrayList.iterator();
    }

    public boolean needsInserting(Object object, int n, Type type) throws HibernateException {
        List list = (List)((Object)this.getSnapshot());
        return this.list.get(n) != null && (n >= list.size() || list.get(n) == null);
    }

    public boolean needsUpdating(Object object, int n, Type type) throws HibernateException {
        List list = (List)((Object)this.getSnapshot());
        return n < list.size() && list.get(n) != null && this.list.get(n) != null && type.isDirty(this.list.get(n), list.get(n), this.getSession());
    }

    public Object getIndex(Object object, int n, CollectionPersister collectionPersister) {
        return n;
    }

    public Object getElement(Object object) {
        return object;
    }

    public Object getSnapshotElement(Object object, int n) {
        List list = (List)((Object)this.getSnapshot());
        return list.get(n);
    }

    public boolean equals(Object object) {
        this.read();
        return this.list.equals(object);
    }

    public int hashCode() {
        this.read();
        return this.list.hashCode();
    }

    public boolean entryExists(Object object, int n) {
        return object != null;
    }

    public boolean endRead() {
        if (this._nullCount > 0) {
            if (this._nullCount == 1) {
                LOG.warn(this._nullCount + " null entry found in list " + this._roleName + "!");
            } else {
                LOG.warn(this._nullCount + " null entries found in list " + this._roleName + "!");
            }
        }
        return super.endRead();
    }

    private String getRoleName(String string) {
        return string.replaceAll("\\.ORM_", "\\.");
    }

    final class SimpleRemove
    implements AbstractPersistentCollection.DelayedOperation {
        private Object value;

        public SimpleRemove(Object object) {
            this.value = object;
        }

        public void operate() {
            PersistentList.this.list.remove(this.value);
        }

        public Object getAddedInstance() {
            return null;
        }

        public Object getOrphan() {
            return this.value;
        }
    }

    final class Remove
    implements AbstractPersistentCollection.DelayedOperation {
        private int index;
        private Object old;

        public Remove(int n, Object object) {
            this.index = n;
            this.old = object;
        }

        public void operate() {
            PersistentList.this.list.remove(this.index);
        }

        public Object getAddedInstance() {
            return null;
        }

        public Object getOrphan() {
            return this.old;
        }
    }

    final class Set
    implements AbstractPersistentCollection.DelayedOperation {
        private int index;
        private Object value;
        private Object old;

        public Set(int n, Object object, Object object2) {
            this.index = n;
            this.value = object;
            this.old = object2;
        }

        public void operate() {
            PersistentList.this.list.set(this.index, this.value);
        }

        public Object getAddedInstance() {
            return this.value;
        }

        public Object getOrphan() {
            return this.old;
        }
    }

    final class Add
    implements AbstractPersistentCollection.DelayedOperation {
        private int index;
        private Object value;

        public Add(int n, Object object) {
            this.index = n;
            this.value = object;
        }

        public void operate() {
            PersistentList.this.list.add(this.index, this.value);
        }

        public Object getAddedInstance() {
            return this.value;
        }

        public Object getOrphan() {
            return null;
        }
    }

    final class SimpleAdd
    implements AbstractPersistentCollection.DelayedOperation {
        private Object value;

        public SimpleAdd(Object object) {
            this.value = object;
        }

        public void operate() {
            PersistentList.this.list.add(this.value);
        }

        public Object getAddedInstance() {
            return this.value;
        }

        public Object getOrphan() {
            return null;
        }
    }

    final class Clear
    implements AbstractPersistentCollection.DelayedOperation {
        Clear() {
        }

        public void operate() {
            PersistentList.this.list.clear();
        }

        public Object getAddedInstance() {
            return null;
        }

        public Object getOrphan() {
            throw new UnsupportedOperationException("queued clear cannot be used with orphan delete");
        }
    }
}

