/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

public class PersistentIdentifierBag
extends AbstractPersistentCollection
implements List {
    protected List values;
    protected Map identifiers;

    public PersistentIdentifierBag(SessionImplementor sessionImplementor) {
        super(sessionImplementor);
    }

    public PersistentIdentifierBag() {
    }

    public PersistentIdentifierBag(SessionImplementor sessionImplementor, Collection collection) {
        super(sessionImplementor);
        if (collection instanceof List) {
            this.values = (List)collection;
        } else {
            this.values = new ArrayList();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.values.add(iterator.next());
            }
        }
        this.setInitialized();
        this.setDirectlyAccessible(true);
        this.identifiers = new HashMap();
    }

    public void initializeFromCache(CollectionPersister collectionPersister, Serializable serializable, Object object) throws HibernateException {
        Serializable[] serializableArray = (Serializable[])serializable;
        int n = serializableArray.length;
        this.beforeInitialize(collectionPersister, n);
        for (int i = 0; i < n; i += 2) {
            this.identifiers.put(i / 2, collectionPersister.getIdentifierType().assemble(serializableArray[i], this.getSession(), object));
            this.values.add(collectionPersister.getElementType().assemble(serializableArray[i + 1], this.getSession(), object));
        }
    }

    public Object getIdentifier(Object object, int n) {
        return this.identifiers.get(n);
    }

    public boolean isWrapper(Object object) {
        return this.values == object;
    }

    public boolean add(Object object) {
        this.write();
        this.values.add(object);
        return true;
    }

    public void clear() {
        this.initialize(true);
        if (!this.values.isEmpty() || !this.identifiers.isEmpty()) {
            this.values.clear();
            this.identifiers.clear();
            this.dirty();
        }
    }

    public boolean contains(Object object) {
        this.read();
        return this.values.contains(object);
    }

    public boolean containsAll(Collection collection) {
        this.read();
        return this.values.containsAll(collection);
    }

    public boolean isEmpty() {
        return this.readSize() ? this.getCachedSize() == 0 : this.values.isEmpty();
    }

    public Iterator iterator() {
        this.read();
        return new AbstractPersistentCollection.IteratorProxy(this, this.values.iterator());
    }

    public boolean remove(Object object) {
        this.initialize(true);
        int n = this.values.indexOf(object);
        if (n >= 0) {
            this.beforeRemove(n);
            this.values.remove(n);
            this.dirty();
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        if (collection.size() > 0) {
            boolean bl = false;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!this.remove(iterator.next())) continue;
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public boolean retainAll(Collection collection) {
        this.initialize(true);
        if (this.values.retainAll(collection)) {
            this.dirty();
            return true;
        }
        return false;
    }

    public int size() {
        return this.readSize() ? this.getCachedSize() : this.values.size();
    }

    public Object[] toArray() {
        this.read();
        return this.values.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        this.read();
        return this.values.toArray(objectArray);
    }

    public void beforeInitialize(CollectionPersister collectionPersister, int n) {
        this.identifiers = n <= 0 ? new HashMap() : new HashMap(n + 1 + (int)((float)n * 0.75f), 0.75f);
        this.values = n <= 0 ? new ArrayList() : new ArrayList(n);
    }

    public Serializable disassemble(CollectionPersister collectionPersister) throws HibernateException {
        Serializable[] serializableArray = new Serializable[this.values.size() * 2];
        int n = 0;
        for (int i = 0; i < this.values.size(); ++i) {
            Object e = this.values.get(i);
            serializableArray[n++] = collectionPersister.getIdentifierType().disassemble(this.identifiers.get(i), this.getSession(), null);
            serializableArray[n++] = collectionPersister.getElementType().disassemble(e, this.getSession(), null);
        }
        return serializableArray;
    }

    public boolean empty() {
        return this.values.isEmpty();
    }

    public Iterator entries(CollectionPersister collectionPersister) {
        return this.values.iterator();
    }

    public boolean entryExists(Object object, int n) {
        return object != null;
    }

    public boolean equalsSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        Type type = collectionPersister.getElementType();
        Map map = (Map)((Object)this.getSnapshot());
        if (map.size() != this.values.size()) {
            return false;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            Object e = this.values.get(i);
            Object v = this.identifiers.get(i);
            if (v == null) {
                return false;
            }
            Object v2 = map.get(v);
            if (!type.isDirty(v2, e, this.getSession())) continue;
            return false;
        }
        return true;
    }

    public boolean isSnapshotEmpty(Serializable serializable) {
        return ((Map)((Object)serializable)).isEmpty();
    }

    public Iterator getDeletes(CollectionPersister collectionPersister, boolean bl) throws HibernateException {
        Map map = (Map)((Object)this.getSnapshot());
        ArrayList arrayList = new ArrayList(map.keySet());
        for (int i = 0; i < this.values.size(); ++i) {
            if (this.values.get(i) == null) continue;
            arrayList.remove(this.identifiers.get(i));
        }
        return arrayList.iterator();
    }

    public Object getIndex(Object object, int n, CollectionPersister collectionPersister) {
        throw new UnsupportedOperationException("Bags don't have indexes");
    }

    public Object getElement(Object object) {
        return object;
    }

    public Object getSnapshotElement(Object object, int n) {
        Map map = (Map)((Object)this.getSnapshot());
        Object v = this.identifiers.get(n);
        return map.get(v);
    }

    public boolean needsInserting(Object object, int n, Type type) throws HibernateException {
        Map map = (Map)((Object)this.getSnapshot());
        Object v = this.identifiers.get(n);
        return object != null && (v == null || map.get(v) == null);
    }

    public boolean needsUpdating(Object object, int n, Type type) throws HibernateException {
        if (object == null) {
            return false;
        }
        Map map = (Map)((Object)this.getSnapshot());
        Object v = this.identifiers.get(n);
        if (v == null) {
            return false;
        }
        Object v2 = map.get(v);
        return v2 != null && type.isDirty(v2, object, this.getSession());
    }

    public Object readFrom(ResultSet resultSet, CollectionPersister collectionPersister, CollectionAliases collectionAliases, Object object) throws HibernateException, SQLException {
        Object object2 = collectionPersister.readElement(resultSet, object, collectionAliases.getSuffixedElementAliases(), this.getSession());
        Object object3 = this.identifiers.put(this.values.size(), collectionPersister.readIdentifier(resultSet, collectionAliases.getSuffixedIdentifierAlias(), this.getSession()));
        if (object3 == null) {
            this.values.add(object2);
        }
        return object2;
    }

    public Serializable getSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        HashMap hashMap = new HashMap(this.values.size());
        Iterator iterator = this.values.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            hashMap.put(this.identifiers.get(n++), collectionPersister.getElementType().deepCopy(e, collectionPersister.getFactory()));
        }
        return hashMap;
    }

    public Collection getOrphans(Serializable serializable, String string) throws HibernateException {
        Map map = (Map)((Object)serializable);
        return PersistentIdentifierBag.getOrphans(map.values(), this.values, string, this.getSession());
    }

    public void preInsert(CollectionPersister collectionPersister) throws HibernateException {
        Iterator iterator = this.values.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Integer n2;
            Object e = iterator.next();
            if (this.identifiers.containsKey(n2 = Integer.valueOf(n++))) continue;
            Serializable serializable = collectionPersister.getIdentifierGenerator().generate(this.getSession(), e);
            this.identifiers.put(n2, serializable);
        }
    }

    public void add(int n, Object object) {
        this.write();
        this.beforeAdd(n);
        this.values.add(n, object);
    }

    public boolean addAll(int n, Collection collection) {
        if (collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.add(n++, iterator.next());
            }
            return true;
        }
        return false;
    }

    public Object get(int n) {
        this.read();
        return this.values.get(n);
    }

    public int indexOf(Object object) {
        this.read();
        return this.values.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        this.read();
        return this.values.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this, this.values.listIterator());
    }

    public ListIterator listIterator(int n) {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this, this.values.listIterator(n));
    }

    private void beforeRemove(int n) {
        Object v = this.identifiers.get(n);
        int n2 = this.values.size() - 1;
        for (int i = n; i < n2; ++i) {
            Object v2 = this.identifiers.get(i + 1);
            if (v2 == null) {
                this.identifiers.remove(i);
                continue;
            }
            this.identifiers.put(i, v2);
        }
        this.identifiers.put(n2, v);
    }

    private void beforeAdd(int n) {
        for (int i = n; i < this.values.size(); ++i) {
            this.identifiers.put(i + 1, this.identifiers.get(i));
        }
        this.identifiers.remove(n);
    }

    public Object remove(int n) {
        this.write();
        this.beforeRemove(n);
        return this.values.remove(n);
    }

    public Object set(int n, Object object) {
        this.write();
        return this.values.set(n, object);
    }

    public List subList(int n, int n2) {
        this.read();
        return new AbstractPersistentCollection.ListProxy(this, this.values.subList(n, n2));
    }

    public boolean addAll(Collection collection) {
        if (collection.size() > 0) {
            this.write();
            return this.values.addAll(collection);
        }
        return false;
    }

    public void afterRowInsert(CollectionPersister collectionPersister, Object object, int n) throws HibernateException {
    }
}

