/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.naming.NamingException;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.Session;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.internal.util.collections.EmptyIterator;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistentCollection
implements Serializable,
PersistentCollection {
    private static final Logger log = Logger.getLogger(AbstractPersistentCollection.class);
    private transient SessionImplementor session;
    private boolean initialized;
    private transient List<DelayedOperation> operationQueue;
    private transient boolean directlyAccessible;
    private transient boolean initializing;
    private Object owner;
    private int cachedSize = -1;
    private String role;
    private Serializable key;
    private boolean dirty;
    private Serializable storedSnapshot;
    private String sessionFactoryUuid;
    private boolean specjLazyLoad = false;
    protected static final Object UNKNOWN = new MarkerObject("UNKNOWN");

    @Override
    public final String getRole() {
        return this.role;
    }

    @Override
    public final Serializable getKey() {
        return this.key;
    }

    @Override
    public final boolean isUnreferenced() {
        return this.role == null;
    }

    @Override
    public final boolean isDirty() {
        return this.dirty;
    }

    @Override
    public final void clearDirty() {
        this.dirty = false;
    }

    @Override
    public final void dirty() {
        this.dirty = true;
    }

    @Override
    public final Serializable getStoredSnapshot() {
        return this.storedSnapshot;
    }

    @Override
    public abstract boolean empty();

    protected final void read() {
        this.initialize(false);
    }

    protected boolean readSize() {
        if (!this.initialized) {
            if (this.cachedSize != -1 && !this.hasQueuedOperations()) {
                return true;
            }
            boolean bl = this.withTemporarySessionIfNeeded(new LazyInitializationWork<Boolean>(){

                @Override
                public Boolean doWork() {
                    CollectionEntry collectionEntry = AbstractPersistentCollection.this.session.getPersistenceContext().getCollectionEntry(AbstractPersistentCollection.this);
                    if (collectionEntry != null) {
                        CollectionPersister collectionPersister = collectionEntry.getLoadedPersister();
                        if (collectionPersister.isExtraLazy()) {
                            if (AbstractPersistentCollection.this.hasQueuedOperations()) {
                                AbstractPersistentCollection.this.session.flush();
                            }
                            AbstractPersistentCollection.this.cachedSize = collectionPersister.getSize(collectionEntry.getLoadedKey(), AbstractPersistentCollection.this.session);
                            return true;
                        }
                        AbstractPersistentCollection.this.read();
                    } else {
                        AbstractPersistentCollection.this.throwLazyInitializationExceptionIfNotConnected();
                    }
                    return false;
                }
            });
            if (bl) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withTemporarySessionIfNeeded(LazyInitializationWork<T> lazyInitializationWork) {
        SessionImplementor sessionImplementor = null;
        boolean bl = false;
        boolean bl2 = false;
        if (this.session == null) {
            if (this.specjLazyLoad) {
                this.session = this.openTemporarySessionForLoading();
                bl = true;
            } else {
                this.throwLazyInitializationException("could not initialize proxy - no Session");
            }
        } else if (!this.session.isOpen()) {
            if (this.specjLazyLoad) {
                sessionImplementor = this.session;
                this.session = this.openTemporarySessionForLoading();
                bl = true;
            } else {
                this.throwLazyInitializationException("could not initialize proxy - the owning Session was closed");
            }
        } else if (!this.session.isConnected()) {
            if (this.specjLazyLoad) {
                sessionImplementor = this.session;
                this.session = this.openTemporarySessionForLoading();
                bl = true;
            } else {
                this.throwLazyInitializationException("could not initialize proxy - the owning Session is disconnected");
            }
        }
        if (bl) {
            bl2 = this.session.getTransactionCoordinator().getTransactionContext().getTransactionEnvironment().getTransactionFactory().compatibleWithJtaSynchronization();
            if (!bl2) {
                ((Session)((Object)this.session)).beginTransaction();
            }
            this.session.getPersistenceContext().addUninitializedDetachedCollection(this.session.getFactory().getCollectionPersister(this.getRole()), this);
        }
        try {
            T t = lazyInitializationWork.doWork();
            return t;
        }
        finally {
            if (bl) {
                try {
                    if (!bl2) {
                        ((Session)((Object)this.session)).getTransaction().commit();
                    }
                    ((Session)((Object)this.session)).close();
                }
                catch (Exception exception) {
                    log.warn("Unable to close temporary session used to load lazy collection associated to no session");
                }
                this.session = sessionImplementor;
            }
        }
    }

    private SessionImplementor openTemporarySessionForLoading() {
        if (this.sessionFactoryUuid == null) {
            this.throwLazyInitializationException("SessionFactory UUID not known to create temporary Session for loading");
        }
        SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)SessionFactoryRegistry.INSTANCE.getSessionFactory(this.sessionFactoryUuid);
        return (SessionImplementor)((Object)sessionFactoryImplementor.openSession());
    }

    protected Boolean readIndexExistence(final Object object) {
        Boolean bl;
        if (!this.initialized && (bl = this.withTemporarySessionIfNeeded(new LazyInitializationWork<Boolean>(){

            @Override
            public Boolean doWork() {
                CollectionEntry collectionEntry = AbstractPersistentCollection.this.session.getPersistenceContext().getCollectionEntry(AbstractPersistentCollection.this);
                CollectionPersister collectionPersister = collectionEntry.getLoadedPersister();
                if (collectionPersister.isExtraLazy()) {
                    if (AbstractPersistentCollection.this.hasQueuedOperations()) {
                        AbstractPersistentCollection.this.session.flush();
                    }
                    return collectionPersister.indexExists(collectionEntry.getLoadedKey(), object, AbstractPersistentCollection.this.session);
                }
                AbstractPersistentCollection.this.read();
                return null;
            }
        })) != null) {
            return bl;
        }
        return null;
    }

    protected Boolean readElementExistence(final Object object) {
        Boolean bl;
        if (!this.initialized && (bl = this.withTemporarySessionIfNeeded(new LazyInitializationWork<Boolean>(){

            @Override
            public Boolean doWork() {
                CollectionEntry collectionEntry = AbstractPersistentCollection.this.session.getPersistenceContext().getCollectionEntry(AbstractPersistentCollection.this);
                CollectionPersister collectionPersister = collectionEntry.getLoadedPersister();
                if (collectionPersister.isExtraLazy()) {
                    if (AbstractPersistentCollection.this.hasQueuedOperations()) {
                        AbstractPersistentCollection.this.session.flush();
                    }
                    return collectionPersister.elementExists(collectionEntry.getLoadedKey(), object, AbstractPersistentCollection.this.session);
                }
                AbstractPersistentCollection.this.read();
                return null;
            }
        })) != null) {
            return bl;
        }
        return null;
    }

    protected Object readElementByIndex(final Object object) {
        if (!this.initialized) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ExtraLazyElementByIndexReader
            implements LazyInitializationWork {
                private boolean isExtraLazy;
                private Object element;

                ExtraLazyElementByIndexReader() {
                }

                public Object doWork() {
                    CollectionEntry collectionEntry = AbstractPersistentCollection.this.session.getPersistenceContext().getCollectionEntry(AbstractPersistentCollection.this);
                    CollectionPersister collectionPersister = collectionEntry.getLoadedPersister();
                    this.isExtraLazy = collectionPersister.isExtraLazy();
                    if (this.isExtraLazy) {
                        if (AbstractPersistentCollection.this.hasQueuedOperations()) {
                            AbstractPersistentCollection.this.session.flush();
                        }
                        this.element = collectionPersister.getElementByIndex(collectionEntry.getLoadedKey(), object, AbstractPersistentCollection.this.session, AbstractPersistentCollection.this.owner);
                    } else {
                        AbstractPersistentCollection.this.read();
                    }
                    return null;
                }
            }
            ExtraLazyElementByIndexReader extraLazyElementByIndexReader = new ExtraLazyElementByIndexReader();
            this.withTemporarySessionIfNeeded(extraLazyElementByIndexReader);
            if (extraLazyElementByIndexReader.isExtraLazy) {
                return extraLazyElementByIndexReader.element;
            }
        }
        return UNKNOWN;
    }

    protected int getCachedSize() {
        return this.cachedSize;
    }

    private boolean isConnectedToSession() {
        return this.session != null && this.session.isOpen() && this.session.getPersistenceContext().containsCollection(this);
    }

    protected final void write() {
        this.initialize(true);
        this.dirty();
    }

    protected boolean isOperationQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseCollection();
    }

    protected boolean isPutQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseOneToManyOrNoOrphanDelete();
    }

    protected boolean isClearQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseCollectionNoOrphanDelete();
    }

    private boolean isInverseCollection() {
        CollectionEntry collectionEntry = this.session.getPersistenceContext().getCollectionEntry(this);
        return collectionEntry != null && collectionEntry.getLoadedPersister().isInverse();
    }

    private boolean isInverseCollectionNoOrphanDelete() {
        CollectionEntry collectionEntry = this.session.getPersistenceContext().getCollectionEntry(this);
        return collectionEntry != null && collectionEntry.getLoadedPersister().isInverse() && !collectionEntry.getLoadedPersister().hasOrphanDelete();
    }

    private boolean isInverseOneToManyOrNoOrphanDelete() {
        CollectionEntry collectionEntry = this.session.getPersistenceContext().getCollectionEntry(this);
        return collectionEntry != null && collectionEntry.getLoadedPersister().isInverse() && (collectionEntry.getLoadedPersister().isOneToMany() || !collectionEntry.getLoadedPersister().hasOrphanDelete());
    }

    protected final void queueOperation(DelayedOperation delayedOperation) {
        if (this.operationQueue == null) {
            this.operationQueue = new ArrayList<DelayedOperation>(10);
        }
        this.operationQueue.add(delayedOperation);
        this.dirty = true;
    }

    protected final void performQueuedOperations() {
        for (DelayedOperation delayedOperation : this.operationQueue) {
            delayedOperation.operate();
        }
    }

    @Override
    public void setSnapshot(Serializable serializable, String string, Serializable serializable2) {
        this.key = serializable;
        this.role = string;
        this.storedSnapshot = serializable2;
    }

    @Override
    public void postAction() {
        this.operationQueue = null;
        this.cachedSize = -1;
        this.clearDirty();
    }

    public AbstractPersistentCollection() {
    }

    protected AbstractPersistentCollection(SessionImplementor sessionImplementor) {
        this.session = sessionImplementor;
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public void beginRead() {
        this.initializing = true;
    }

    @Override
    public boolean endRead() {
        return this.afterInitialize();
    }

    @Override
    public boolean afterInitialize() {
        this.setInitialized();
        if (this.operationQueue != null) {
            this.performQueuedOperations();
            this.operationQueue = null;
            this.cachedSize = -1;
            return false;
        }
        return true;
    }

    protected final void initialize(final boolean bl) {
        if (this.initialized) {
            return;
        }
        this.withTemporarySessionIfNeeded(new LazyInitializationWork<Object>(){

            @Override
            public Object doWork() {
                AbstractPersistentCollection.this.session.initializeCollection(AbstractPersistentCollection.this, bl);
                return null;
            }
        });
    }

    private void throwLazyInitializationExceptionIfNotConnected() {
        if (!this.isConnectedToSession()) {
            this.throwLazyInitializationException("no session or session was closed");
        }
        if (!this.session.isConnected()) {
            this.throwLazyInitializationException("session is disconnected");
        }
    }

    private void throwLazyInitializationException(String string) {
        throw new LazyInitializationException("failed to lazily initialize a collection" + (this.role == null ? "" : " of role: " + this.role) + ", " + string);
    }

    protected final void setInitialized() {
        this.initializing = false;
        this.initialized = true;
    }

    protected final void setDirectlyAccessible(boolean bl) {
        this.directlyAccessible = bl;
    }

    @Override
    public boolean isDirectlyAccessible() {
        return this.directlyAccessible;
    }

    @Override
    public final boolean unsetSession(SessionImplementor sessionImplementor) {
        this.prepareForPossibleSpecialSpecjInitialization();
        if (sessionImplementor == this.session) {
            this.session = null;
            return true;
        }
        return false;
    }

    protected void prepareForPossibleSpecialSpecjInitialization() {
        if (this.session != null) {
            this.specjLazyLoad = this.session.getFactory().getSettings().isInitializeLazyStateOutsideTransactionsEnabled();
            if (this.specjLazyLoad && this.sessionFactoryUuid == null) {
                try {
                    this.sessionFactoryUuid = (String)this.session.getFactory().getReference().get("uuid").getContent();
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public final boolean setCurrentSession(SessionImplementor sessionImplementor) throws HibernateException {
        if (sessionImplementor == this.session) {
            return false;
        }
        if (this.isConnectedToSession()) {
            CollectionEntry collectionEntry = sessionImplementor.getPersistenceContext().getCollectionEntry(this);
            if (collectionEntry == null) {
                throw new HibernateException("Illegal attempt to associate a collection with two open sessions");
            }
            throw new HibernateException("Illegal attempt to associate a collection with two open sessions: " + MessageHelper.collectionInfoString(collectionEntry.getLoadedPersister(), this, collectionEntry.getLoadedKey(), sessionImplementor));
        }
        this.session = sessionImplementor;
        return true;
    }

    @Override
    public boolean needsRecreate(CollectionPersister collectionPersister) {
        return false;
    }

    @Override
    public final void forceInitialization() throws HibernateException {
        if (!this.initialized) {
            if (this.initializing) {
                throw new AssertionFailure("force initialize loading collection");
            }
            if (this.session == null) {
                throw new HibernateException("collection is not associated with any session");
            }
            if (!this.session.isConnected()) {
                throw new HibernateException("disconnected session");
            }
            this.session.initializeCollection(this, false);
        }
    }

    protected final Serializable getSnapshot() {
        return this.session.getPersistenceContext().getSnapshot(this);
    }

    @Override
    public final boolean wasInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isRowUpdatePossible() {
        return true;
    }

    @Override
    public final boolean hasQueuedOperations() {
        return this.operationQueue != null;
    }

    @Override
    public final Iterator queuedAdditionIterator() {
        if (this.hasQueuedOperations()) {
            return new Iterator(){
                int i = 0;

                public Object next() {
                    return ((DelayedOperation)AbstractPersistentCollection.this.operationQueue.get(this.i++)).getAddedInstance();
                }

                public boolean hasNext() {
                    return this.i < AbstractPersistentCollection.this.operationQueue.size();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return EmptyIterator.INSTANCE;
    }

    @Override
    public final Collection getQueuedOrphans(String string) {
        if (this.hasQueuedOperations()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.operationQueue.size());
            ArrayList<Object> arrayList2 = new ArrayList<Object>(this.operationQueue.size());
            for (DelayedOperation delayedOperation : this.operationQueue) {
                arrayList.add(delayedOperation.getAddedInstance());
                arrayList2.add(delayedOperation.getOrphan());
            }
            return AbstractPersistentCollection.getOrphans(arrayList2, arrayList, string, this.session);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void preInsert(CollectionPersister collectionPersister) throws HibernateException {
    }

    @Override
    public void afterRowInsert(CollectionPersister collectionPersister, Object object, int n) throws HibernateException {
    }

    @Override
    public abstract Collection getOrphans(Serializable var1, String var2) throws HibernateException;

    public final SessionImplementor getSession() {
        return this.session;
    }

    protected static Collection getOrphans(Collection collection, Collection collection2, String string, SessionImplementor sessionImplementor) throws HibernateException {
        Serializable serializable;
        if (collection2.size() == 0) {
            return collection;
        }
        if (collection.size() == 0) {
            return collection;
        }
        EntityPersister entityPersister = sessionImplementor.getFactory().getEntityPersister(string);
        Type type = entityPersister.getIdentifierType();
        ArrayList arrayList = new ArrayList();
        HashSet<TypedValue> hashSet = new HashSet<TypedValue>();
        IdentitySet identitySet = new IdentitySet();
        for (Object e : collection2) {
            if (e == null || !ForeignKeys.isNotTransient(string, e, null, sessionImplementor)) continue;
            serializable = sessionImplementor.getPersistenceContext().getEntry(e);
            if (serializable != null && ((EntityEntry)serializable).getStatus() == Status.SAVING) {
                identitySet.add(e);
                continue;
            }
            Serializable serializable2 = ForeignKeys.getEntityIdentifierIfNotUnsaved(string, e, sessionImplementor);
            hashSet.add(new TypedValue(type, serializable2, entityPersister.getEntityMode()));
        }
        for (Object e : collection) {
            if (identitySet.contains(e) || hashSet.contains(new TypedValue(type, serializable = ForeignKeys.getEntityIdentifierIfNotUnsaved(string, e, sessionImplementor), entityPersister.getEntityMode()))) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static void identityRemove(Collection collection, Object object, String string, SessionImplementor sessionImplementor) throws HibernateException {
        if (object != null && ForeignKeys.isNotTransient(string, object, null, sessionImplementor)) {
            EntityPersister entityPersister = sessionImplementor.getFactory().getEntityPersister(string);
            Type type = entityPersister.getIdentifierType();
            Serializable serializable = ForeignKeys.getEntityIdentifierIfNotUnsaved(string, object, sessionImplementor);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Serializable serializable2 = ForeignKeys.getEntityIdentifierIfNotUnsaved(string, iterator.next(), sessionImplementor);
                if (!type.isEqual(serializable, serializable2, sessionImplementor.getFactory())) continue;
                iterator.remove();
                break;
            }
        }
    }

    @Override
    public Object getIdentifier(Object object, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Object object) {
        this.owner = object;
    }

    protected static interface DelayedOperation {
        public void operate();

        public Object getAddedInstance();

        public Object getOrphan();
    }

    protected final class ListProxy
    implements List {
        protected final List list;

        public ListProxy(List list) {
            this.list = list;
        }

        public void add(int n, Object object) {
            AbstractPersistentCollection.this.write();
            this.list.add(n, object);
        }

        public boolean add(Object object) {
            AbstractPersistentCollection.this.write();
            return this.list.add(object);
        }

        public boolean addAll(Collection collection) {
            AbstractPersistentCollection.this.write();
            return this.list.addAll(collection);
        }

        public boolean addAll(int n, Collection collection) {
            AbstractPersistentCollection.this.write();
            return this.list.addAll(n, collection);
        }

        public void clear() {
            AbstractPersistentCollection.this.write();
            this.list.clear();
        }

        public boolean contains(Object object) {
            return this.list.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.list.containsAll(collection);
        }

        public Object get(int n) {
            return this.list.get(n);
        }

        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Iterator iterator() {
            return new IteratorProxy(this.list.iterator());
        }

        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return new ListIteratorProxy(this.list.listIterator());
        }

        public ListIterator listIterator(int n) {
            return new ListIteratorProxy(this.list.listIterator(n));
        }

        public Object remove(int n) {
            AbstractPersistentCollection.this.write();
            return this.list.remove(n);
        }

        public boolean remove(Object object) {
            AbstractPersistentCollection.this.write();
            return this.list.remove(object);
        }

        public boolean removeAll(Collection collection) {
            AbstractPersistentCollection.this.write();
            return this.list.removeAll(collection);
        }

        public boolean retainAll(Collection collection) {
            AbstractPersistentCollection.this.write();
            return this.list.retainAll(collection);
        }

        public Object set(int n, Object object) {
            AbstractPersistentCollection.this.write();
            return this.list.set(n, object);
        }

        public int size() {
            return this.list.size();
        }

        public List subList(int n, int n2) {
            return this.list.subList(n, n2);
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.list.toArray(objectArray);
        }
    }

    protected class SetProxy
    implements Set {
        protected final Collection set;

        public SetProxy(Collection collection) {
            this.set = collection;
        }

        public boolean add(Object object) {
            AbstractPersistentCollection.this.write();
            return this.set.add(object);
        }

        public boolean addAll(Collection collection) {
            AbstractPersistentCollection.this.write();
            return this.set.addAll(collection);
        }

        public void clear() {
            AbstractPersistentCollection.this.write();
            this.set.clear();
        }

        public boolean contains(Object object) {
            return this.set.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.set.containsAll(collection);
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public Iterator iterator() {
            return new IteratorProxy(this.set.iterator());
        }

        public boolean remove(Object object) {
            AbstractPersistentCollection.this.write();
            return this.set.remove(object);
        }

        public boolean removeAll(Collection collection) {
            AbstractPersistentCollection.this.write();
            return this.set.removeAll(collection);
        }

        public boolean retainAll(Collection collection) {
            AbstractPersistentCollection.this.write();
            return this.set.retainAll(collection);
        }

        public int size() {
            return this.set.size();
        }

        public Object[] toArray() {
            return this.set.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.set.toArray(objectArray);
        }
    }

    protected final class ListIteratorProxy
    implements ListIterator {
        protected final ListIterator itr;

        public ListIteratorProxy(ListIterator listIterator) {
            this.itr = listIterator;
        }

        public void add(Object object) {
            AbstractPersistentCollection.this.write();
            this.itr.add(object);
        }

        public boolean hasNext() {
            return this.itr.hasNext();
        }

        public boolean hasPrevious() {
            return this.itr.hasPrevious();
        }

        public Object next() {
            return this.itr.next();
        }

        public int nextIndex() {
            return this.itr.nextIndex();
        }

        public Object previous() {
            return this.itr.previous();
        }

        public int previousIndex() {
            return this.itr.previousIndex();
        }

        public void remove() {
            AbstractPersistentCollection.this.write();
            this.itr.remove();
        }

        public void set(Object object) {
            AbstractPersistentCollection.this.write();
            this.itr.set(object);
        }
    }

    protected final class IteratorProxy
    implements Iterator {
        protected final Iterator itr;

        public IteratorProxy(Iterator iterator) {
            this.itr = iterator;
        }

        public boolean hasNext() {
            return this.itr.hasNext();
        }

        public Object next() {
            return this.itr.next();
        }

        public void remove() {
            AbstractPersistentCollection.this.write();
            this.itr.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LazyInitializationWork<T> {
        public T doWork();
    }
}

