/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.HibernateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ValidationMode {
    AUTO("auto"),
    CALLBACK("callback"),
    NONE("none"),
    DDL("ddl");

    private final String externalForm;

    private ValidationMode(String string2) {
        this.externalForm = string2;
    }

    public static Set<ValidationMode> getModes(Object object) {
        HashSet<ValidationMode> hashSet = new HashSet<ValidationMode>(3);
        if (object == null) {
            hashSet.add(AUTO);
        } else {
            String[] stringArray;
            for (String string : stringArray = object.toString().split(",")) {
                hashSet.add(ValidationMode.getMode(string));
            }
        }
        if (hashSet.size() > 1 && (hashSet.contains((Object)AUTO) || hashSet.contains((Object)NONE))) {
            throw new HibernateException("Incompatible validation modes mixed: " + ValidationMode.loggable(hashSet));
        }
        return hashSet;
    }

    private static ValidationMode getMode(String string) {
        if (string == null || string.length() == 0) {
            return AUTO;
        }
        try {
            return ValidationMode.valueOf(string.trim().toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HibernateException("Unknown validation mode in javax.persistence.validation.mode: " + string);
        }
    }

    public static String loggable(Set<ValidationMode> set) {
        if (set == null || set.isEmpty()) {
            return "[<empty>]";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        String string = "";
        for (ValidationMode validationMode : set) {
            stringBuilder.append(string).append(validationMode.externalForm);
            string = ", ";
        }
        return stringBuilder.append("]").toString();
    }
}

