/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.cfg.beanvalidation.ActivationContext;
import org.hibernate.cfg.beanvalidation.BeanValidationEventListener;
import org.hibernate.cfg.beanvalidation.DuplicationStrategyImpl;
import org.hibernate.cfg.beanvalidation.GroupsPerOperation;
import org.hibernate.cfg.beanvalidation.IntegrationException;
import org.hibernate.cfg.beanvalidation.ValidationMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SingleTableSubclass;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeSafeActivator {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TypeSafeActivator.class.getName());
    private static final String FACTORY_PROPERTY = "javax.persistence.validation.factory";

    TypeSafeActivator() {
    }

    public static void validateSuppliedFactory(Object object) {
        if (!ValidatorFactory.class.isInstance(object)) {
            throw new IntegrationException("Given object was not an instance of " + ValidatorFactory.class.getName() + "[" + object.getClass().getName() + "]");
        }
    }

    public static void activate(ActivationContext activationContext) {
        ValidatorFactory validatorFactory;
        Properties properties = activationContext.getConfiguration().getProperties();
        try {
            validatorFactory = TypeSafeActivator.getValidatorFactory(properties);
        }
        catch (IntegrationException integrationException) {
            if (activationContext.getValidationModes().contains((Object)ValidationMode.CALLBACK)) {
                throw new IntegrationException("Bean Validation provider was not available, but 'callback' validation was requested", integrationException);
            }
            if (activationContext.getValidationModes().contains((Object)ValidationMode.DDL)) {
                throw new IntegrationException("Bean Validation provider was not available, but 'ddl' validation was requested", integrationException);
            }
            LOG.debug("Unable to acquire Bean Validation ValidatorFactory, skipping activation");
            return;
        }
        TypeSafeActivator.applyRelationalConstraints(validatorFactory, activationContext);
        TypeSafeActivator.applyCallbackListeners(validatorFactory, activationContext);
    }

    public static void applyCallbackListeners(ValidatorFactory validatorFactory, ActivationContext activationContext) {
        Set<ValidationMode> set = activationContext.getValidationModes();
        if (!set.contains((Object)ValidationMode.CALLBACK) && !set.contains((Object)ValidationMode.AUTO)) {
            return;
        }
        if (activationContext.getConfiguration().getProperty("hibernate.check_nullability") == null) {
            activationContext.getSessionFactory().getSettings().setCheckNullability(false);
        }
        BeanValidationEventListener beanValidationEventListener = new BeanValidationEventListener(validatorFactory, activationContext.getConfiguration().getProperties());
        EventListenerRegistry eventListenerRegistry = activationContext.getServiceRegistry().getService(EventListenerRegistry.class);
        eventListenerRegistry.addDuplicationStrategy(DuplicationStrategyImpl.INSTANCE);
        eventListenerRegistry.appendListeners(EventType.PRE_INSERT, beanValidationEventListener);
        eventListenerRegistry.appendListeners(EventType.PRE_UPDATE, beanValidationEventListener);
        eventListenerRegistry.appendListeners(EventType.PRE_DELETE, beanValidationEventListener);
        beanValidationEventListener.initialize(activationContext.getConfiguration());
    }

    private static void applyRelationalConstraints(ValidatorFactory validatorFactory, ActivationContext activationContext) {
        Properties properties = activationContext.getConfiguration().getProperties();
        if (!ConfigurationHelper.getBoolean("hibernate.validator.apply_to_ddl", properties, true)) {
            LOG.debug("Skipping application of relational constraints from legacy Hibernate Validator");
            return;
        }
        Set<ValidationMode> set = activationContext.getValidationModes();
        if (!set.contains((Object)ValidationMode.DDL) && !set.contains((Object)ValidationMode.AUTO)) {
            return;
        }
        TypeSafeActivator.applyRelationalConstraints(activationContext.getConfiguration().createMappings().getClasses().values(), properties, activationContext.getServiceRegistry().getService(JdbcServices.class).getDialect());
    }

    public static void applyRelationalConstraints(Collection<PersistentClass> collection, Properties properties, Dialect dialect) {
        ValidatorFactory validatorFactory = TypeSafeActivator.getValidatorFactory(properties);
        Class<?>[] classArray = new GroupsPerOperation(properties).get(GroupsPerOperation.Operation.DDL);
        HashSet hashSet = new HashSet(Arrays.asList(classArray));
        for (PersistentClass persistentClass : collection) {
            Class clazz;
            String string = persistentClass.getClassName();
            if (string == null || string.length() == 0) continue;
            try {
                clazz = ReflectHelper.classForName(string, TypeSafeActivator.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionFailure("Entity class not found", classNotFoundException);
            }
            try {
                TypeSafeActivator.applyDDL("", persistentClass, clazz, validatorFactory, hashSet, true, dialect);
            }
            catch (Exception exception) {
                LOG.unableToApplyConstraints(string, exception);
            }
        }
    }

    private static void applyDDL(String string, PersistentClass persistentClass, Class<?> clazz, ValidatorFactory validatorFactory, Set<Class<?>> set, boolean bl, Dialect dialect) {
        BeanDescriptor beanDescriptor = validatorFactory.getValidator().getConstraintsForClass(clazz);
        for (PropertyDescriptor propertyDescriptor : beanDescriptor.getConstrainedProperties()) {
            Property property = TypeSafeActivator.findPropertyByName(persistentClass, string + propertyDescriptor.getPropertyName());
            if (property == null) continue;
            boolean bl2 = TypeSafeActivator.applyConstraints(propertyDescriptor.getConstraintDescriptors(), property, propertyDescriptor, set, bl, dialect);
            if (!property.isComposite() || !propertyDescriptor.isCascaded()) continue;
            Class clazz2 = ((Component)property.getValue()).getComponentClass();
            boolean bl3 = bl && bl2;
            TypeSafeActivator.applyDDL(string + propertyDescriptor.getPropertyName() + ".", persistentClass, clazz2, validatorFactory, set, bl3, dialect);
        }
    }

    private static boolean applyConstraints(Set<ConstraintDescriptor<?>> set, Property property, PropertyDescriptor propertyDescriptor, Set<Class<?>> set2, boolean bl, Dialect dialect) {
        boolean bl2 = false;
        for (ConstraintDescriptor<?> constraintDescriptor : set) {
            if (set2 != null && Collections.disjoint(constraintDescriptor.getGroups(), set2)) continue;
            if (bl) {
                bl2 = bl2 || TypeSafeActivator.applyNotNull(property, constraintDescriptor);
            }
            TypeSafeActivator.applyDigits(property, constraintDescriptor);
            TypeSafeActivator.applySize(property, constraintDescriptor, propertyDescriptor);
            TypeSafeActivator.applyMin(property, constraintDescriptor, dialect);
            TypeSafeActivator.applyMax(property, constraintDescriptor, dialect);
            TypeSafeActivator.applyLength(property, constraintDescriptor, propertyDescriptor);
            bl2 = bl2 || TypeSafeActivator.applyConstraints(constraintDescriptor.getComposingConstraints(), property, propertyDescriptor, null, bl, dialect);
        }
        return bl2;
    }

    private static void applyMin(Property property, ConstraintDescriptor<?> constraintDescriptor, Dialect dialect) {
        if (Min.class.equals(constraintDescriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> constraintDescriptor2 = constraintDescriptor;
            long l = ((Min)constraintDescriptor2.getAnnotation()).value();
            Column column = (Column)property.getColumnIterator().next();
            String string = column.getQuotedName(dialect) + ">=" + l;
            TypeSafeActivator.applySQLCheck(column, string);
        }
    }

    private static void applyMax(Property property, ConstraintDescriptor<?> constraintDescriptor, Dialect dialect) {
        if (Max.class.equals(constraintDescriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> constraintDescriptor2 = constraintDescriptor;
            long l = ((Max)constraintDescriptor2.getAnnotation()).value();
            Column column = (Column)property.getColumnIterator().next();
            String string = column.getQuotedName(dialect) + "<=" + l;
            TypeSafeActivator.applySQLCheck(column, string);
        }
    }

    private static void applySQLCheck(Column column, String string) {
        String string2 = column.getCheckConstraint();
        if (StringHelper.isNotEmpty(string2) && !string2.contains(string)) {
            string = column.getCheckConstraint() + " AND " + string;
        }
        column.setCheckConstraint(string);
    }

    private static boolean applyNotNull(Property property, ConstraintDescriptor<?> constraintDescriptor) {
        boolean bl = false;
        if (NotNull.class.equals(constraintDescriptor.getAnnotation().annotationType())) {
            if (!(property.getPersistentClass() instanceof SingleTableSubclass) && !property.isComposite()) {
                Iterator iterator = property.getColumnIterator();
                while (iterator.hasNext()) {
                    ((Column)iterator.next()).setNullable(false);
                    bl = true;
                }
            }
            bl = true;
        }
        return bl;
    }

    private static void applyDigits(Property property, ConstraintDescriptor<?> constraintDescriptor) {
        if (Digits.class.equals(constraintDescriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> constraintDescriptor2 = constraintDescriptor;
            int n = ((Digits)constraintDescriptor2.getAnnotation()).integer();
            int n2 = ((Digits)constraintDescriptor2.getAnnotation()).fraction();
            Column column = (Column)property.getColumnIterator().next();
            column.setPrecision(n + n2);
            column.setScale(n2);
        }
    }

    private static void applySize(Property property, ConstraintDescriptor<?> constraintDescriptor, PropertyDescriptor propertyDescriptor) {
        if (Size.class.equals(constraintDescriptor.getAnnotation().annotationType()) && String.class.equals((Object)propertyDescriptor.getElementClass())) {
            ConstraintDescriptor<?> constraintDescriptor2 = constraintDescriptor;
            int n = ((Size)constraintDescriptor2.getAnnotation()).max();
            Column column = (Column)property.getColumnIterator().next();
            if (n < Integer.MAX_VALUE) {
                column.setLength(n);
            }
        }
    }

    private static void applyLength(Property property, ConstraintDescriptor<?> constraintDescriptor, PropertyDescriptor propertyDescriptor) {
        if ("org.hibernate.validator.constraints.Length".equals(constraintDescriptor.getAnnotation().annotationType().getName()) && String.class.equals((Object)propertyDescriptor.getElementClass())) {
            int n = (Integer)constraintDescriptor.getAttributes().get("max");
            Column column = (Column)property.getColumnIterator().next();
            if (n < Integer.MAX_VALUE) {
                column.setLength(n);
            }
        }
    }

    private static Property findPropertyByName(PersistentClass persistentClass, String string) {
        Property property = null;
        Property property2 = persistentClass.getIdentifierProperty();
        String string2 = property2 != null ? property2.getName() : null;
        try {
            if (string == null || string.length() == 0 || string.equals(string2)) {
                property = property2;
            } else {
                if (string.indexOf(string2 + ".") == 0) {
                    property = property2;
                    string = string.substring(string2.length() + 1);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
                while (stringTokenizer.hasMoreElements()) {
                    String string3 = (String)stringTokenizer.nextElement();
                    if (property == null) {
                        property = persistentClass.getProperty(string3);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(string3);
                }
            }
        }
        catch (MappingException mappingException) {
            try {
                if (persistentClass.getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
                while (stringTokenizer.hasMoreElements()) {
                    String string4 = (String)stringTokenizer.nextElement();
                    if (property == null) {
                        property = persistentClass.getIdentifierMapper().getProperty(string4);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(string4);
                }
            }
            catch (MappingException mappingException2) {
                return null;
            }
        }
        return property;
    }

    private static ValidatorFactory getValidatorFactory(Map<Object, Object> map) {
        Object object;
        ValidatorFactory validatorFactory = null;
        if (map != null && (object = map.get(FACTORY_PROPERTY)) != null) {
            try {
                validatorFactory = (ValidatorFactory)ValidatorFactory.class.cast(object);
            }
            catch (ClassCastException classCastException) {
                throw new IntegrationException("Property javax.persistence.validation.factory should contain an object of type " + ValidatorFactory.class.getName());
            }
        }
        if (validatorFactory == null) {
            try {
                validatorFactory = Validation.buildDefaultValidatorFactory();
            }
            catch (Exception exception) {
                throw new IntegrationException("Unable to build the default ValidatorFactory", exception);
            }
        }
        return validatorFactory;
    }
}

