/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.beanvalidation.ActivationContext;
import org.hibernate.cfg.beanvalidation.IntegrationException;
import org.hibernate.cfg.beanvalidation.ValidationMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationIntegrator
implements Integrator {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, BeanValidationIntegrator.class.getName());
    public static final String APPLY_CONSTRAINTS = "hibernate.validator.apply_to_ddl";
    public static final String BV_CHECK_CLASS = "javax.validation.Validation";
    public static final String MODE_PROPERTY = "javax.persistence.validation.mode";
    private static final String ACTIVATOR_CLASS_NAME = "org.hibernate.cfg.beanvalidation.TypeSafeActivator";
    private static final String VALIDATE_SUPPLIED_FACTORY_METHOD_NAME = "validateSuppliedFactory";
    private static final String ACTIVATE_METHOD_NAME = "activate";

    public static void validateFactory(Object object) {
        try {
            Class<?> clazz = BeanValidationIntegrator.class.getClassLoader().loadClass(ACTIVATOR_CLASS_NAME);
            try {
                Method method = clazz.getMethod(VALIDATE_SUPPLIED_FACTORY_METHOD_NAME, Object.class);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                try {
                    method.invoke(null, object);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof HibernateException) {
                        throw (HibernateException)invocationTargetException.getTargetException();
                    }
                    throw new HibernateException("Unable to check validity of passed ValidatorFactory", invocationTargetException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new HibernateException("Unable to check validity of passed ValidatorFactory", illegalAccessException);
                }
            }
            catch (HibernateException hibernateException) {
                throw hibernateException;
            }
            catch (Exception exception) {
                throw new HibernateException("Could not locate method needed for ValidatorFactory validation", exception);
            }
        }
        catch (HibernateException hibernateException) {
            throw hibernateException;
        }
        catch (Exception exception) {
            throw new HibernateException("Could not locate TypeSafeActivator class", exception);
        }
    }

    @Override
    public void integrate(final Configuration configuration, final SessionFactoryImplementor sessionFactoryImplementor, final SessionFactoryServiceRegistry sessionFactoryServiceRegistry) {
        block9: {
            final Set<ValidationMode> set = ValidationMode.getModes(configuration.getProperties().get(MODE_PROPERTY));
            if (set.size() > 1) {
                LOG.multipleValidationModes(ValidationMode.loggable(set));
            }
            if (set.size() == 1 && set.contains((Object)ValidationMode.NONE)) {
                return;
            }
            ClassLoaderService classLoaderService = sessionFactoryServiceRegistry.getService(ClassLoaderService.class);
            if (this.isBeanValidationApiAvailable(classLoaderService)) {
                try {
                    Class clazz = this.loadTypeSafeActivatorClass(classLoaderService);
                    Method method = clazz.getMethod(ACTIVATE_METHOD_NAME, ActivationContext.class);
                    ActivationContext activationContext = new ActivationContext(){

                        @Override
                        public Set<ValidationMode> getValidationModes() {
                            return set;
                        }

                        @Override
                        public Configuration getConfiguration() {
                            return configuration;
                        }

                        @Override
                        public SessionFactoryImplementor getSessionFactory() {
                            return sessionFactoryImplementor;
                        }

                        @Override
                        public SessionFactoryServiceRegistry getServiceRegistry() {
                            return sessionFactoryServiceRegistry;
                        }
                    };
                    try {
                        method.invoke(null, activationContext);
                        break block9;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (HibernateException.class.isInstance(invocationTargetException.getTargetException())) {
                            throw (HibernateException)invocationTargetException.getTargetException();
                        }
                        throw new IntegrationException("Error activating Bean Validation integration", invocationTargetException.getTargetException());
                    }
                    catch (Exception exception) {
                        throw new IntegrationException("Error activating Bean Validation integration", exception);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new HibernateException("Unable to locate TypeSafeActivator#activate method", noSuchMethodException);
                }
            }
            this.validateMissingBeanValidationApi(set);
        }
    }

    private boolean isBeanValidationApiAvailable(ClassLoaderService classLoaderService) {
        try {
            classLoaderService.classForName(BV_CHECK_CLASS);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void validateMissingBeanValidationApi(Set<ValidationMode> set) {
        if (set.contains((Object)ValidationMode.CALLBACK)) {
            throw new IntegrationException("Bean Validation API was not available, but 'callback' validation was requested");
        }
        if (set.contains((Object)ValidationMode.DDL)) {
            throw new IntegrationException("Bean Validation API was not available, but 'ddl' validation was requested");
        }
    }

    private Class loadTypeSafeActivatorClass(ClassLoaderService classLoaderService) {
        try {
            return classLoaderService.classForName(ACTIVATOR_CLASS_NAME);
        }
        catch (Exception exception) {
            throw new HibernateException("Unable to load TypeSafeActivator class", exception);
        }
    }

    @Override
    public void integrate(MetadataImplementor metadataImplementor, SessionFactoryImplementor sessionFactoryImplementor, SessionFactoryServiceRegistry sessionFactoryServiceRegistry) {
    }

    @Override
    public void disintegrate(SessionFactoryImplementor sessionFactoryImplementor, SessionFactoryServiceRegistry sessionFactoryServiceRegistry) {
    }
}

