/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.EntityMode;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.beanvalidation.GroupsPerOperation;
import org.hibernate.cfg.beanvalidation.HibernateTraversableResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationEventListener
implements PreInsertEventListener,
PreUpdateEventListener,
PreDeleteEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, BeanValidationEventListener.class.getName());
    private ValidatorFactory factory;
    private ConcurrentHashMap<EntityPersister, Set<String>> associationsPerEntityPersister = new ConcurrentHashMap();
    private GroupsPerOperation groupsPerOperation;
    boolean initialized;

    public BeanValidationEventListener() {
    }

    public BeanValidationEventListener(ValidatorFactory validatorFactory, Properties properties) {
        this.init(validatorFactory, properties);
    }

    public void initialize(Configuration configuration) {
        if (!this.initialized) {
            ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
            Properties properties = configuration.getProperties();
            this.init(validatorFactory, properties);
        }
    }

    @Override
    public boolean onPreInsert(PreInsertEvent preInsertEvent) {
        this.validate(preInsertEvent.getEntity(), preInsertEvent.getPersister().getEntityMode(), preInsertEvent.getPersister(), preInsertEvent.getSession().getFactory(), GroupsPerOperation.Operation.INSERT);
        return false;
    }

    @Override
    public boolean onPreUpdate(PreUpdateEvent preUpdateEvent) {
        this.validate(preUpdateEvent.getEntity(), preUpdateEvent.getPersister().getEntityMode(), preUpdateEvent.getPersister(), preUpdateEvent.getSession().getFactory(), GroupsPerOperation.Operation.UPDATE);
        return false;
    }

    @Override
    public boolean onPreDelete(PreDeleteEvent preDeleteEvent) {
        this.validate(preDeleteEvent.getEntity(), preDeleteEvent.getPersister().getEntityMode(), preDeleteEvent.getPersister(), preDeleteEvent.getSession().getFactory(), GroupsPerOperation.Operation.DELETE);
        return false;
    }

    private void init(ValidatorFactory validatorFactory, Properties properties) {
        this.factory = validatorFactory;
        this.groupsPerOperation = new GroupsPerOperation(properties);
        this.initialized = true;
    }

    private <T> void validate(T t, EntityMode entityMode, EntityPersister entityPersister, SessionFactoryImplementor sessionFactoryImplementor, GroupsPerOperation.Operation operation) {
        Set set;
        if (t == null || entityMode != EntityMode.POJO) {
            return;
        }
        HibernateTraversableResolver hibernateTraversableResolver = new HibernateTraversableResolver(entityPersister, this.associationsPerEntityPersister, sessionFactoryImplementor);
        Validator validator = this.factory.usingContext().traversableResolver((TraversableResolver)hibernateTraversableResolver).getValidator();
        Class[] classArray = this.groupsPerOperation.get(operation);
        if (classArray.length > 0 && (set = validator.validate(t, classArray)).size() > 0) {
            HashSet<ConstraintViolation> hashSet = new HashSet<ConstraintViolation>(set.size());
            HashSet<String> hashSet2 = new HashSet<String>();
            for (Object object : set) {
                LOG.trace(object);
                hashSet.add((ConstraintViolation)object);
                hashSet2.add(object.getLeafBean().getClass().getName());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Validation failed for classes ");
            stringBuilder.append(hashSet2);
            stringBuilder.append(" during ");
            stringBuilder.append(operation.getName());
            stringBuilder.append(" time for groups ");
            stringBuilder.append(this.toString(classArray));
            stringBuilder.append("\nList of constraint violations:[\n");
            for (ConstraintViolation constraintViolation : set) {
                stringBuilder.append("\t").append(constraintViolation.toString()).append("\n");
            }
            stringBuilder.append("]");
            throw new ConstraintViolationException(stringBuilder.toString(), hashSet);
        }
    }

    private String toString(Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (Class<?> clazz : classArray) {
            stringBuilder.append(clazz.getName()).append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

