/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.UniqueConstraint;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.Index;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.IndexOrUniqueKeySecondPass;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.cfg.ObjectNameSource;
import org.hibernate.cfg.UniqueConstraintHolder;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TableBinder.class.getName());
    private String schema;
    private String catalog;
    private String name;
    private boolean isAbstract;
    private List<UniqueConstraintHolder> uniqueConstraints;
    String constraints;
    Table denormalizedSuperTable;
    Mappings mappings;
    private String ownerEntityTable;
    private String associatedEntityTable;
    private String propertyName;
    private String ownerEntity;
    private String associatedEntity;
    private boolean isJPA2ElementCollection;

    public void setSchema(String string) {
        this.schema = string;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setAbstract(boolean bl) {
        this.isAbstract = bl;
    }

    public void setUniqueConstraints(UniqueConstraint[] uniqueConstraintArray) {
        this.uniqueConstraints = TableBinder.buildUniqueConstraintHolders(uniqueConstraintArray);
    }

    public void setConstraints(String string) {
        this.constraints = string;
    }

    public void setDenormalizedSuperTable(Table table) {
        this.denormalizedSuperTable = table;
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    public void setJPA2ElementCollection(boolean bl) {
        this.isJPA2ElementCollection = bl;
    }

    public Table bind() {
        String string = StringHelper.unquote(this.ownerEntityTable);
        final String string2 = StringHelper.unquote(this.associatedEntityTable);
        final String string3 = this.isJPA2ElementCollection && this.ownerEntity != null ? StringHelper.unqualify(this.ownerEntity) : string;
        ObjectNameSource objectNameSource = this.buildNameContext(string3, string2);
        final boolean bl = StringHelper.isQuoted(this.ownerEntityTable);
        final boolean bl2 = StringHelper.isQuoted(this.associatedEntityTable);
        ObjectNameNormalizer.NamingStrategyHelper namingStrategyHelper = new ObjectNameNormalizer.NamingStrategyHelper(){

            public String determineImplicitName(NamingStrategy namingStrategy) {
                String string = namingStrategy.collectionTableName(TableBinder.this.ownerEntity, string3, TableBinder.this.associatedEntity, string2, TableBinder.this.propertyName);
                return bl || bl2 ? StringHelper.quote(string) : string;
            }

            public String handleExplicitName(NamingStrategy namingStrategy, String string) {
                return namingStrategy.tableName(string);
            }
        };
        return TableBinder.buildAndFillTable(this.schema, this.catalog, objectNameSource, namingStrategyHelper, this.isAbstract, this.uniqueConstraints, this.constraints, this.denormalizedSuperTable, this.mappings, null);
    }

    private ObjectNameSource buildNameContext(String string, String string2) {
        String string3 = this.mappings.getNamingStrategy().logicalCollectionTableName(this.name, string, string2, this.propertyName);
        if (StringHelper.isQuoted(this.ownerEntityTable) || StringHelper.isQuoted(this.associatedEntityTable)) {
            string3 = StringHelper.quote(string3);
        }
        return new AssociationTableNameSource(this.name, string3);
    }

    public static Table buildAndFillTable(String string, String string2, ObjectNameSource objectNameSource, ObjectNameNormalizer.NamingStrategyHelper namingStrategyHelper, boolean bl, List<UniqueConstraintHolder> list, String string3, Table table, Mappings mappings, String string4) {
        String string5;
        string = BinderHelper.isEmptyAnnotationValue(string) ? mappings.getSchemaName() : string;
        string2 = BinderHelper.isEmptyAnnotationValue(string2) ? mappings.getCatalogName() : string2;
        String string6 = mappings.getObjectNameNormalizer().normalizeDatabaseIdentifier(objectNameSource.getExplicitName(), namingStrategyHelper);
        Table table2 = table != null ? mappings.addDenormalizedTable(string, string2, string6, bl, string4, table) : mappings.addTable(string, string2, string6, string4, bl);
        if (list != null && list.size() > 0) {
            mappings.addUniqueConstraintHolders(table2, list);
        }
        if (string3 != null) {
            table2.addCheckConstraint(string3);
        }
        if ((string5 = objectNameSource.getLogicalName()) != null) {
            mappings.addTableBinding(string, string2, string5, string6, table);
        }
        return table2;
    }

    @Deprecated
    public static Table fillTable(String string, String string2, String string3, String string4, boolean bl, List list, String string5, Table table, Mappings mappings) {
        string = BinderHelper.isEmptyAnnotationValue(string) ? mappings.getSchemaName() : string;
        string2 = BinderHelper.isEmptyAnnotationValue(string2) ? mappings.getCatalogName() : string2;
        Table table2 = table != null ? mappings.addDenormalizedTable(string, string2, string3, bl, null, table) : mappings.addTable(string, string2, string3, null, bl);
        if (list != null && list.size() > 0) {
            mappings.addUniqueConstraints(table2, list);
        }
        if (string5 != null) {
            table2.addCheckConstraint(string5);
        }
        if (string4 != null) {
            mappings.addTableBinding(string, string2, string4, string3, table);
        }
        return table2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void bindFk(PersistentClass persistentClass, PersistentClass persistentClass2, Ejb3JoinColumn[] ejb3JoinColumnArray, SimpleValue simpleValue, boolean bl, Mappings mappings) {
        PersistentClass persistentClass3 = persistentClass2 != null ? persistentClass2 : (ejb3JoinColumnArray[0].getPropertyHolder() == null ? null : ejb3JoinColumnArray[0].getPropertyHolder().getPersistentClass());
        String string = ejb3JoinColumnArray[0].getMappedBy();
        if (StringHelper.isNotEmpty(string)) {
            Iterator iterator;
            LOG.debugf("Retrieving property %s.%s", (Object)persistentClass3.getEntityName(), (Object)string);
            Property property = persistentClass3.getRecursiveProperty(ejb3JoinColumnArray[0].getMappedBy());
            if (property.getValue() instanceof Collection) {
                Collection collection = (Collection)property.getValue();
                Value value = collection.getElement();
                if (value == null) {
                    throw new AnnotationException("Illegal use of mappedBy on both sides of the relationship: " + persistentClass3.getEntityName() + "." + string);
                }
                iterator = value.getColumnIterator();
            } else {
                iterator = property.getValue().getColumnIterator();
            }
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                ejb3JoinColumnArray[0].overrideFromReferencedColumnIfNecessary(column);
                ejb3JoinColumnArray[0].linkValueUsingAColumnCopy(column, simpleValue);
            }
        } else if (ejb3JoinColumnArray[0].isImplicit()) {
            Iterator iterator = persistentClass instanceof JoinedSubclass ? persistentClass.getKey().getColumnIterator() : persistentClass.getIdentifier().getColumnIterator();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                ejb3JoinColumnArray[0].overrideFromReferencedColumnIfNecessary(column);
                ejb3JoinColumnArray[0].linkValueUsingDefaultColumnNaming(column, persistentClass, simpleValue);
            }
        } else {
            int n = Ejb3JoinColumn.checkReferencedColumnsType(ejb3JoinColumnArray, persistentClass, mappings);
            if (2 == n) {
                String string2;
                if (simpleValue instanceof ToOne) {
                    string2 = ((ToOne)simpleValue).getReferencedPropertyName();
                } else {
                    if (!(simpleValue instanceof DependantValue)) throw new AssertionFailure("Do a property ref on an unexpected Value type: " + simpleValue.getClass().getName());
                    String string3 = ejb3JoinColumnArray[0].getPropertyName();
                    if (string3 == null) throw new AnnotationException("SecondaryTable JoinColumn cannot reference a non primary key");
                    Collection collection = (Collection)persistentClass.getRecursiveProperty(string3).getValue();
                    string2 = collection.getReferencedPropertyName();
                }
                if (string2 == null) {
                    throw new AssertionFailure("No property ref found while expected");
                }
                Property property = persistentClass.getReferencedProperty(string2);
                if (property == null) {
                    throw new AssertionFailure("Cannot find synthProp: " + persistentClass.getEntityName() + "." + string2);
                }
                TableBinder.linkJoinColumnWithValueOverridingNameIfImplicit(persistentClass, property.getColumnIterator(), ejb3JoinColumnArray, simpleValue);
            } else if (0 == n) {
                if (ejb3JoinColumnArray.length != persistentClass.getIdentifier().getColumnSpan()) {
                    throw new AnnotationException("A Foreign key refering " + persistentClass.getEntityName() + " from " + persistentClass3.getEntityName() + " has the wrong number of column. should be " + persistentClass.getIdentifier().getColumnSpan());
                }
                TableBinder.linkJoinColumnWithValueOverridingNameIfImplicit(persistentClass, persistentClass.getIdentifier().getColumnIterator(), ejb3JoinColumnArray, simpleValue);
            } else {
                Iterator iterator = persistentClass.getKey().getColumnIterator();
                Table table = persistentClass.getTable();
                if (!iterator.hasNext()) {
                    LOG.debug("No column in the identifier!");
                }
                while (iterator.hasNext()) {
                    boolean bl2 = false;
                    Column column = (Column)iterator.next();
                    for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
                        String string4 = ejb3JoinColumn.getReferencedColumn();
                        if (!(string4 = mappings.getPhysicalColumnName(string4, table)).equalsIgnoreCase(column.getQuotedName())) continue;
                        if (ejb3JoinColumn.isNameDeferred()) {
                            ejb3JoinColumn.linkValueUsingDefaultColumnNaming(column, persistentClass, simpleValue);
                        } else {
                            ejb3JoinColumn.linkWithValue(simpleValue);
                        }
                        ejb3JoinColumn.overrideFromReferencedColumnIfNecessary(column);
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    throw new AnnotationException("Column name " + column.getName() + " of " + persistentClass.getEntityName() + " not found in JoinColumns.referencedColumnName");
                }
            }
        }
        simpleValue.createForeignKey();
        if (!bl) return;
        TableBinder.createUniqueConstraint(simpleValue);
    }

    public static void linkJoinColumnWithValueOverridingNameIfImplicit(PersistentClass persistentClass, Iterator iterator, Ejb3JoinColumn[] ejb3JoinColumnArray, SimpleValue simpleValue) {
        for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
            Column column = (Column)iterator.next();
            if (ejb3JoinColumn.isNameDeferred()) {
                ejb3JoinColumn.linkValueUsingDefaultColumnNaming(column, persistentClass, simpleValue);
                continue;
            }
            ejb3JoinColumn.linkWithValue(simpleValue);
            ejb3JoinColumn.overrideFromReferencedColumnIfNecessary(column);
        }
    }

    public static void createUniqueConstraint(Value value) {
        Iterator iterator = value.getColumnIterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        value.getTable().createUniqueKey(arrayList);
    }

    public static void addIndexes(Table table, Index[] indexArray, Mappings mappings) {
        for (Index index : indexArray) {
            mappings.addSecondPass(new IndexOrUniqueKeySecondPass(table, index.name(), index.columnNames(), mappings));
        }
    }

    @Deprecated
    public static List<String[]> buildUniqueConstraints(UniqueConstraint[] uniqueConstraintArray) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (uniqueConstraintArray.length != 0) {
            for (UniqueConstraint uniqueConstraint : uniqueConstraintArray) {
                arrayList.add(uniqueConstraint.columnNames());
            }
        }
        return arrayList;
    }

    public static List<UniqueConstraintHolder> buildUniqueConstraintHolders(UniqueConstraint[] uniqueConstraintArray) {
        List<UniqueConstraintHolder> list;
        if (uniqueConstraintArray == null || uniqueConstraintArray.length == 0) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList<UniqueConstraintHolder>(CollectionHelper.determineProperSizing(uniqueConstraintArray.length));
            for (UniqueConstraint uniqueConstraint : uniqueConstraintArray) {
                list.add(new UniqueConstraintHolder().setName(uniqueConstraint.name()).setColumns(uniqueConstraint.columnNames()));
            }
        }
        return list;
    }

    public void setDefaultName(String string, String string2, String string3, String string4, String string5) {
        this.ownerEntity = string;
        this.ownerEntityTable = string2;
        this.associatedEntity = string3;
        this.associatedEntityTable = string4;
        this.propertyName = string5;
        this.name = null;
    }

    private static class AssociationTableNameSource
    implements ObjectNameSource {
        private final String explicitName;
        private final String logicalName;

        private AssociationTableNameSource(String string, String string2) {
            this.explicitName = string;
            this.logicalName = string2;
        }

        public String getExplicitName() {
            return this.explicitName;
        }

        public String getLogicalName() {
            return this.logicalName;
        }
    }
}

