/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyTemporal;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.Nationalized;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.PkDrivenByDefaultMapsIdSecondPass;
import org.hibernate.cfg.SetSimpleValueTypeSecondPass;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TypeDef;
import org.hibernate.type.CharacterArrayClobType;
import org.hibernate.type.CharacterArrayNClobType;
import org.hibernate.type.CharacterNCharType;
import org.hibernate.type.EnumType;
import org.hibernate.type.PrimitiveCharacterArrayClobType;
import org.hibernate.type.PrimitiveCharacterArrayNClobType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.StringNVarcharType;
import org.hibernate.type.WrappedMaterializedBlobType;
import org.hibernate.usertype.DynamicParameterizedType;
import org.jboss.logging.Logger;

public class SimpleValueBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SimpleValueBinder.class.getName());
    private String propertyName;
    private String returnedClassName;
    private Ejb3Column[] columns;
    private String persistentClassName;
    private String explicitType = "";
    private String defaultType = "";
    private Properties typeParameters = new Properties();
    private Mappings mappings;
    private Table table;
    private SimpleValue simpleValue;
    private boolean isVersion;
    private String timeStampVersionType;
    private boolean key;
    private String referencedEntityName;
    private XProperty xproperty;
    private AccessType accessType;

    public void setReferencedEntityName(String string) {
        this.referencedEntityName = string;
    }

    public boolean isVersion() {
        return this.isVersion;
    }

    public void setVersion(boolean bl) {
        this.isVersion = bl;
    }

    public void setTimestampVersionType(String string) {
        this.timeStampVersionType = string;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public void setReturnedClassName(String string) {
        this.returnedClassName = string;
        if (this.defaultType.length() == 0) {
            this.defaultType = string;
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Ejb3Column[] ejb3ColumnArray) {
        this.columns = ejb3ColumnArray;
    }

    public void setPersistentClassName(String string) {
        this.persistentClassName = string;
    }

    public void setType(XProperty xProperty, XClass xClass, String string) {
        if (xClass == null) {
            return;
        }
        XClass xClass2 = xClass;
        boolean bl = false;
        if (xProperty.isArray()) {
            xClass2 = xProperty.getElementClass();
            bl = true;
        }
        this.xproperty = xProperty;
        String string2 = "";
        boolean bl2 = xProperty.isAnnotationPresent(Nationalized.class) || this.mappings.useNationalizedCharacterData();
        Type type = xProperty.getAnnotation(Type.class);
        if (type != null) {
            this.setExplicitType(type);
            string2 = this.explicitType;
        } else if (!this.key && xProperty.isAnnotationPresent(Temporal.class) || this.key && xProperty.isAnnotationPresent(MapKeyTemporal.class)) {
            boolean bl3;
            if (this.mappings.getReflectionManager().equals(xClass2, Date.class)) {
                bl3 = true;
            } else if (this.mappings.getReflectionManager().equals(xClass2, Calendar.class)) {
                bl3 = false;
            } else {
                throw new AnnotationException("@Temporal should only be set on a java.util.Date or java.util.Calendar property: " + StringHelper.qualify(this.persistentClassName, this.propertyName));
            }
            TemporalType temporalType = this.getTemporalType(xProperty);
            switch (temporalType) {
                case DATE: {
                    string2 = bl3 ? "date" : "calendar_date";
                    break;
                }
                case TIME: {
                    string2 = "time";
                    if (bl3) break;
                    throw new NotYetImplementedException("Calendar cannot persist TIME only" + StringHelper.qualify(this.persistentClassName, this.propertyName));
                }
                case TIMESTAMP: {
                    string2 = bl3 ? "timestamp" : "calendar";
                    break;
                }
                default: {
                    throw new AssertionFailure("Unknown temporal type: " + (Object)((Object)temporalType));
                }
            }
            this.explicitType = string2;
        } else if (xProperty.isAnnotationPresent(Lob.class)) {
            string2 = this.mappings.getReflectionManager().equals(xClass2, Clob.class) ? (bl2 ? StandardBasicTypes.NCLOB.getName() : StandardBasicTypes.CLOB.getName()) : (this.mappings.getReflectionManager().equals(xClass2, NClob.class) ? StandardBasicTypes.NCLOB.getName() : (this.mappings.getReflectionManager().equals(xClass2, Blob.class) ? "blob" : (this.mappings.getReflectionManager().equals(xClass2, String.class) ? (bl2 ? StandardBasicTypes.MATERIALIZED_NCLOB.getName() : StandardBasicTypes.MATERIALIZED_CLOB.getName()) : (this.mappings.getReflectionManager().equals(xClass2, Character.class) && bl ? (bl2 ? CharacterArrayNClobType.class.getName() : CharacterArrayClobType.class.getName()) : (this.mappings.getReflectionManager().equals(xClass2, Character.TYPE) && bl ? (bl2 ? PrimitiveCharacterArrayNClobType.class.getName() : PrimitiveCharacterArrayClobType.class.getName()) : (this.mappings.getReflectionManager().equals(xClass2, Byte.class) && bl ? WrappedMaterializedBlobType.class.getName() : (this.mappings.getReflectionManager().equals(xClass2, Byte.TYPE) && bl ? StandardBasicTypes.MATERIALIZED_BLOB.getName() : (this.mappings.getReflectionManager().toXClass(Serializable.class).isAssignableFrom(xClass2) ? SerializableToBlobType.class.getName() : "blob"))))))));
            this.explicitType = string2;
        } else if (!this.key && xProperty.isAnnotationPresent(Enumerated.class) || this.key && xProperty.isAnnotationPresent(MapKeyEnumerated.class)) {
            Class clazz = this.mappings.getReflectionManager().toClass(xClass2);
            if (!Enum.class.isAssignableFrom(clazz)) {
                throw new AnnotationException(String.format("Attribute [%s.%s] was annotated as enumerated, but its java type is not an enum [%s]", string, this.xproperty.getName(), clazz.getName()));
            }
            this.explicitType = string2 = EnumType.class.getName();
        } else if (bl2) {
            if (this.mappings.getReflectionManager().equals(xClass2, String.class)) {
                this.explicitType = string2 = StringNVarcharType.INSTANCE.getName();
            } else if (this.mappings.getReflectionManager().equals(xClass2, Character.class)) {
                string2 = bl ? StringNVarcharType.INSTANCE.getName() : CharacterNCharType.INSTANCE.getName();
                this.explicitType = string2;
            }
        }
        if (this.columns == null) {
            throw new AssertionFailure("SimpleValueBinder.setColumns should be set before SimpleValueBinder.setType");
        }
        if ("".equals(string2) && xClass2.isEnum()) {
            string2 = EnumType.class.getName();
        }
        this.defaultType = BinderHelper.isEmptyAnnotationValue(string2) ? this.returnedClassName : string2;
    }

    private TemporalType getTemporalType(XProperty xProperty) {
        if (this.key) {
            MapKeyTemporal mapKeyTemporal = xProperty.getAnnotation(MapKeyTemporal.class);
            return mapKeyTemporal.value();
        }
        Temporal temporal = xProperty.getAnnotation(Temporal.class);
        return temporal.value();
    }

    public void setExplicitType(String string) {
        this.explicitType = string;
    }

    public void setExplicitType(Type type) {
        if (type != null) {
            this.explicitType = type.type();
            this.typeParameters.clear();
            for (Parameter parameter : type.parameters()) {
                this.typeParameters.setProperty(parameter.name(), parameter.value());
            }
        }
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    private void validate() {
        Ejb3Column.checkPropertyConsistency(this.columns, this.propertyName);
    }

    public SimpleValue make() {
        this.validate();
        LOG.debugf("building SimpleValue for %s", (Object)this.propertyName);
        if (this.table == null) {
            this.table = this.columns[0].getTable();
        }
        this.simpleValue = new SimpleValue(this.mappings, this.table);
        this.linkWithValue();
        boolean bl = this.mappings.isInSecondPass();
        SetSimpleValueTypeSecondPass setSimpleValueTypeSecondPass = new SetSimpleValueTypeSecondPass(this);
        if (!bl) {
            this.mappings.addSecondPass(setSimpleValueTypeSecondPass);
        } else {
            this.fillSimpleValue();
        }
        return this.simpleValue;
    }

    public void linkWithValue() {
        if (this.columns[0].isNameDeferred() && !this.mappings.isInSecondPass() && this.referencedEntityName != null) {
            this.mappings.addSecondPass(new PkDrivenByDefaultMapsIdSecondPass(this.referencedEntityName, (Ejb3JoinColumn[])this.columns, this.simpleValue));
        } else {
            for (Ejb3Column ejb3Column : this.columns) {
                ejb3Column.linkWithValue(this.simpleValue);
            }
        }
    }

    public void fillSimpleValue() {
        Serializable serializable;
        TypeDef typeDef;
        String string;
        LOG.debugf("Setting SimpleValue typeName for %s", (Object)this.propertyName);
        if (!BinderHelper.isEmptyAnnotationValue(this.explicitType)) {
            string = this.explicitType;
            typeDef = this.mappings.getTypeDef(string);
        } else {
            serializable = this.mappings.getTypeDef(this.returnedClassName);
            if (serializable != null) {
                typeDef = serializable;
                string = this.returnedClassName;
            } else {
                typeDef = this.mappings.getTypeDef(this.defaultType);
                string = this.defaultType;
            }
        }
        if (typeDef != null) {
            string = typeDef.getTypeClass();
            this.simpleValue.setTypeParameters(typeDef.getParameters());
        }
        if (this.typeParameters != null && this.typeParameters.size() != 0) {
            this.simpleValue.setTypeParameters(this.typeParameters);
        }
        this.simpleValue.setTypeName(string);
        if (this.persistentClassName != null) {
            this.simpleValue.setTypeUsingReflection(this.persistentClassName, this.propertyName);
        }
        if (!this.simpleValue.isTypeSpecified() && this.isVersion()) {
            this.simpleValue.setTypeName("integer");
        }
        if (this.timeStampVersionType != null) {
            this.simpleValue.setTypeName(this.timeStampVersionType);
        }
        if (this.simpleValue.getTypeName() != null && this.simpleValue.getTypeName().length() > 0 && this.simpleValue.getMappings().getTypeResolver().basic(this.simpleValue.getTypeName()) == null) {
            try {
                serializable = ReflectHelper.classForName(this.simpleValue.getTypeName());
                if (serializable != null && DynamicParameterizedType.class.isAssignableFrom((Class<?>)serializable)) {
                    Properties properties = this.simpleValue.getTypeParameters();
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.put("org.hibernate.type.ParameterType.dynamic", Boolean.toString(true));
                    properties.put("org.hibernate.type.ParameterType.returnedClass", this.returnedClassName);
                    properties.put("org.hibernate.type.ParameterType.primaryKey", Boolean.toString(this.key));
                    properties.put("org.hibernate.type.ParameterType.entityClass", this.persistentClassName);
                    properties.put("org.hibernate.type.ParameterType.xproperty", this.xproperty);
                    properties.put("org.hibernate.type.ParameterType.propertyName", this.xproperty.getName());
                    properties.put("org.hibernate.type.ParameterType.accessType", this.accessType.getType());
                    this.simpleValue.setTypeParameters(properties);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MappingException("Could not determine type for: " + this.simpleValue.getTypeName(), classNotFoundException);
            }
        }
    }

    public void setKey(boolean bl) {
        this.key = bl;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }
}

