/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityResult;
import javax.persistence.FieldResult;
import javax.persistence.SqlResultSetMapping;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.QuerySecondPass;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryScalarReturn;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.jboss.logging.Logger;

public class ResultsetMappingSecondPass
implements QuerySecondPass {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, ResultsetMappingSecondPass.class.getName());
    private SqlResultSetMapping ann;
    private Mappings mappings;
    private boolean isDefault;

    public ResultsetMappingSecondPass(SqlResultSetMapping sqlResultSetMapping, Mappings mappings, boolean bl) {
        this.ann = sqlResultSetMapping;
        this.mappings = mappings;
        this.isDefault = bl;
    }

    public void doSecondPass(Map map) throws MappingException {
        if (this.ann == null) {
            return;
        }
        ResultSetMappingDefinition resultSetMappingDefinition = new ResultSetMappingDefinition(this.ann.name());
        LOG.debugf("Binding result set mapping: %s", (Object)resultSetMappingDefinition.getName());
        int n = 0;
        for (EntityResult annotation : this.ann.entities()) {
            ArrayList<String> arrayList;
            String string;
            Object object;
            ArrayList<FieldResult> arrayList2 = new ArrayList<FieldResult>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (FieldResult fieldResult : annotation.fields()) {
                String string2 = fieldResult.name();
                if (string2.indexOf(46) == -1) {
                    arrayList2.add(fieldResult);
                    arrayList3.add(string2);
                    continue;
                }
                object = this.mappings.getClass(annotation.entityClass().getName());
                if (object == null) {
                    throw new MappingException("Entity not found " + annotation.entityClass().getName() + " in SqlResultsetMapping " + this.ann.name());
                }
                int n2 = string2.lastIndexOf(46);
                string = string2.substring(0, n2);
                arrayList = this.getSubPropertyIterator((PersistentClass)object, string);
                List list = this.getFollowers((Iterator)((Object)arrayList), string, string2);
                int n3 = arrayList3.size();
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    String string3 = (String)list.get(i);
                    int n5 = ResultsetMappingSecondPass.getIndexOfFirstMatchingProperty(arrayList3, string3);
                    n3 = n5 != -1 && n5 < n3 ? n5 : n3;
                }
                arrayList3.add(n3, string2);
                arrayList2.add(n3, fieldResult);
            }
            HashSet hashSet = new HashSet();
            HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
            for (Object e : arrayList2) {
                FieldResult fieldResult = (FieldResult)e;
                object = fieldResult.name();
                if ("class".equals(object)) {
                    throw new MappingException("class is not a valid property name to use in a @FieldResult, use @Entity(discriminatorColumn) instead");
                }
                if (hashSet.contains(object)) {
                    throw new MappingException("duplicate @FieldResult for property " + (String)object + " on @Entity " + annotation.entityClass().getName() + " in " + this.ann.name());
                }
                hashSet.add(object);
                String string4 = this.mappings.getObjectNameNormalizer().normalizeIdentifierQuoting(fieldResult.column());
                string = StringHelper.root((String)object);
                arrayList = (ArrayList)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(string4);
            }
            Map<String, String[]> map2 = new HashMap();
            for (Map.Entry entry : hashMap.entrySet()) {
                map2.put((String)entry.getKey(), ((ArrayList)entry.getValue()).toArray(new String[((ArrayList)entry.getValue()).size()]));
            }
            if (!BinderHelper.isEmptyAnnotationValue(annotation.discriminatorColumn())) {
                String string5 = this.mappings.getObjectNameNormalizer().normalizeIdentifierQuoting(annotation.discriminatorColumn());
                map2.put("class", new String[]{string5});
            }
            if (map2.isEmpty()) {
                map2 = Collections.emptyMap();
            }
            NativeSQLQueryRootReturn nativeSQLQueryRootReturn = new NativeSQLQueryRootReturn("alias" + n++, annotation.entityClass().getName(), map2, LockMode.READ);
            resultSetMappingDefinition.addQueryReturn(nativeSQLQueryRootReturn);
        }
        for (Annotation annotation : this.ann.columns()) {
            resultSetMappingDefinition.addQueryReturn(new NativeSQLQueryScalarReturn(this.mappings.getObjectNameNormalizer().normalizeIdentifierQuoting(annotation.name()), null));
        }
        if (this.isDefault) {
            this.mappings.addDefaultResultSetMapping(resultSetMappingDefinition);
        } else {
            this.mappings.addResultSetMapping(resultSetMappingDefinition);
        }
    }

    private List getFollowers(Iterator iterator, String string, String string2) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string3 = ((Property)iterator.next()).getName();
            String string4 = string + '.' + string3;
            if (bl) {
                arrayList.add(string4);
            }
            if (!string2.equals(string4)) continue;
            bl = true;
        }
        return arrayList;
    }

    private Iterator getSubPropertyIterator(PersistentClass persistentClass, String string) {
        Iterator iterator;
        Value value = persistentClass.getRecursiveProperty(string).getValue();
        if (value instanceof Component) {
            Component component = (Component)value;
            iterator = component.getPropertyIterator();
        } else if (value instanceof ToOne) {
            ToOne toOne = (ToOne)value;
            PersistentClass persistentClass2 = this.mappings.getClass(toOne.getReferencedEntityName());
            if (toOne.getReferencedPropertyName() != null) {
                try {
                    iterator = ((Component)persistentClass2.getRecursiveProperty(toOne.getReferencedPropertyName()).getValue()).getPropertyIterator();
                }
                catch (ClassCastException classCastException) {
                    throw new MappingException("dotted notation reference neither a component nor a many/one to one", classCastException);
                }
            } else {
                try {
                    if (persistentClass2.getIdentifierMapper() == null) {
                        iterator = ((Component)persistentClass2.getIdentifierProperty().getValue()).getPropertyIterator();
                    }
                    iterator = persistentClass2.getIdentifierMapper().getPropertyIterator();
                }
                catch (ClassCastException classCastException) {
                    throw new MappingException("dotted notation reference neither a component nor a many/one to one", classCastException);
                }
            }
        } else {
            throw new MappingException("dotted notation reference neither a component nor a many/one to one");
        }
        return iterator;
    }

    private static int getIndexOfFirstMatchingProperty(List list, String string) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!((String)list.get(i)).startsWith(string)) continue;
            return i;
        }
        return -1;
    }
}

