/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.Map;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Version;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyPreloadedData;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, PropertyBinder.class.getName());
    private String name;
    private String returnedClassName;
    private boolean lazy;
    private AccessType accessType;
    private Ejb3Column[] columns;
    private PropertyHolder holder;
    private Mappings mappings;
    private Value value;
    private boolean insertable = true;
    private boolean updatable = true;
    private String cascade;
    private SimpleValueBinder simpleValueBinder;
    private XClass declaringClass;
    private boolean declaringClassSet;
    private boolean embedded;
    private EntityBinder entityBinder;
    private boolean isXToMany;
    private String referencedEntityName;
    private XProperty property;
    private XClass returnedClass;
    private boolean isId;
    private Map<XClass, InheritanceState> inheritanceStatePerClass;
    private Property mappingProperty;

    public void setReferencedEntityName(String string) {
        this.referencedEntityName = string;
    }

    public void setEmbedded(boolean bl) {
        this.embedded = bl;
    }

    public void setEntityBinder(EntityBinder entityBinder) {
        this.entityBinder = entityBinder;
    }

    public void setInsertable(boolean bl) {
        this.insertable = bl;
    }

    public void setUpdatable(boolean bl) {
        this.updatable = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setReturnedClassName(String string) {
        this.returnedClassName = string;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public void setColumns(Ejb3Column[] ejb3ColumnArray) {
        this.insertable = ejb3ColumnArray[0].isInsertable();
        this.updatable = ejb3ColumnArray[0].isUpdatable();
        this.columns = ejb3ColumnArray;
    }

    public void setHolder(PropertyHolder propertyHolder) {
        this.holder = propertyHolder;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public void setCascade(String string) {
        this.cascade = string;
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    public void setDeclaringClass(XClass xClass) {
        this.declaringClass = xClass;
        this.declaringClassSet = true;
    }

    private void validateBind() {
        if (this.property.isAnnotationPresent(Immutable.class)) {
            throw new AnnotationException("@Immutable on property not allowed. Only allowed on entity level or on a collection.");
        }
        if (!this.declaringClassSet) {
            throw new AssertionFailure("declaringClass has not been set before a bind");
        }
    }

    private void validateMake() {
    }

    private Property makePropertyAndValue() {
        this.validateBind();
        LOG.debugf("MetadataSourceProcessor property %s with lazy=%s", (Object)this.name, (Object)this.lazy);
        String string = this.holder == null ? null : this.holder.getClassName();
        this.simpleValueBinder = new SimpleValueBinder();
        this.simpleValueBinder.setMappings(this.mappings);
        this.simpleValueBinder.setPropertyName(this.name);
        this.simpleValueBinder.setReturnedClassName(this.returnedClassName);
        this.simpleValueBinder.setColumns(this.columns);
        this.simpleValueBinder.setPersistentClassName(string);
        this.simpleValueBinder.setType(this.property, this.returnedClass, string);
        this.simpleValueBinder.setMappings(this.mappings);
        this.simpleValueBinder.setReferencedEntityName(this.referencedEntityName);
        this.simpleValueBinder.setAccessType(this.accessType);
        SimpleValue simpleValue = this.simpleValueBinder.make();
        this.setValue(simpleValue);
        return this.makeProperty();
    }

    public Property makePropertyAndBind() {
        return this.bind(this.makeProperty());
    }

    public Property makePropertyValueAndBind() {
        return this.bind(this.makePropertyAndValue());
    }

    public void setXToMany(boolean bl) {
        this.isXToMany = bl;
    }

    private Property bind(Property property) {
        if (this.isId) {
            RootClass rootClass = (RootClass)this.holder.getPersistentClass();
            if (this.isXToMany || this.entityBinder.wrapIdsInEmbeddedComponents()) {
                Component component = (Component)rootClass.getIdentifier();
                if (component == null) {
                    component = AnnotationBinder.createComponent(this.holder, new PropertyPreloadedData(null, null, null), true, false, this.mappings);
                    rootClass.setIdentifier(component);
                    component.setNullValue("undefined");
                    rootClass.setEmbeddedIdentifier(true);
                    rootClass.setIdentifierMapper(component);
                }
                component.addProperty(property);
            } else {
                rootClass.setIdentifier((KeyValue)this.getValue());
                if (this.embedded) {
                    rootClass.setEmbeddedIdentifier(true);
                } else {
                    rootClass.setIdentifierProperty(property);
                    MappedSuperclass mappedSuperclass = BinderHelper.getMappedSuperclassOrNull(this.declaringClass, this.inheritanceStatePerClass, this.mappings);
                    if (mappedSuperclass != null) {
                        mappedSuperclass.setDeclaredIdentifierProperty(property);
                    } else {
                        rootClass.setDeclaredIdentifierProperty(property);
                    }
                }
            }
        } else {
            this.holder.addProperty(property, this.columns, this.declaringClass);
        }
        return property;
    }

    public Property makeProperty() {
        NaturalId naturalId;
        GenerationTime generationTime;
        this.validateMake();
        LOG.debugf("Building property %s", (Object)this.name);
        Property property = new Property();
        property.setName(this.name);
        property.setNodeName(this.name);
        property.setValue(this.value);
        property.setLazy(this.lazy);
        property.setCascade(this.cascade);
        property.setPropertyAccessorName(this.accessType.getType());
        Generated generated = this.property != null ? this.property.getAnnotation(Generated.class) : null;
        GenerationTime generationTime2 = generationTime = generated != null ? generated.value() : null;
        if (generationTime != null && !GenerationTime.NEVER.equals((Object)generationTime)) {
            if (this.property.isAnnotationPresent(Version.class) && GenerationTime.INSERT.equals((Object)generationTime)) {
                throw new AnnotationException("@Generated(INSERT) on a @Version property not allowed, use ALWAYS: " + StringHelper.qualify(this.holder.getPath(), this.name));
            }
            this.insertable = false;
            if (GenerationTime.ALWAYS.equals((Object)generationTime)) {
                this.updatable = false;
            }
            property.setGeneration(PropertyGeneration.parse(generationTime.toString().toLowerCase()));
        }
        NaturalId naturalId2 = naturalId = this.property != null ? this.property.getAnnotation(NaturalId.class) : null;
        if (naturalId != null) {
            if (!this.entityBinder.isRootEntity()) {
                throw new AnnotationException("@NaturalId only valid on root entity (or its @MappedSuperclasses)");
            }
            if (!naturalId.mutable()) {
                this.updatable = false;
            }
            property.setNaturalIdentifier(true);
        }
        Lob lob = this.property != null ? this.property.getAnnotation(Lob.class) : null;
        property.setLob(lob != null);
        property.setInsertable(this.insertable);
        property.setUpdateable(this.updatable);
        if (Collection.class.isInstance(this.value)) {
            property.setOptimisticLocked(((Collection)this.value).isOptimisticLocked());
        } else {
            boolean bl;
            OptimisticLock optimisticLock;
            OptimisticLock optimisticLock2 = optimisticLock = this.property != null ? this.property.getAnnotation(OptimisticLock.class) : null;
            if (optimisticLock != null && optimisticLock.excluded() && (this.property.isAnnotationPresent(Version.class) || this.property.isAnnotationPresent(Id.class) || this.property.isAnnotationPresent(EmbeddedId.class))) {
                throw new AnnotationException("@OptimisticLock.exclude=true incompatible with @Id, @EmbeddedId and @Version: " + StringHelper.qualify(this.holder.getPath(), this.name));
            }
            boolean bl2 = bl = !this.isToOneValue(this.value) || this.insertable;
            boolean bl3 = optimisticLock != null ? !optimisticLock.excluded() : bl;
            property.setOptimisticLocked(bl3);
        }
        LOG.tracev("Cascading {0} with {1}", (Object)this.name, (Object)this.cascade);
        this.mappingProperty = property;
        return property;
    }

    private boolean isCollection(Value value) {
        return Collection.class.isInstance(value);
    }

    private boolean isToOneValue(Value value) {
        return ToOne.class.isInstance(value);
    }

    public void setProperty(XProperty xProperty) {
        this.property = xProperty;
    }

    public void setReturnedClass(XClass xClass) {
        this.returnedClass = xClass;
    }

    public SimpleValueBinder getSimpleValueBinder() {
        return this.simpleValueBinder;
    }

    public Value getValue() {
        return this.value;
    }

    public void setId(boolean bl) {
        this.isId = bl;
    }

    public void setInheritanceStatePerClass(Map<XClass, InheritanceState> map) {
        this.inheritanceStatePerClass = map;
    }
}

