/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Random;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.MapKeyClass;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.MapKeyType;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyPreloadedData;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.CollectionBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.sql.Template;

public class MapBinder
extends CollectionBinder {
    public MapBinder(boolean bl) {
        super(bl);
    }

    public MapBinder() {
    }

    public boolean isMap() {
        return true;
    }

    protected Collection createCollection(PersistentClass persistentClass) {
        return new Map(this.getMappings(), persistentClass);
    }

    public SecondPass getSecondPass(final Ejb3JoinColumn[] ejb3JoinColumnArray, final Ejb3JoinColumn[] ejb3JoinColumnArray2, final Ejb3JoinColumn[] ejb3JoinColumnArray3, final Ejb3Column[] ejb3ColumnArray, final Ejb3Column[] ejb3ColumnArray2, final Ejb3JoinColumn[] ejb3JoinColumnArray4, final boolean bl, final XProperty xProperty, final XClass xClass, final boolean bl2, final boolean bl3, final TableBinder tableBinder, final Mappings mappings) {
        return new CollectionSecondPass(mappings, this.collection){

            public void secondPass(java.util.Map map, java.util.Map map2) throws MappingException {
                MapBinder.this.bindStarToManySecondPass(map, xClass, ejb3JoinColumnArray, ejb3JoinColumnArray2, ejb3JoinColumnArray3, ejb3ColumnArray, bl, xProperty, bl3, tableBinder, bl2, mappings);
                MapBinder.this.bindKeyFromAssociationTable(xClass, map, MapBinder.this.mapKeyPropertyName, xProperty, bl, mappings, ejb3ColumnArray2, ejb3JoinColumnArray4, ejb3JoinColumnArray3 != null ? ejb3JoinColumnArray3[0].getPropertyName() : null);
            }
        };
    }

    private void bindKeyFromAssociationTable(XClass xClass, java.util.Map map, String string, XProperty xProperty, boolean bl, Mappings mappings, Ejb3Column[] ejb3ColumnArray, Ejb3JoinColumn[] ejb3JoinColumnArray, String string2) {
        if (string != null) {
            PersistentClass persistentClass = (PersistentClass)map.get(xClass.getName());
            if (persistentClass == null) {
                throw new AnnotationException("Associated class not found: " + xClass);
            }
            Property property = BinderHelper.findPropertyByName(persistentClass, string);
            if (property == null) {
                throw new AnnotationException("Map key property not found: " + xClass + "." + string);
            }
            Map map2 = (Map)this.collection;
            Value value = this.createFormulatedValue(property.getValue(), map2, string2, persistentClass, mappings);
            map2.setIndex(value);
        } else {
            Class clazz = Void.TYPE;
            if (xProperty.isAnnotationPresent(MapKeyClass.class)) {
                clazz = xProperty.getAnnotation(MapKeyClass.class).value();
            }
            String string3 = !Void.TYPE.equals(clazz) ? clazz.getName() : xProperty.getMapKey().getName();
            PersistentClass persistentClass = (PersistentClass)map.get(string3);
            boolean bl2 = persistentClass != null;
            ManyToOne manyToOne = null;
            Map map3 = (Map)this.collection;
            if (bl2) {
                manyToOne = new ManyToOne(mappings, map3.getCollectionTable());
                map3.setIndex(manyToOne);
                manyToOne.setReferencedEntityName(string3);
                manyToOne.setFetchMode(FetchMode.JOIN);
                manyToOne.setLazy(false);
            } else {
                Object object;
                Object object2;
                Object object3;
                AccessType accessType;
                Ejb3JoinColumn[] ejb3JoinColumnArray2;
                AnnotatedClassType annotatedClassType;
                PropertyHolder propertyHolder = null;
                if (BinderHelper.PRIMITIVE_NAMES.contains(string3)) {
                    annotatedClassType = AnnotatedClassType.NONE;
                    ejb3JoinColumnArray2 = null;
                } else {
                    boolean bl3;
                    try {
                        ejb3JoinColumnArray2 = mappings.getReflectionManager().classForName(string3, MapBinder.class);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new AnnotationException("Unable to find class: " + string3, classNotFoundException);
                    }
                    annotatedClassType = mappings.getClassType((XClass)ejb3JoinColumnArray2);
                    propertyHolder = PropertyHolderBuilder.buildPropertyHolder(map3, StringHelper.qualify(map3.getRole(), "mapkey"), (XClass)ejb3JoinColumnArray2, xProperty, this.propertyHolder, mappings);
                    boolean bl4 = bl3 = xProperty.isAnnotationPresent(AttributeOverride.class) || xProperty.isAnnotationPresent(AttributeOverrides.class);
                    if (bl || bl3) {
                        annotatedClassType = AnnotatedClassType.EMBEDDABLE;
                    }
                }
                PersistentClass object4 = map3.getOwner();
                if (object4.getIdentifierProperty() != null) {
                    accessType = object4.getIdentifierProperty().getPropertyAccessorName().equals("property") ? AccessType.PROPERTY : AccessType.FIELD;
                } else if (object4.getIdentifierMapper() != null && object4.getIdentifierMapper().getPropertySpan() > 0) {
                    object3 = (Property)object4.getIdentifierMapper().getPropertyIterator().next();
                    accessType = ((Property)object3).getPropertyAccessorName().equals("property") ? AccessType.PROPERTY : AccessType.FIELD;
                } else {
                    throw new AssertionFailure("Unable to guess collection property accessor name");
                }
                if (AnnotatedClassType.EMBEDDABLE.equals((Object)annotatedClassType)) {
                    object3 = new EntityBinder();
                    object2 = this.isHibernateExtensionMapping() ? new PropertyPreloadedData(AccessType.PROPERTY, "index", (XClass)ejb3JoinColumnArray2) : new PropertyPreloadedData(AccessType.PROPERTY, "key", (XClass)ejb3JoinColumnArray2);
                    object = AnnotationBinder.fillComponent(propertyHolder, (PropertyData)object2, accessType, true, (EntityBinder)object3, false, false, true, mappings, this.inheritanceStatePerClass);
                    map3.setIndex((Value)object);
                } else {
                    object3 = new SimpleValueBinder();
                    ((SimpleValueBinder)object3).setMappings(mappings);
                    ((SimpleValueBinder)object3).setReturnedClassName(string3);
                    object2 = ejb3ColumnArray;
                    if (object2 == null || ((Ejb3Column[])object2).length == 0) {
                        object2 = new Ejb3Column[1];
                        object = new Ejb3Column();
                        ((Ejb3Column)object).setImplicit(false);
                        ((Ejb3Column)object).setNullable(true);
                        ((Ejb3Column)object).setLength(255);
                        ((Ejb3Column)object).setLogicalColumnName("id");
                        ((Ejb3Column)object).setJoins(new HashMap<String, Join>());
                        ((Ejb3Column)object).setMappings(mappings);
                        ((Ejb3Column)object).bind();
                        object2[0] = object;
                    }
                    for (Ejb3Column ejb3Column : object2) {
                        ejb3Column.setTable(map3.getCollectionTable());
                    }
                    ((SimpleValueBinder)object3).setColumns((Ejb3Column[])object2);
                    ((SimpleValueBinder)object3).setKey(true);
                    object = xProperty.getAnnotation(MapKeyType.class);
                    if (object != null && !BinderHelper.isEmptyAnnotationValue(object.value().type())) {
                        ((SimpleValueBinder)object3).setExplicitType(object.value());
                    } else {
                        ((SimpleValueBinder)object3).setType(xProperty, (XClass)ejb3JoinColumnArray2, this.collection.getOwnerEntityName());
                    }
                    ((SimpleValueBinder)object3).setPersistentClassName(this.propertyHolder.getEntityName());
                    ((SimpleValueBinder)object3).setAccessType(accessType);
                    map3.setIndex(((SimpleValueBinder)object3).make());
                }
            }
            if (!this.collection.isOneToMany()) {
                for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
                    ejb3JoinColumn.forceNotNull();
                }
            }
            if (bl2) {
                MapBinder.bindManytoManyInverseFk(persistentClass, ejb3JoinColumnArray, manyToOne, false, mappings);
            }
        }
    }

    protected Value createFormulatedValue(Value value, Collection collection, String string, PersistentClass persistentClass, Mappings mappings) {
        Object object;
        Selectable selectable;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        Object object5;
        Value value2 = collection.getElement();
        String string2 = null;
        if (!(value2 instanceof OneToMany)) {
            object5 = null;
            if (value2 instanceof ToOne) {
                object5 = ((ToOne)value2).getReferencedPropertyName();
            } else if (value2 instanceof DependantValue) {
                if (this.propertyName != null) {
                    object5 = collection.getReferencedPropertyName();
                } else {
                    throw new AnnotationException("SecondaryTable JoinColumn cannot reference a non primary key");
                }
            }
            if (object5 == null) {
                object4 = persistentClass.getIdentifier().getColumnIterator();
            } else {
                object3 = persistentClass.getRecursiveProperty((String)object5);
                object4 = ((Property)object3).getColumnIterator();
            }
            object3 = "$alias$";
            serializable = new StringBuilder(" from ").append(persistentClass.getTable().getName()).append(" ").append((String)object3).append(" where ");
            object2 = value2.getColumnIterator();
            while (object2.hasNext()) {
                selectable = (Column)object2.next();
                object = (Column)object4.next();
                ((StringBuilder)serializable).append((String)object3).append('.').append(((Column)object).getQuotedName()).append('=').append(((Column)selectable).getQuotedName()).append(" and ");
            }
            string2 = ((StringBuilder)serializable).substring(0, ((StringBuilder)serializable).length() - 5);
        }
        if (value instanceof Component) {
            object5 = (Component)value;
            object4 = ((Component)object5).getPropertyIterator();
            object3 = new Component(mappings, collection);
            ((Component)object3).setComponentClassName(((Component)object5).getComponentClassName());
            ((Component)object3).setNodeName("index");
            while (object4.hasNext()) {
                serializable = (Property)object4.next();
                object2 = new Property();
                ((Property)object2).setCascade(((Property)serializable).getCascade());
                ((Property)object2).setGeneration(((Property)serializable).getGeneration());
                ((Property)object2).setInsertable(false);
                ((Property)object2).setUpdateable(false);
                ((Property)object2).setMetaAttributes(((Property)serializable).getMetaAttributes());
                ((Property)object2).setName(((Property)serializable).getName());
                ((Property)object2).setNodeName(((Property)serializable).getNodeName());
                ((Property)object2).setNaturalIdentifier(false);
                ((Property)object2).setOptional(false);
                ((Property)object2).setPersistentClass(((Property)serializable).getPersistentClass());
                ((Property)object2).setPropertyAccessorName(((Property)serializable).getPropertyAccessorName());
                ((Property)object2).setSelectable(((Property)serializable).isSelectable());
                ((Property)object2).setValue(this.createFormulatedValue(((Property)serializable).getValue(), collection, string, persistentClass, mappings));
                ((Component)object3).addProperty((Property)object2);
            }
            return object3;
        }
        if (value instanceof SimpleValue) {
            object5 = (SimpleValue)value;
            if (value instanceof ManyToOne) {
                object3 = (ManyToOne)object5;
                serializable = new ManyToOne(mappings, collection.getCollectionTable());
                ((ToOne)serializable).setFetchMode(FetchMode.DEFAULT);
                ((ToOne)serializable).setLazy(true);
                ((ToOne)serializable).setReferencedEntityName(((ToOne)object3).getReferencedEntityName());
                object4 = serializable;
            } else {
                object4 = new SimpleValue(mappings, collection.getCollectionTable());
                ((SimpleValue)object4).setTypeName(((SimpleValue)object5).getTypeName());
                ((SimpleValue)object4).setTypeParameters(((SimpleValue)object5).getTypeParameters());
            }
            object3 = ((SimpleValue)object5).getColumnIterator();
            serializable = new Random();
            while (object3.hasNext()) {
                object2 = object3.next();
                selectable = new Formula();
                if (object2 instanceof Column) {
                    object = ((Column)object2).getQuotedName();
                } else if (object2 instanceof Formula) {
                    object = ((Formula)object2).getFormula();
                } else {
                    throw new AssertionFailure("Unknown element in column iterator: " + object2.getClass());
                }
                if (string2 != null) {
                    object = Template.renderWhereStringTemplate((String)object, "$alias$", new HSQLDialect());
                    object = "(select " + (String)object + string2 + ")";
                    object = StringHelper.replace((String)object, "$alias$", "a" + ((Random)serializable).nextInt(16));
                }
                ((Formula)selectable).setFormula((String)object);
                ((SimpleValue)object4).addFormula((Formula)selectable);
            }
            return object4;
        }
        throw new AssertionFailure("Unknown type encounters for map key: " + value.getClass());
    }
}

