/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.OrderBy;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.CollectionBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.List;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.jboss.logging.Logger;

public class ListBinder
extends CollectionBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, ListBinder.class.getName());

    protected Collection createCollection(PersistentClass persistentClass) {
        return new List(this.getMappings(), persistentClass);
    }

    public void setSqlOrderBy(OrderBy orderBy) {
        if (orderBy != null) {
            LOG.orderByAnnotationIndexedCollection();
        }
    }

    public void setSort(Sort sort) {
        if (sort != null) {
            LOG.sortAnnotationIndexedCollection();
        }
    }

    public SecondPass getSecondPass(final Ejb3JoinColumn[] ejb3JoinColumnArray, final Ejb3JoinColumn[] ejb3JoinColumnArray2, final Ejb3JoinColumn[] ejb3JoinColumnArray3, final Ejb3Column[] ejb3ColumnArray, Ejb3Column[] ejb3ColumnArray2, Ejb3JoinColumn[] ejb3JoinColumnArray4, final boolean bl, final XProperty xProperty, final XClass xClass, final boolean bl2, final boolean bl3, final TableBinder tableBinder, final Mappings mappings) {
        return new CollectionSecondPass(mappings, this.collection){

            public void secondPass(Map map, Map map2) throws MappingException {
                ListBinder.this.bindStarToManySecondPass(map, xClass, ejb3JoinColumnArray, ejb3JoinColumnArray2, ejb3JoinColumnArray3, ejb3ColumnArray, bl, xProperty, bl3, tableBinder, bl2, mappings);
                ListBinder.this.bindIndex(mappings);
            }
        };
    }

    private void bindIndex(Mappings mappings) {
        if (!this.indexColumn.isImplicit()) {
            PropertyHolder propertyHolder = PropertyHolderBuilder.buildPropertyHolder(this.collection, StringHelper.qualify(this.collection.getRole(), "key"), null, null, this.propertyHolder, mappings);
            List list = (List)this.collection;
            if (!list.isOneToMany()) {
                this.indexColumn.forceNotNull();
            }
            this.indexColumn.setPropertyHolder(propertyHolder);
            SimpleValueBinder simpleValueBinder = new SimpleValueBinder();
            simpleValueBinder.setColumns(new Ejb3Column[]{this.indexColumn});
            simpleValueBinder.setExplicitType("integer");
            simpleValueBinder.setMappings(mappings);
            SimpleValue simpleValue = simpleValueBinder.make();
            this.indexColumn.linkWithValue(simpleValue);
            list.setIndex(simpleValue);
            list.setBaseIndex(this.indexColumn.getBase());
            if (list.isOneToMany() && !list.getKey().isNullable() && !list.isInverse()) {
                String string = ((OneToMany)list.getElement()).getReferencedEntityName();
                PersistentClass persistentClass = mappings.getClass(string);
                IndexBackref indexBackref = new IndexBackref();
                indexBackref.setName('_' + this.propertyName + "IndexBackref");
                indexBackref.setUpdateable(false);
                indexBackref.setSelectable(false);
                indexBackref.setCollectionRole(list.getRole());
                indexBackref.setEntityName(list.getOwner().getEntityName());
                indexBackref.setValue(list.getIndex());
                persistentClass.addProperty(indexBackref);
            }
        } else {
            Collection collection = this.collection;
            throw new AnnotationException("List/array has to be annotated with an @OrderColumn (or @IndexColumn): " + collection.getRole());
        }
    }
}

