/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Loader;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.OptimisticLocking;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Polymorphism;
import org.hibernate.annotations.PolymorphismType;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.RowId;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLUpdate;
import org.hibernate.annotations.SelectBeforeUpdate;
import org.hibernate.annotations.Subselect;
import org.hibernate.annotations.Synchronize;
import org.hibernate.annotations.Tables;
import org.hibernate.annotations.Tuplizer;
import org.hibernate.annotations.Tuplizers;
import org.hibernate.annotations.Where;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.cfg.ObjectNameSource;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.UniqueConstraintHolder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TableOwner;
import org.hibernate.mapping.Value;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, EntityBinder.class.getName());
    private static final String NATURAL_ID_CACHE_SUFFIX = "##NaturalId";
    private String name;
    private XClass annotatedClass;
    private PersistentClass persistentClass;
    private Mappings mappings;
    private String discriminatorValue = "";
    private Boolean forceDiscriminator;
    private Boolean insertableDiscriminator;
    private boolean dynamicInsert;
    private boolean dynamicUpdate;
    private boolean explicitHibernateEntityAnnotation;
    private OptimisticLockType optimisticLockType;
    private PolymorphismType polymorphismType;
    private boolean selectBeforeUpdate;
    private int batchSize;
    private boolean lazy;
    private XClass proxyClass;
    private String where;
    private Map<String, Join> secondaryTables = new HashMap<String, Join>();
    private Map<String, Object> secondaryTableJoins = new HashMap<String, Object>();
    private String cacheConcurrentStrategy;
    private String cacheRegion;
    private String naturalIdCacheRegion;
    private List<Filter> filters = new ArrayList<Filter>();
    private InheritanceState inheritanceState;
    private boolean ignoreIdAnnotations;
    private boolean cacheLazyProperty;
    private AccessType propertyAccessType = AccessType.DEFAULT;
    private boolean wrapIdsInEmbeddedComponents;
    private String subselect;
    private static SecondaryTableNamingStrategyHelper SEC_TBL_NS_HELPER = new SecondaryTableNamingStrategyHelper();

    public boolean wrapIdsInEmbeddedComponents() {
        return this.wrapIdsInEmbeddedComponents;
    }

    public EntityBinder() {
    }

    public EntityBinder(Entity entity, org.hibernate.annotations.Entity entity2, XClass xClass, PersistentClass persistentClass, Mappings mappings) {
        this.mappings = mappings;
        this.persistentClass = persistentClass;
        this.annotatedClass = xClass;
        this.bindEjb3Annotation(entity);
        this.bindHibernateAnnotation(entity2);
    }

    private void bindHibernateAnnotation(org.hibernate.annotations.Entity entity) {
        Annotation annotation = this.annotatedClass.getAnnotation(DynamicInsert.class);
        this.dynamicInsert = annotation == null ? (entity == null ? false : entity.dynamicInsert()) : annotation.value();
        annotation = this.annotatedClass.getAnnotation(DynamicUpdate.class);
        this.dynamicUpdate = annotation == null ? (entity == null ? false : entity.dynamicUpdate()) : annotation.value();
        annotation = this.annotatedClass.getAnnotation(SelectBeforeUpdate.class);
        this.selectBeforeUpdate = annotation == null ? (entity == null ? false : entity.selectBeforeUpdate()) : annotation.value();
        annotation = this.annotatedClass.getAnnotation(OptimisticLocking.class);
        this.optimisticLockType = annotation == null ? (entity == null ? OptimisticLockType.VERSION : entity.optimisticLock()) : annotation.type();
        annotation = this.annotatedClass.getAnnotation(Polymorphism.class);
        PolymorphismType polymorphismType = annotation == null ? (entity == null ? PolymorphismType.IMPLICIT : entity.polymorphism()) : (this.polymorphismType = annotation.type());
        if (entity != null) {
            this.explicitHibernateEntityAnnotation = true;
        }
    }

    private void bindEjb3Annotation(Entity entity) {
        if (entity == null) {
            throw new AssertionFailure("@Entity should always be not null");
        }
        this.name = BinderHelper.isEmptyAnnotationValue(entity.name()) ? StringHelper.unqualify(this.annotatedClass.getName()) : entity.name();
    }

    public boolean isRootEntity() {
        return this.persistentClass instanceof RootClass;
    }

    public void setDiscriminatorValue(String string) {
        this.discriminatorValue = string;
    }

    public void setForceDiscriminator(boolean bl) {
        this.forceDiscriminator = bl;
    }

    public void setInsertableDiscriminator(boolean bl) {
        this.insertableDiscriminator = bl;
    }

    /*
     * WARNING - void declaration
     */
    public void bindEntity() {
        Object object2;
        Object object3;
        this.persistentClass.setAbstract(this.annotatedClass.isAbstract());
        this.persistentClass.setClassName(this.annotatedClass.getName());
        this.persistentClass.setNodeName(this.name);
        this.persistentClass.setJpaEntityName(this.name);
        this.persistentClass.setEntityName(this.annotatedClass.getName());
        this.bindDiscriminatorValue();
        this.persistentClass.setLazy(this.lazy);
        if (this.proxyClass != null) {
            this.persistentClass.setProxyInterfaceName(this.proxyClass.getName());
        }
        this.persistentClass.setDynamicInsert(this.dynamicInsert);
        this.persistentClass.setDynamicUpdate(this.dynamicUpdate);
        if (this.persistentClass instanceof RootClass) {
            object3 = (RootClass)this.persistentClass;
            boolean bl = true;
            if (this.annotatedClass.isAnnotationPresent(Immutable.class)) {
                bl = false;
            } else {
                org.hibernate.annotations.Entity entity = this.annotatedClass.getAnnotation(org.hibernate.annotations.Entity.class);
                if (entity != null) {
                    bl = entity.mutable();
                }
            }
            ((RootClass)object3).setMutable(bl);
            ((RootClass)object3).setExplicitPolymorphism(this.isExplicitPolymorphism(this.polymorphismType));
            if (StringHelper.isNotEmpty(this.where)) {
                ((RootClass)object3).setWhere(this.where);
            }
            if (this.cacheConcurrentStrategy != null) {
                ((RootClass)object3).setCacheConcurrencyStrategy(this.cacheConcurrentStrategy);
                ((RootClass)object3).setCacheRegionName(this.cacheRegion);
                ((RootClass)object3).setLazyPropertiesCacheable(this.cacheLazyProperty);
            }
            ((RootClass)object3).setNaturalIdCacheRegionName(this.naturalIdCacheRegion);
            boolean bl2 = this.forceDiscriminator == null ? this.mappings.forceDiscriminatorInSelectsByDefault() : this.forceDiscriminator.booleanValue();
            ((RootClass)object3).setForceDiscriminator(bl2);
            if (this.insertableDiscriminator != null) {
                ((RootClass)object3).setDiscriminatorInsertable(this.insertableDiscriminator);
            }
        } else {
            if (this.explicitHibernateEntityAnnotation) {
                LOG.entityAnnotationOnNonRoot(this.annotatedClass.getName());
            }
            if (this.annotatedClass.isAnnotationPresent(Immutable.class)) {
                LOG.immutableAnnotationOnNonRoot(this.annotatedClass.getName());
            }
        }
        this.persistentClass.setOptimisticLockMode(this.getVersioning(this.optimisticLockType));
        this.persistentClass.setSelectBeforeUpdate(this.selectBeforeUpdate);
        object3 = this.annotatedClass.getAnnotation(Persister.class);
        Class clazz = null;
        if (object3 != null) {
            clazz = object3.impl();
        } else {
            org.hibernate.annotations.Entity entity = this.annotatedClass.getAnnotation(org.hibernate.annotations.Entity.class);
            if (entity != null && !BinderHelper.isEmptyAnnotationValue(entity.persister())) {
                try {
                    clazz = ReflectHelper.classForName(entity.persister());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AnnotationException("Could not find persister class: " + clazz);
                }
            }
        }
        if (clazz != null) {
            this.persistentClass.setEntityPersisterClass(clazz);
        }
        this.persistentClass.setBatchSize(this.batchSize);
        SQLInsert sQLInsert = this.annotatedClass.getAnnotation(SQLInsert.class);
        SQLUpdate sQLUpdate = this.annotatedClass.getAnnotation(SQLUpdate.class);
        SQLDelete sQLDelete = this.annotatedClass.getAnnotation(SQLDelete.class);
        SQLDeleteAll sQLDeleteAll = this.annotatedClass.getAnnotation(SQLDeleteAll.class);
        Loader loader = this.annotatedClass.getAnnotation(Loader.class);
        if (sQLInsert != null) {
            this.persistentClass.setCustomSQLInsert(sQLInsert.sql().trim(), sQLInsert.callable(), ExecuteUpdateResultCheckStyle.fromExternalName(sQLInsert.check().toString().toLowerCase()));
        }
        if (sQLUpdate != null) {
            this.persistentClass.setCustomSQLUpdate(sQLUpdate.sql(), sQLUpdate.callable(), ExecuteUpdateResultCheckStyle.fromExternalName(sQLUpdate.check().toString().toLowerCase()));
        }
        if (sQLDelete != null) {
            this.persistentClass.setCustomSQLDelete(sQLDelete.sql(), sQLDelete.callable(), ExecuteUpdateResultCheckStyle.fromExternalName(sQLDelete.check().toString().toLowerCase()));
        }
        if (sQLDeleteAll != null) {
            this.persistentClass.setCustomSQLDelete(sQLDeleteAll.sql(), sQLDeleteAll.callable(), ExecuteUpdateResultCheckStyle.fromExternalName(sQLDeleteAll.check().toString().toLowerCase()));
        }
        if (loader != null) {
            this.persistentClass.setLoaderName(loader.namedQuery());
        }
        if (this.annotatedClass.isAnnotationPresent(Synchronize.class)) {
            String[] object4;
            object2 = this.annotatedClass.getAnnotation(Synchronize.class);
            for (String string : object4 = object2.value()) {
                this.persistentClass.addSynchronizedTable(string);
            }
        }
        if (this.annotatedClass.isAnnotationPresent(Subselect.class)) {
            object2 = this.annotatedClass.getAnnotation(Subselect.class);
            this.subselect = object2.value();
        }
        if (this.annotatedClass.isAnnotationPresent(Tuplizers.class)) {
            void var10_23;
            object2 = this.annotatedClass.getAnnotation(Tuplizers.class).value();
            int n = ((Annotation)object2).length;
            boolean bl = false;
            while (var10_23 < n) {
                Object object = object2[var10_23];
                EntityMode entityMode = EntityMode.parse(object.entityMode());
                this.persistentClass.addTuplizer(entityMode, object.impl().getName());
                ++var10_23;
            }
        }
        if (this.annotatedClass.isAnnotationPresent(Tuplizer.class)) {
            object2 = this.annotatedClass.getAnnotation(Tuplizer.class);
            EntityMode entityMode = EntityMode.parse(object2.entityMode());
            this.persistentClass.addTuplizer(entityMode, object2.impl().getName());
        }
        for (Filter filter : this.filters) {
            String string = filter.name();
            String string2 = filter.condition();
            if (BinderHelper.isEmptyAnnotationValue(string2)) {
                FilterDefinition filterDefinition = this.mappings.getFilterDefinition(string);
                String string3 = string2 = filterDefinition == null ? null : filterDefinition.getDefaultFilterCondition();
                if (StringHelper.isEmpty(string2)) {
                    throw new AnnotationException("no filter condition found for filter " + string + " in " + this.name);
                }
            }
            this.persistentClass.addFilter(string, string2, filter.deduceAliasInjectionPoints(), BinderHelper.toAliasTableMap(filter.aliases()), BinderHelper.toAliasEntityMap(filter.aliases()));
        }
        LOG.debugf("Import with entity name %s", (Object)this.name);
        try {
            this.mappings.addImport(this.persistentClass.getEntityName(), this.name);
            object2 = this.persistentClass.getEntityName();
            if (!((String)object2).equals(this.name)) {
                this.mappings.addImport((String)object2, (String)object2);
            }
        }
        catch (MappingException mappingException) {
            throw new AnnotationException("Use of the same entity name twice: " + this.name, mappingException);
        }
    }

    public void bindDiscriminatorValue() {
        if (StringHelper.isEmpty(this.discriminatorValue)) {
            Value value = this.persistentClass.getDiscriminator();
            if (value == null) {
                this.persistentClass.setDiscriminatorValue(this.name);
            } else {
                if ("character".equals(value.getType().getName())) {
                    throw new AnnotationException("Using default @DiscriminatorValue for a discriminator of type CHAR is not safe");
                }
                if ("integer".equals(value.getType().getName())) {
                    this.persistentClass.setDiscriminatorValue(String.valueOf(this.name.hashCode()));
                } else {
                    this.persistentClass.setDiscriminatorValue(this.name);
                }
            }
        } else {
            this.persistentClass.setDiscriminatorValue(this.discriminatorValue);
        }
    }

    int getVersioning(OptimisticLockType optimisticLockType) {
        switch (optimisticLockType) {
            case VERSION: {
                return 0;
            }
            case NONE: {
                return -1;
            }
            case DIRTY: {
                return 1;
            }
            case ALL: {
                return 2;
            }
        }
        throw new AssertionFailure("optimistic locking not supported: " + (Object)((Object)optimisticLockType));
    }

    private boolean isExplicitPolymorphism(PolymorphismType polymorphismType) {
        switch (polymorphismType) {
            case IMPLICIT: {
                return false;
            }
            case EXPLICIT: {
                return true;
            }
        }
        throw new AssertionFailure("Unknown polymorphism type: " + (Object)((Object)polymorphismType));
    }

    public void setBatchSize(BatchSize batchSize) {
        this.batchSize = batchSize != null ? batchSize.size() : -1;
    }

    public void setProxy(Proxy proxy) {
        if (proxy != null) {
            this.lazy = proxy.lazy();
            this.proxyClass = !this.lazy ? null : (AnnotationBinder.isDefault(this.mappings.getReflectionManager().toXClass(proxy.proxyClass()), this.mappings) ? this.annotatedClass : this.mappings.getReflectionManager().toXClass(proxy.proxyClass()));
        } else {
            this.lazy = true;
            this.proxyClass = this.annotatedClass;
        }
    }

    public void setWhere(Where where) {
        if (where != null) {
            this.where = where.clause();
        }
    }

    public void setWrapIdsInEmbeddedComponents(boolean bl) {
        this.wrapIdsInEmbeddedComponents = bl;
    }

    public void bindTable(String string, String string2, String string3, List<UniqueConstraintHolder> list, String string4, Table table) {
        EntityTableObjectNameSource entityTableObjectNameSource = new EntityTableObjectNameSource(string3, this.name);
        EntityTableNamingStrategyHelper entityTableNamingStrategyHelper = new EntityTableNamingStrategyHelper(this.name);
        Table table2 = TableBinder.buildAndFillTable(string, string2, entityTableObjectNameSource, entityTableNamingStrategyHelper, this.persistentClass.isAbstract(), list, string4, table, this.mappings, this.subselect);
        RowId rowId = this.annotatedClass.getAnnotation(RowId.class);
        if (rowId != null) {
            table2.setRowId(rowId.value());
        }
        if (!(this.persistentClass instanceof TableOwner)) {
            throw new AssertionFailure("binding a table for a subclass");
        }
        LOG.debugf("Bind entity %s on table %s", (Object)this.persistentClass.getEntityName(), (Object)table2.getName());
        ((TableOwner)((Object)this.persistentClass)).setTable(table2);
    }

    public void finalSecondaryTableBinding(PropertyHolder propertyHolder) {
        Iterator<Join> iterator = this.secondaryTables.values().iterator();
        Iterator<Object> iterator2 = this.secondaryTableJoins.values().iterator();
        while (iterator.hasNext()) {
            Object object = iterator2.next();
            Join join = iterator.next();
            this.createPrimaryColumnsToSecondaryTable(object, propertyHolder, join);
        }
        this.mappings.addJoins(this.persistentClass, this.secondaryTables);
    }

    private void createPrimaryColumnsToSecondaryTable(Object object, PropertyHolder propertyHolder, Join join) {
        Ejb3JoinColumn[] ejb3JoinColumnArray;
        PrimaryKeyJoinColumn[] primaryKeyJoinColumnArray = null;
        JoinColumn[] joinColumnArray = null;
        if (object instanceof PrimaryKeyJoinColumn[]) {
            primaryKeyJoinColumnArray = (PrimaryKeyJoinColumn[])object;
        }
        if (object instanceof JoinColumn[]) {
            joinColumnArray = (JoinColumn[])object;
        }
        if (primaryKeyJoinColumnArray == null && joinColumnArray == null) {
            ejb3JoinColumnArray = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn(null, null, this.persistentClass.getIdentifier(), this.secondaryTables, propertyHolder, this.mappings)};
        } else {
            int n;
            int n2 = n = primaryKeyJoinColumnArray != null ? primaryKeyJoinColumnArray.length : joinColumnArray.length;
            if (n == 0) {
                ejb3JoinColumnArray = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn(null, null, this.persistentClass.getIdentifier(), this.secondaryTables, propertyHolder, this.mappings)};
            } else {
                int n3;
                ejb3JoinColumnArray = new Ejb3JoinColumn[n];
                if (primaryKeyJoinColumnArray != null) {
                    for (n3 = 0; n3 < n; ++n3) {
                        ejb3JoinColumnArray[n3] = Ejb3JoinColumn.buildJoinColumn(primaryKeyJoinColumnArray[n3], null, this.persistentClass.getIdentifier(), this.secondaryTables, propertyHolder, this.mappings);
                    }
                } else {
                    for (n3 = 0; n3 < n; ++n3) {
                        ejb3JoinColumnArray[n3] = Ejb3JoinColumn.buildJoinColumn(null, joinColumnArray[n3], this.persistentClass.getIdentifier(), this.secondaryTables, propertyHolder, this.mappings);
                    }
                }
            }
        }
        for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
            ejb3JoinColumn.forceNotNull();
        }
        this.bindJoinToPersistentClass(join, ejb3JoinColumnArray, this.mappings);
    }

    private void bindJoinToPersistentClass(Join join, Ejb3JoinColumn[] ejb3JoinColumnArray, Mappings mappings) {
        DependantValue dependantValue = new DependantValue(mappings, join.getTable(), this.persistentClass.getIdentifier());
        join.setKey(dependantValue);
        this.setFKNameIfDefined(join);
        dependantValue.setCascadeDeleteEnabled(false);
        TableBinder.bindFk(this.persistentClass, null, ejb3JoinColumnArray, dependantValue, false, mappings);
        join.createPrimaryKey();
        join.createForeignKey();
        this.persistentClass.addJoin(join);
    }

    private void setFKNameIfDefined(Join join) {
        org.hibernate.annotations.Table table = this.findMatchingComplimentTableAnnotation(join);
        if (table != null && !BinderHelper.isEmptyAnnotationValue(table.foreignKey().name())) {
            ((SimpleValue)join.getKey()).setForeignKeyName(table.foreignKey().name());
        }
    }

    private org.hibernate.annotations.Table findMatchingComplimentTableAnnotation(Join join) {
        String string = join.getTable().getQuotedName();
        org.hibernate.annotations.Table table = this.annotatedClass.getAnnotation(org.hibernate.annotations.Table.class);
        org.hibernate.annotations.Table table2 = null;
        if (table != null && string.equals(table.appliesTo())) {
            table2 = table;
        } else {
            Tables tables = this.annotatedClass.getAnnotation(Tables.class);
            if (tables != null) {
                for (org.hibernate.annotations.Table table3 : tables.value()) {
                    if (!string.equals(table3.appliesTo())) continue;
                    table2 = table3;
                    break;
                }
            }
        }
        return table2;
    }

    public void firstLevelSecondaryTablesBinding(SecondaryTable secondaryTable, SecondaryTables secondaryTables) {
        if (secondaryTables != null) {
            for (SecondaryTable secondaryTable2 : secondaryTables.value()) {
                this.addJoin(secondaryTable2, null, null, false);
            }
        } else if (secondaryTable != null) {
            this.addJoin(secondaryTable, null, null, false);
        }
    }

    public Join addJoin(JoinTable joinTable, PropertyHolder propertyHolder, boolean bl) {
        return this.addJoin(null, joinTable, propertyHolder, bl);
    }

    private Join addJoin(SecondaryTable secondaryTable, JoinTable joinTable, PropertyHolder propertyHolder, boolean bl) {
        List<UniqueConstraintHolder> list;
        Annotation[] annotationArray;
        SecondaryTableNameSource secondaryTableNameSource;
        String string;
        String string2;
        Join join = new Join();
        join.setPersistentClass(this.persistentClass);
        if (secondaryTable != null) {
            string2 = secondaryTable.schema();
            string = secondaryTable.catalog();
            secondaryTableNameSource = new SecondaryTableNameSource(secondaryTable.name());
            annotationArray = secondaryTable.pkJoinColumns();
            list = TableBinder.buildUniqueConstraintHolders(secondaryTable.uniqueConstraints());
        } else if (joinTable != null) {
            string2 = joinTable.schema();
            string = joinTable.catalog();
            secondaryTableNameSource = new SecondaryTableNameSource(joinTable.name());
            annotationArray = joinTable.joinColumns();
            list = TableBinder.buildUniqueConstraintHolders(joinTable.uniqueConstraints());
        } else {
            throw new AssertionFailure("Both JoinTable and SecondaryTable are null");
        }
        Table table = TableBinder.buildAndFillTable(string2, string, secondaryTableNameSource, SEC_TBL_NS_HELPER, false, list, null, null, this.mappings, null);
        join.setTable(table);
        LOG.debugf("Adding secondary table to entity %s -> %s", (Object)this.persistentClass.getEntityName(), (Object)join.getTable().getName());
        org.hibernate.annotations.Table table2 = this.findMatchingComplimentTableAnnotation(join);
        if (table2 != null) {
            join.setSequentialSelect(FetchMode.JOIN != table2.fetch());
            join.setInverse(table2.inverse());
            join.setOptional(table2.optional());
            if (!BinderHelper.isEmptyAnnotationValue(table2.sqlInsert().sql())) {
                join.setCustomSQLInsert(table2.sqlInsert().sql().trim(), table2.sqlInsert().callable(), ExecuteUpdateResultCheckStyle.fromExternalName(table2.sqlInsert().check().toString().toLowerCase()));
            }
            if (!BinderHelper.isEmptyAnnotationValue(table2.sqlUpdate().sql())) {
                join.setCustomSQLUpdate(table2.sqlUpdate().sql().trim(), table2.sqlUpdate().callable(), ExecuteUpdateResultCheckStyle.fromExternalName(table2.sqlUpdate().check().toString().toLowerCase()));
            }
            if (!BinderHelper.isEmptyAnnotationValue(table2.sqlDelete().sql())) {
                join.setCustomSQLDelete(table2.sqlDelete().sql().trim(), table2.sqlDelete().callable(), ExecuteUpdateResultCheckStyle.fromExternalName(table2.sqlDelete().check().toString().toLowerCase()));
            }
        } else {
            join.setSequentialSelect(false);
            join.setInverse(false);
            join.setOptional(true);
        }
        if (bl) {
            this.createPrimaryColumnsToSecondaryTable(annotationArray, propertyHolder, join);
        } else {
            this.secondaryTables.put(table.getQuotedName(), join);
            this.secondaryTableJoins.put(table.getQuotedName(), annotationArray);
        }
        return join;
    }

    public Map<String, Join> getSecondaryTables() {
        return this.secondaryTables;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCache(Cache cache) {
        if (cache != null) {
            this.cacheRegion = BinderHelper.isEmptyAnnotationValue(cache.region()) ? null : cache.region();
            this.cacheConcurrentStrategy = EntityBinder.getCacheConcurrencyStrategy(cache.usage());
            if ("all".equalsIgnoreCase(cache.include())) {
                this.cacheLazyProperty = true;
                return;
            } else {
                if (!"non-lazy".equalsIgnoreCase(cache.include())) throw new AnnotationException("Unknown lazy property annotations: " + cache.include());
                this.cacheLazyProperty = false;
            }
            return;
        } else {
            this.cacheConcurrentStrategy = null;
            this.cacheRegion = null;
            this.cacheLazyProperty = true;
        }
    }

    public void setNaturalIdCache(XClass xClass, NaturalIdCache naturalIdCache) {
        this.naturalIdCacheRegion = naturalIdCache != null ? (BinderHelper.isEmptyAnnotationValue(naturalIdCache.region()) ? (this.cacheRegion != null ? this.cacheRegion + NATURAL_ID_CACHE_SUFFIX : xClass.getName() + NATURAL_ID_CACHE_SUFFIX) : naturalIdCache.region()) : null;
    }

    public static String getCacheConcurrencyStrategy(CacheConcurrencyStrategy cacheConcurrencyStrategy) {
        org.hibernate.cache.spi.access.AccessType accessType = cacheConcurrencyStrategy.toAccessType();
        return accessType == null ? null : accessType.getExternalName();
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void setInheritanceState(InheritanceState inheritanceState) {
        this.inheritanceState = inheritanceState;
    }

    public boolean isIgnoreIdAnnotations() {
        return this.ignoreIdAnnotations;
    }

    public void setIgnoreIdAnnotations(boolean bl) {
        this.ignoreIdAnnotations = bl;
    }

    public void processComplementaryTableDefinitions(org.hibernate.annotations.Table table) {
        if (table == null) {
            return;
        }
        String string = table.appliesTo();
        Iterator iterator = this.persistentClass.getTableClosureIterator();
        Table table2 = null;
        while (iterator.hasNext()) {
            Table table3 = (Table)iterator.next();
            if (table3.getQuotedName().equals(string)) {
                table2 = table3;
                break;
            }
            table2 = null;
        }
        if (table2 == null) {
            for (Join join : this.secondaryTables.values()) {
                if (!join.getTable().getQuotedName().equals(string)) continue;
                table2 = join.getTable();
                break;
            }
        }
        if (table2 == null) {
            throw new AnnotationException("@org.hibernate.annotations.Table references an unknown table: " + string);
        }
        if (!BinderHelper.isEmptyAnnotationValue(table.comment())) {
            table2.setComment(table.comment());
        }
        TableBinder.addIndexes(table2, table.indexes(), this.mappings);
    }

    public void processComplementaryTableDefinitions(Tables tables) {
        if (tables == null) {
            return;
        }
        for (org.hibernate.annotations.Table table : tables.value()) {
            this.processComplementaryTableDefinitions(table);
        }
    }

    public AccessType getPropertyAccessType() {
        return this.propertyAccessType;
    }

    public void setPropertyAccessType(AccessType accessType) {
        this.propertyAccessType = this.getExplicitAccessType(this.annotatedClass);
        if (this.propertyAccessType == null) {
            this.propertyAccessType = accessType;
        }
    }

    public AccessType getPropertyAccessor(XAnnotatedElement xAnnotatedElement) {
        AccessType accessType = this.getExplicitAccessType(xAnnotatedElement);
        if (accessType == null) {
            accessType = this.propertyAccessType;
        }
        return accessType;
    }

    public AccessType getExplicitAccessType(XAnnotatedElement xAnnotatedElement) {
        Access access;
        AccessType accessType = null;
        AccessType accessType2 = null;
        AccessType accessType3 = null;
        org.hibernate.annotations.AccessType accessType4 = xAnnotatedElement.getAnnotation(org.hibernate.annotations.AccessType.class);
        if (accessType4 != null) {
            accessType2 = AccessType.getAccessStrategy(accessType4.value());
        }
        if ((access = xAnnotatedElement.getAnnotation(Access.class)) != null) {
            accessType3 = AccessType.getAccessStrategy(access.value());
        }
        if (accessType2 != null && accessType3 != null && accessType2 != accessType3) {
            throw new MappingException("Found @Access and @AccessType with conflicting values on a property in class " + this.annotatedClass.toString());
        }
        if (accessType2 != null) {
            accessType = accessType2;
        } else if (accessType3 != null) {
            accessType = accessType3;
        }
        return accessType;
    }

    private static class SecondaryTableNamingStrategyHelper
    implements ObjectNameNormalizer.NamingStrategyHelper {
        private SecondaryTableNamingStrategyHelper() {
        }

        public String determineImplicitName(NamingStrategy namingStrategy) {
            return null;
        }

        public String handleExplicitName(NamingStrategy namingStrategy, String string) {
            return namingStrategy.tableName(string);
        }
    }

    private static class SecondaryTableNameSource
    implements ObjectNameSource {
        private final String explicitName;

        private SecondaryTableNameSource(String string) {
            this.explicitName = string;
        }

        public String getExplicitName() {
            return this.explicitName;
        }

        public String getLogicalName() {
            return this.explicitName;
        }
    }

    private static class EntityTableNamingStrategyHelper
    implements ObjectNameNormalizer.NamingStrategyHelper {
        private final String entityName;

        private EntityTableNamingStrategyHelper(String string) {
            this.entityName = string;
        }

        public String determineImplicitName(NamingStrategy namingStrategy) {
            return namingStrategy.classToTableName(this.entityName);
        }

        public String handleExplicitName(NamingStrategy namingStrategy, String string) {
            return namingStrategy.tableName(string);
        }
    }

    private static class EntityTableObjectNameSource
    implements ObjectNameSource {
        private final String explicitName;
        private final String logicalName;

        private EntityTableObjectNameSource(String string, String string2) {
            this.explicitName = string;
            this.logicalName = StringHelper.isNotEmpty(string) ? string : StringHelper.unqualify(string2);
        }

        public String getExplicitName() {
            return this.explicitName;
        }

        public String getLogicalName() {
            return this.logicalName;
        }
    }
}

