/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.NullPrecedence;
import org.hibernate.cache.internal.NoCachingRegionFactory;
import org.hibernate.cache.internal.RegionFactoryInitiator;
import org.hibernate.cache.internal.StandardQueryCacheFactory;
import org.hibernate.cache.spi.QueryCacheFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.hql.spi.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.PersistentTableBulkIdStrategy;
import org.hibernate.hql.spi.QueryTranslatorFactory;
import org.hibernate.hql.spi.TemporaryTableBulkIdStrategy;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.loader.BatchFetchStyle;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.hibernate.tuple.entity.EntityTuplizerFactory;
import org.jboss.logging.Logger;

public class SettingsFactory
implements Serializable {
    private static final long serialVersionUID = -1194386144994524825L;
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SettingsFactory.class.getName());
    public static final String DEF_CACHE_REG_FACTORY = NoCachingRegionFactory.class.getName();

    public Settings buildSettings(Properties properties, ServiceRegistry serviceRegistry) {
        ConnectionReleaseMode connectionReleaseMode;
        boolean bl = LOG.isDebugEnabled();
        JdbcServices jdbcServices = serviceRegistry.getService(JdbcServices.class);
        Settings settings = new Settings();
        String string = properties.getProperty("hibernate.session_factory_name");
        settings.setSessionFactoryName(string);
        settings.setSessionFactoryNameAlsoJndiName(ConfigurationHelper.getBoolean("hibernate.session_factory_name_is_jndi", properties, true));
        ExtractedDatabaseMetaData extractedDatabaseMetaData = jdbcServices.getExtractedMetaDataSupport();
        settings.setDataDefinitionImplicitCommit(extractedDatabaseMetaData.doesDataDefinitionCauseTransactionCommit());
        settings.setDataDefinitionInTransactionSupported(extractedDatabaseMetaData.supportsDataDefinitionInTransaction());
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)jdbcServices.getDialect().getDefaultProperties());
        properties2.putAll((Map<?, ?>)properties);
        settings.setJtaPlatform(serviceRegistry.getService(JtaPlatform.class));
        MultiTableBulkIdStrategy multiTableBulkIdStrategy = this.getMultiTableBulkIdStrategy(properties2, jdbcServices.getDialect(), serviceRegistry.getService(ClassLoaderService.class));
        settings.setMultiTableBulkIdStrategy(multiTableBulkIdStrategy);
        boolean bl2 = ConfigurationHelper.getBoolean("hibernate.transaction.flush_before_completion", properties2);
        if (bl) {
            LOG.debugf("Automatic flush during beforeCompletion(): %s", (Object)SettingsFactory.enabledDisabled(bl2));
        }
        settings.setFlushBeforeCompletionEnabled(bl2);
        boolean bl3 = ConfigurationHelper.getBoolean("hibernate.transaction.auto_close_session", properties2);
        if (bl) {
            LOG.debugf("Automatic session close at end of transaction: %s", (Object)SettingsFactory.enabledDisabled(bl3));
        }
        settings.setAutoCloseSessionEnabled(bl3);
        int n = ConfigurationHelper.getInt("hibernate.jdbc.batch_size", properties2, 0);
        if (!extractedDatabaseMetaData.supportsBatchUpdates()) {
            n = 0;
        }
        if (n > 0 && bl) {
            LOG.debugf("JDBC batch size: %s", (Object)n);
        }
        settings.setJdbcBatchSize(n);
        boolean bl4 = ConfigurationHelper.getBoolean("hibernate.jdbc.batch_versioned_data", properties2, false);
        if (n > 0 && bl) {
            LOG.debugf("JDBC batch updates for versioned data: %s", (Object)SettingsFactory.enabledDisabled(bl4));
        }
        settings.setJdbcBatchVersionedData(bl4);
        boolean bl5 = ConfigurationHelper.getBoolean("hibernate.jdbc.use_scrollable_resultset", properties2, extractedDatabaseMetaData.supportsScrollableResults());
        if (bl) {
            LOG.debugf("Scrollable result sets: %s", (Object)SettingsFactory.enabledDisabled(bl5));
        }
        settings.setScrollableResultSetsEnabled(bl5);
        boolean bl6 = ConfigurationHelper.getBoolean("hibernate.jdbc.wrap_result_sets", properties2, false);
        if (bl) {
            LOG.debugf("Wrap result sets: %s", (Object)SettingsFactory.enabledDisabled(bl6));
        }
        settings.setWrapResultSetsEnabled(bl6);
        boolean bl7 = ConfigurationHelper.getBoolean("hibernate.jdbc.use_get_generated_keys", properties2, extractedDatabaseMetaData.supportsGetGeneratedKeys());
        if (bl) {
            LOG.debugf("JDBC3 getGeneratedKeys(): %s", (Object)SettingsFactory.enabledDisabled(bl7));
        }
        settings.setGetGeneratedKeysEnabled(bl7);
        Integer n2 = ConfigurationHelper.getInteger("hibernate.jdbc.fetch_size", properties2);
        if (n2 != null && bl) {
            LOG.debugf("JDBC result set fetch size: %s", (Object)n2);
        }
        settings.setJdbcFetchSize(n2);
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.determineMultiTenancyStrategy(properties2);
        if (bl) {
            LOG.debugf("multi-tenancy strategy : %s", (Object)multiTenancyStrategy);
        }
        settings.setMultiTenancyStrategy(multiTenancyStrategy);
        String string2 = ConfigurationHelper.getString("hibernate.connection.release_mode", properties2, "auto");
        if (bl) {
            LOG.debugf("Connection release mode: %s", (Object)string2);
        }
        if ("auto".equals(string2)) {
            connectionReleaseMode = serviceRegistry.getService(TransactionFactory.class).getDefaultReleaseMode();
        } else {
            connectionReleaseMode = ConnectionReleaseMode.parse(string2);
            if (connectionReleaseMode == ConnectionReleaseMode.AFTER_STATEMENT) {
                boolean bl8;
                boolean bl9 = bl8 = multiTenancyStrategy.requiresMultiTenantConnectionProvider() ? serviceRegistry.getService(MultiTenantConnectionProvider.class).supportsAggressiveRelease() : serviceRegistry.getService(ConnectionProvider.class).supportsAggressiveRelease();
                if (!bl8) {
                    LOG.unsupportedAfterStatement();
                    connectionReleaseMode = ConnectionReleaseMode.AFTER_TRANSACTION;
                }
            }
        }
        settings.setConnectionReleaseMode(connectionReleaseMode);
        BatchFetchStyle batchFetchStyle = BatchFetchStyle.interpret(properties2.get("hibernate.batch_fetch_style"));
        LOG.debugf("Using BatchFetchStyle : " + batchFetchStyle.name(), new Object[0]);
        settings.setBatchFetchStyle(batchFetchStyle);
        String string3 = properties2.getProperty("hibernate.default_schema");
        String string4 = properties2.getProperty("hibernate.default_catalog");
        if (string3 != null && bl) {
            LOG.debugf("Default schema: %s", (Object)string3);
        }
        if (string4 != null && bl) {
            LOG.debugf("Default catalog: %s", (Object)string4);
        }
        settings.setDefaultSchemaName(string3);
        settings.setDefaultCatalogName(string4);
        Integer n3 = ConfigurationHelper.getInteger("hibernate.max_fetch_depth", properties2);
        if (n3 != null) {
            LOG.debugf("Maximum outer join fetch depth: %s", (Object)n3);
        }
        settings.setMaximumFetchDepth(n3);
        int n4 = ConfigurationHelper.getInt("hibernate.default_batch_fetch_size", properties2, 1);
        if (bl) {
            LOG.debugf("Default batch fetch size: %s", (Object)n4);
        }
        settings.setDefaultBatchFetchSize(n4);
        boolean bl10 = ConfigurationHelper.getBoolean("hibernate.use_sql_comments", properties2);
        if (bl) {
            LOG.debugf("Generate SQL with comments: %s", (Object)SettingsFactory.enabledDisabled(bl10));
        }
        settings.setCommentsEnabled(bl10);
        boolean bl11 = ConfigurationHelper.getBoolean("hibernate.order_updates", properties2);
        if (bl) {
            LOG.debugf("Order SQL updates by primary key: %s", (Object)SettingsFactory.enabledDisabled(bl11));
        }
        settings.setOrderUpdatesEnabled(bl11);
        boolean bl12 = ConfigurationHelper.getBoolean("hibernate.order_inserts", properties2);
        if (bl) {
            LOG.debugf("Order SQL inserts for batching: %s", (Object)SettingsFactory.enabledDisabled(bl12));
        }
        settings.setOrderInsertsEnabled(bl12);
        String string5 = ConfigurationHelper.getString("hibernate.order_by.default_null_ordering", properties2, "none", "first", "last");
        if (bl) {
            LOG.debugf("Default null ordering: %s", (Object)string5);
        }
        settings.setDefaultNullPrecedence(NullPrecedence.parse(string5));
        settings.setQueryTranslatorFactory(this.createQueryTranslatorFactory(properties2, serviceRegistry));
        Map map = ConfigurationHelper.toMap("hibernate.query.substitutions", " ,=;:\n\t\r\f", properties2);
        if (bl) {
            LOG.debugf("Query language substitutions: %s", (Object)map);
        }
        settings.setQuerySubstitutions(map);
        boolean bl13 = ConfigurationHelper.getBoolean("hibernate.query.jpaql_strict_compliance", properties2, false);
        if (bl) {
            LOG.debugf("JPA-QL strict compliance: %s", (Object)SettingsFactory.enabledDisabled(bl13));
        }
        settings.setStrictJPAQLCompliance(bl13);
        boolean bl14 = ConfigurationHelper.getBoolean("hibernate.cache.use_second_level_cache", properties2, true);
        if (bl) {
            LOG.debugf("Second-level cache: %s", (Object)SettingsFactory.enabledDisabled(bl14));
        }
        settings.setSecondLevelCacheEnabled(bl14);
        boolean bl15 = ConfigurationHelper.getBoolean("hibernate.cache.use_query_cache", properties2);
        if (bl) {
            LOG.debugf("Query cache: %s", (Object)SettingsFactory.enabledDisabled(bl15));
        }
        settings.setQueryCacheEnabled(bl15);
        if (bl15) {
            settings.setQueryCacheFactory(this.createQueryCacheFactory(properties2, serviceRegistry));
        }
        settings.setRegionFactory(SettingsFactory.createRegionFactory(properties2, bl14 || bl15, serviceRegistry));
        boolean bl16 = ConfigurationHelper.getBoolean("hibernate.cache.use_minimal_puts", properties2, settings.getRegionFactory().isMinimalPutsEnabledByDefault());
        if (bl) {
            LOG.debugf("Optimize cache for minimal puts: %s", (Object)SettingsFactory.enabledDisabled(bl16));
        }
        settings.setMinimalPutsEnabled(bl16);
        String string6 = properties2.getProperty("hibernate.cache.region_prefix");
        if (StringHelper.isEmpty(string6)) {
            string6 = null;
        }
        if (string6 != null && bl) {
            LOG.debugf("Cache region prefix: %s", (Object)string6);
        }
        settings.setCacheRegionPrefix(string6);
        boolean bl17 = ConfigurationHelper.getBoolean("hibernate.cache.use_structured_entries", properties2, false);
        if (bl) {
            LOG.debugf("Structured second-level cache entries: %s", (Object)SettingsFactory.enabledDisabled(bl17));
        }
        settings.setStructuredCacheEntriesEnabled(bl17);
        boolean bl18 = ConfigurationHelper.getBoolean("hibernate.cache.use_reference_entries", properties2, false);
        if (bl) {
            LOG.debugf("Second-level cache direct-reference entries: %s", (Object)SettingsFactory.enabledDisabled(bl18));
        }
        settings.setDirectReferenceCacheEntriesEnabled(bl18);
        boolean bl19 = ConfigurationHelper.getBoolean("hibernate.generate_statistics", properties2);
        if (bl) {
            LOG.debugf("Statistics: %s", (Object)SettingsFactory.enabledDisabled(bl19));
        }
        settings.setStatisticsEnabled(bl19);
        boolean bl20 = ConfigurationHelper.getBoolean("hibernate.use_identifier_rollback", properties2);
        if (bl) {
            LOG.debugf("Deleted entity synthetic identifier rollback: %s", (Object)SettingsFactory.enabledDisabled(bl20));
        }
        settings.setIdentifierRollbackEnabled(bl20);
        String string7 = properties2.getProperty("hibernate.hbm2ddl.auto");
        if ("validate".equals(string7)) {
            settings.setAutoValidateSchema(true);
        }
        if ("update".equals(string7)) {
            settings.setAutoUpdateSchema(true);
        }
        if ("create".equals(string7)) {
            settings.setAutoCreateSchema(true);
        }
        if ("create-drop".equals(string7)) {
            settings.setAutoCreateSchema(true);
            settings.setAutoDropSchema(true);
        }
        settings.setImportFiles(properties2.getProperty("hibernate.hbm2ddl.import_files"));
        EntityMode entityMode = EntityMode.parse(properties2.getProperty("hibernate.default_entity_mode"));
        if (bl) {
            LOG.debugf("Default entity-mode: %s", (Object)entityMode);
        }
        settings.setDefaultEntityMode(entityMode);
        boolean bl21 = ConfigurationHelper.getBoolean("hibernate.query.startup_check", properties2, true);
        if (bl) {
            LOG.debugf("Named query checking : %s", (Object)SettingsFactory.enabledDisabled(bl21));
        }
        settings.setNamedQueryStartupCheckingEnabled(bl21);
        boolean bl22 = ConfigurationHelper.getBoolean("hibernate.check_nullability", properties2, true);
        if (bl) {
            LOG.debugf("Check Nullability in Core (should be disabled when Bean Validation is on): %s", (Object)SettingsFactory.enabledDisabled(bl22));
        }
        settings.setCheckNullability(bl22);
        settings.setEntityTuplizerFactory(new EntityTuplizerFactory());
        boolean bl23 = ConfigurationHelper.getBoolean("hibernate.enable_lazy_load_no_trans", properties2, false);
        if (bl) {
            LOG.debugf("Allow initialization of lazy state outside session : : %s", (Object)SettingsFactory.enabledDisabled(bl23));
        }
        settings.setInitializeLazyStateOutsideTransactions(bl23);
        boolean bl24 = ConfigurationHelper.getBoolean("hibernate.jta.track_by_thread", properties2, true);
        if (bl) {
            LOG.debugf("JTA Track by Thread: %s", (Object)SettingsFactory.enabledDisabled(bl24));
        }
        settings.setJtaTrackByThread(bl24);
        return settings;
    }

    private MultiTableBulkIdStrategy getMultiTableBulkIdStrategy(Properties properties, Dialect dialect, ClassLoaderService classLoaderService) {
        Object object = properties.get("hibernate.hql.bulk_id_strategy");
        if (object != null) {
            Class clazz;
            if (MultiTableBulkIdStrategy.class.isInstance(object)) {
                return (MultiTableBulkIdStrategy)object;
            }
            if (Class.class.isInstance(object)) {
                clazz = (Class)object;
            } else {
                String string = object.toString();
                if ("persistent".equals(string)) {
                    return new PersistentTableBulkIdStrategy();
                }
                if ("temporary".equals(string)) {
                    return TemporaryTableBulkIdStrategy.INSTANCE;
                }
                clazz = classLoaderService.classForName(string);
            }
            try {
                return (MultiTableBulkIdStrategy)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new HibernateException("Unable to interpret MultiTableBulkIdStrategy setting [" + object + "]", exception);
            }
        }
        return dialect.supportsTemporaryTables() ? TemporaryTableBulkIdStrategy.INSTANCE : new PersistentTableBulkIdStrategy();
    }

    private static String enabledDisabled(boolean bl) {
        return bl ? "enabled" : "disabled";
    }

    protected QueryCacheFactory createQueryCacheFactory(Properties properties, ServiceRegistry serviceRegistry) {
        String string = ConfigurationHelper.getString("hibernate.cache.query_cache_factory", properties, StandardQueryCacheFactory.class.getName());
        LOG.debugf("Query cache factory: %s", (Object)string);
        try {
            return (QueryCacheFactory)serviceRegistry.getService(ClassLoaderService.class).classForName(string).newInstance();
        }
        catch (Exception exception) {
            throw new HibernateException("could not instantiate QueryCacheFactory: " + string, exception);
        }
    }

    private static RegionFactory createRegionFactory(Properties properties, boolean bl, ServiceRegistry serviceRegistry) {
        String string = RegionFactoryInitiator.mapLegacyNames(ConfigurationHelper.getString("hibernate.cache.region.factory_class", properties, null));
        if (string == null || !bl) {
            string = DEF_CACHE_REG_FACTORY;
        }
        LOG.debugf("Cache region factory : %s", (Object)string);
        try {
            try {
                return (RegionFactory)serviceRegistry.getService(ClassLoaderService.class).classForName(string).getConstructor(Properties.class).newInstance(properties);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOG.debugf("%s did not provide constructor accepting java.util.Properties; attempting no-arg constructor.", (Object)string);
                return (RegionFactory)serviceRegistry.getService(ClassLoaderService.class).classForName(string).newInstance();
            }
        }
        catch (Exception exception) {
            throw new HibernateException("could not instantiate RegionFactory [" + string + "]", exception);
        }
    }

    public static RegionFactory createRegionFactory(Properties properties, boolean bl) {
        String string = RegionFactoryInitiator.mapLegacyNames(ConfigurationHelper.getString("hibernate.cache.region.factory_class", properties, null));
        if (string == null) {
            string = DEF_CACHE_REG_FACTORY;
        }
        LOG.debugf("Cache region factory : %s", (Object)string);
        try {
            try {
                return (RegionFactory)ReflectHelper.classForName(string).getConstructor(Properties.class).newInstance(properties);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOG.debugf("%s did not provide constructor accepting java.util.Properties; attempting no-arg constructor.", (Object)string);
                return (RegionFactory)ReflectHelper.classForName(string).newInstance();
            }
        }
        catch (Exception exception) {
            throw new HibernateException("could not instantiate RegionFactory [" + string + "]", exception);
        }
    }

    protected QueryTranslatorFactory createQueryTranslatorFactory(Properties properties, ServiceRegistry serviceRegistry) {
        String string = ConfigurationHelper.getString("hibernate.query.factory_class", properties, "org.hibernate.hql.internal.ast.ASTQueryTranslatorFactory");
        LOG.debugf("Query translator: %s", (Object)string);
        try {
            return (QueryTranslatorFactory)serviceRegistry.getService(ClassLoaderService.class).classForName(string).newInstance();
        }
        catch (Exception exception) {
            throw new HibernateException("could not instantiate QueryTranslatorFactory: " + string, exception);
        }
    }
}

