/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.persistence.Access;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AccessType;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyContainer {
    private static final CoreMessageLogger LOG;
    private final AccessType explicitClassDefinedAccessType;
    private final TreeMap<String, XProperty> fieldAccessMap;
    private final TreeMap<String, XProperty> propertyAccessMap;
    private final XClass xClass;
    private final XClass entityAtStake;

    PropertyContainer(XClass xClass, XClass xClass2) {
        this.xClass = xClass;
        this.entityAtStake = xClass2;
        this.explicitClassDefinedAccessType = this.determineClassDefinedAccessStrategy();
        this.fieldAccessMap = this.initProperties(AccessType.FIELD);
        this.propertyAccessMap = this.initProperties(AccessType.PROPERTY);
        this.considerExplicitFieldAndPropertyAccess();
    }

    public XClass getEntityAtStake() {
        return this.entityAtStake;
    }

    public XClass getDeclaringClass() {
        return this.xClass;
    }

    public AccessType getExplicitAccessStrategy() {
        return this.explicitClassDefinedAccessType;
    }

    public boolean hasExplicitAccessStrategy() {
        return !this.explicitClassDefinedAccessType.equals((Object)AccessType.DEFAULT);
    }

    public Collection<XProperty> getProperties(AccessType accessType) {
        this.assertTypesAreResolvable(accessType);
        if (AccessType.DEFAULT == accessType || AccessType.PROPERTY == accessType) {
            return Collections.unmodifiableCollection(this.propertyAccessMap.values());
        }
        return Collections.unmodifiableCollection(this.fieldAccessMap.values());
    }

    private void assertTypesAreResolvable(AccessType accessType) {
        TreeMap<String, XProperty> treeMap = AccessType.PROPERTY.equals((Object)accessType) || AccessType.DEFAULT.equals((Object)accessType) ? this.propertyAccessMap : this.fieldAccessMap;
        for (XProperty xProperty : treeMap.values()) {
            if (xProperty.isTypeResolved() || PropertyContainer.discoverTypeWithoutReflection(xProperty)) continue;
            String string = "Property " + StringHelper.qualify(this.xClass.getName(), xProperty.getName()) + " has an unbound type and no explicit target entity. Resolve this Generic usage issue" + " or set an explicit target attribute (eg @OneToMany(target=) or use an explicit @Type";
            throw new AnnotationException(string);
        }
    }

    private void considerExplicitFieldAndPropertyAccess() {
        AccessType accessType;
        Access access;
        for (XProperty xProperty : this.fieldAccessMap.values()) {
            access = xProperty.getAnnotation(Access.class);
            if (access == null) continue;
            accessType = AccessType.getAccessStrategy(access.value());
            if (accessType == AccessType.FIELD) {
                this.propertyAccessMap.put(xProperty.getName(), xProperty);
                continue;
            }
            LOG.debug("Placing @Access(AccessType.FIELD) on a field does not have any effect.");
        }
        for (XProperty xProperty : this.propertyAccessMap.values()) {
            access = xProperty.getAnnotation(Access.class);
            if (access == null) continue;
            accessType = AccessType.getAccessStrategy(access.value());
            if (accessType == AccessType.PROPERTY) {
                this.fieldAccessMap.put(xProperty.getName(), xProperty);
                continue;
            }
            LOG.debug("Placing @Access(AccessType.PROPERTY) on a field does not have any effect.");
        }
    }

    private TreeMap<String, XProperty> initProperties(AccessType accessType) {
        if (!AccessType.PROPERTY.equals((Object)accessType) && !AccessType.FIELD.equals((Object)accessType)) {
            throw new IllegalArgumentException("Access type has to be AccessType.FIELD or AccessType.Property");
        }
        TreeMap<String, XProperty> treeMap = new TreeMap<String, XProperty>();
        List<XProperty> list = this.xClass.getDeclaredProperties(accessType.getType());
        for (XProperty xProperty : list) {
            if (PropertyContainer.mustBeSkipped(xProperty)) continue;
            treeMap.put(xProperty.getName(), xProperty);
        }
        return treeMap;
    }

    private AccessType determineClassDefinedAccessStrategy() {
        Access access;
        AccessType accessType = AccessType.DEFAULT;
        AccessType accessType2 = AccessType.DEFAULT;
        org.hibernate.annotations.AccessType accessType3 = this.xClass.getAnnotation(org.hibernate.annotations.AccessType.class);
        if (accessType3 != null) {
            accessType = AccessType.getAccessStrategy(accessType3.value());
        }
        if ((access = this.xClass.getAnnotation(Access.class)) != null) {
            accessType2 = AccessType.getAccessStrategy(access.value());
        }
        if (accessType != AccessType.DEFAULT && accessType2 != AccessType.DEFAULT && accessType != accessType2) {
            throw new MappingException("@AccessType and @Access specified with contradicting values. Use of @Access only is recommended. ");
        }
        AccessType accessType4 = accessType != AccessType.DEFAULT ? accessType : accessType2;
        return accessType4;
    }

    private static boolean discoverTypeWithoutReflection(XProperty xProperty) {
        if (xProperty.isAnnotationPresent(OneToOne.class) && !xProperty.getAnnotation(OneToOne.class).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (xProperty.isAnnotationPresent(OneToMany.class) && !xProperty.getAnnotation(OneToMany.class).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (xProperty.isAnnotationPresent(ManyToOne.class) && !xProperty.getAnnotation(ManyToOne.class).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (xProperty.isAnnotationPresent(ManyToMany.class) && !xProperty.getAnnotation(ManyToMany.class).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (xProperty.isAnnotationPresent(Any.class)) {
            return true;
        }
        if (xProperty.isAnnotationPresent(ManyToAny.class)) {
            if (!xProperty.isCollection() && !xProperty.isArray()) {
                throw new AnnotationException("@ManyToAny used on a non collection non array property: " + xProperty.getName());
            }
            return true;
        }
        if (xProperty.isAnnotationPresent(Type.class)) {
            return true;
        }
        return xProperty.isAnnotationPresent(Target.class);
    }

    private static boolean mustBeSkipped(XProperty xProperty) {
        return xProperty.isAnnotationPresent(Transient.class) || "net.sf.cglib.transform.impl.InterceptFieldCallback".equals(xProperty.getType().getName()) || "org.hibernate.bytecode.internal.javassist.FieldHandler".equals(xProperty.getType().getName());
    }

    static {
        System.setProperty("jboss.i18n.generate-proxies", "true");
        LOG = Logger.getMessageLogger(CoreMessageLogger.class, PropertyContainer.class.getName());
    }
}

