/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.ToOneBinder;
import org.hibernate.cfg.ToOneFkSecondPass;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.type.ForeignKeyDirection;

public class OneToOneSecondPass
implements SecondPass {
    private String mappedBy;
    private Mappings mappings;
    private String ownerEntity;
    private String ownerProperty;
    private PropertyHolder propertyHolder;
    private boolean ignoreNotFound;
    private PropertyData inferredData;
    private XClass targetEntity;
    private boolean cascadeOnDelete;
    private boolean optional;
    private String cascadeStrategy;
    private Ejb3JoinColumn[] joinColumns;

    public OneToOneSecondPass(String string, String string2, String string3, PropertyHolder propertyHolder, PropertyData propertyData, XClass xClass, boolean bl, boolean bl2, boolean bl3, String string4, Ejb3JoinColumn[] ejb3JoinColumnArray, Mappings mappings) {
        this.ownerEntity = string2;
        this.ownerProperty = string3;
        this.mappedBy = string;
        this.propertyHolder = propertyHolder;
        this.mappings = mappings;
        this.ignoreNotFound = bl;
        this.inferredData = propertyData;
        this.targetEntity = xClass;
        this.cascadeOnDelete = bl2;
        this.optional = bl3;
        this.cascadeStrategy = string4;
        this.joinColumns = ejb3JoinColumnArray;
    }

    public void doSecondPass(Map map) throws MappingException {
        Object object;
        OneToOne oneToOne = new OneToOne(this.mappings, this.propertyHolder.getTable(), this.propertyHolder.getPersistentClass());
        String string = this.inferredData.getPropertyName();
        oneToOne.setPropertyName(string);
        String string2 = ToOneBinder.getReferenceEntityName(this.inferredData, this.targetEntity, this.mappings);
        oneToOne.setReferencedEntityName(string2);
        AnnotationBinder.defineFetchingStrategy(oneToOne, this.inferredData.getProperty());
        oneToOne.setCascadeDeleteEnabled(this.cascadeOnDelete);
        if (!this.optional) {
            oneToOne.setConstrained(true);
        }
        oneToOne.setForeignKeyType(oneToOne.isConstrained() ? ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT : ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        PropertyBinder propertyBinder = new PropertyBinder();
        propertyBinder.setName(string);
        propertyBinder.setValue(oneToOne);
        propertyBinder.setCascade(this.cascadeStrategy);
        propertyBinder.setAccessType(this.inferredData.getDefaultAccess());
        Property property = propertyBinder.makeProperty();
        if (BinderHelper.isEmptyAnnotationValue(this.mappedBy)) {
            boolean bl = true;
            if (bl) {
                object = StringHelper.qualify(this.propertyHolder.getPath(), string);
                new ToOneFkSecondPass(oneToOne, this.joinColumns, !this.optional, this.propertyHolder.getEntityOwnerClassName(), (String)object, this.mappings).doSecondPass(map);
                this.propertyHolder.addProperty(property, this.inferredData.getDeclaringClass());
            }
        } else {
            PersistentClass persistentClass = (PersistentClass)map.get(oneToOne.getReferencedEntityName());
            try {
                if (persistentClass == null) {
                    throw new MappingException("Unable to find entity: " + oneToOne.getReferencedEntityName());
                }
                object = BinderHelper.findPropertyByName(persistentClass, this.mappedBy);
            }
            catch (MappingException mappingException) {
                throw new AnnotationException("Unknown mappedBy in: " + StringHelper.qualify(this.ownerEntity, this.ownerProperty) + ", referenced property unknown: " + StringHelper.qualify(oneToOne.getReferencedEntityName(), this.mappedBy));
            }
            if (object == null) {
                throw new AnnotationException("Unknown mappedBy in: " + StringHelper.qualify(this.ownerEntity, this.ownerProperty) + ", referenced property unknown: " + StringHelper.qualify(oneToOne.getReferencedEntityName(), this.mappedBy));
            }
            if (((Property)object).getValue() instanceof OneToOne) {
                this.propertyHolder.addProperty(property, this.inferredData.getDeclaringClass());
            } else if (((Property)object).getValue() instanceof ManyToOne) {
                Object object2;
                Join join;
                Iterator iterator = persistentClass.getJoinIterator();
                Join join2 = null;
                while (iterator.hasNext()) {
                    join = (Join)iterator.next();
                    if (!join.containsProperty((Property)object)) continue;
                    join2 = join;
                    break;
                }
                if (join2 != null) {
                    join = this.buildJoinFromMappedBySide((PersistentClass)map.get(this.ownerEntity), (Property)object, join2);
                    ManyToOne manyToOne = new ManyToOne(this.mappings, join.getTable());
                    manyToOne.setIgnoreNotFound(this.ignoreNotFound);
                    manyToOne.setCascadeDeleteEnabled(oneToOne.isCascadeDeleteEnabled());
                    manyToOne.setEmbedded(oneToOne.isEmbedded());
                    manyToOne.setFetchMode(oneToOne.getFetchMode());
                    manyToOne.setLazy(oneToOne.isLazy());
                    manyToOne.setReferencedEntityName(oneToOne.getReferencedEntityName());
                    manyToOne.setUnwrapProxy(oneToOne.isUnwrapProxy());
                    property.setValue(manyToOne);
                    object2 = join2.getKey().getColumnIterator();
                    while (object2.hasNext()) {
                        Column column = (Column)object2.next();
                        Column column2 = new Column();
                        column2.setLength(column.getLength());
                        column2.setScale(column.getScale());
                        column2.setValue(manyToOne);
                        column2.setName(column.getQuotedName());
                        column2.setNullable(column.isNullable());
                        column2.setPrecision(column.getPrecision());
                        column2.setUnique(column.isUnique());
                        column2.setSqlType(column.getSqlType());
                        column2.setCheckConstraint(column.getCheckConstraint());
                        column2.setComment(column.getComment());
                        column2.setDefaultValue(column.getDefaultValue());
                        manyToOne.addColumn(column2);
                    }
                    join.addProperty(property);
                } else {
                    this.propertyHolder.addProperty(property, this.inferredData.getDeclaringClass());
                }
                oneToOne.setReferencedPropertyName(this.mappedBy);
                boolean bl = false;
                try {
                    bl = persistentClass.getIdentifier() instanceof Component && ((Component)persistentClass.getIdentifier()).getProperty(this.mappedBy) != null;
                }
                catch (MappingException mappingException) {
                    // empty catch block
                }
                boolean bl2 = bl || this.mappedBy == null;
                oneToOne.setReferenceToPrimaryKey(bl2);
                if (bl) {
                    ((ManyToOne)((Property)object).getValue()).setReferenceToPrimaryKey(false);
                }
                if ((object2 = oneToOne.getReferencedPropertyName()) != null) {
                    this.mappings.addUniquePropertyReference(oneToOne.getReferencedEntityName(), (String)object2);
                }
            } else {
                throw new AnnotationException("Referenced property not a (One|Many)ToOne: " + StringHelper.qualify(persistentClass.getEntityName(), this.mappedBy) + " in mappedBy of " + StringHelper.qualify(this.ownerEntity, this.ownerProperty));
            }
        }
        ForeignKey foreignKey = this.inferredData.getProperty().getAnnotation(ForeignKey.class);
        Object object3 = object = foreignKey != null ? foreignKey.name() : "";
        if (!BinderHelper.isEmptyAnnotationValue((String)object)) {
            oneToOne.setForeignKeyName((String)object);
        }
    }

    private Join buildJoinFromMappedBySide(PersistentClass persistentClass, Property property, Join join) {
        Join join2 = new Join();
        join2.setPersistentClass(persistentClass);
        join2.setTable(join.getTable());
        join2.setInverse(true);
        DependantValue dependantValue = new DependantValue(this.mappings, join2.getTable(), persistentClass.getIdentifier());
        join2.setKey(dependantValue);
        join2.setSequentialSelect(false);
        join2.setOptional(true);
        dependantValue.setCascadeDeleteEnabled(false);
        Iterator iterator = property.getValue().getColumnIterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            Column column2 = new Column();
            column2.setLength(column.getLength());
            column2.setScale(column.getScale());
            column2.setValue(dependantValue);
            column2.setName(column.getQuotedName());
            column2.setNullable(column.isNullable());
            column2.setPrecision(column.getPrecision());
            column2.setUnique(column.isUnique());
            column2.setSqlType(column.getSqlType());
            column2.setCheckConstraint(column.getCheckConstraint());
            column2.setComment(column.getComment());
            column2.setDefaultValue(column.getDefaultValue());
            dependantValue.addColumn(column2);
        }
        persistentClass.addJoin(join2);
        return join2;
    }
}

