/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import org.hibernate.cfg.NamingStrategy;
import org.hibernate.internal.util.StringHelper;

public abstract class ObjectNameNormalizer {
    public String normalizeDatabaseIdentifier(String string, NamingStrategyHelper namingStrategyHelper) {
        String string2 = null;
        if (!StringHelper.isEmpty(string)) {
            string2 = this.normalizeIdentifierQuoting(string);
            string2 = namingStrategyHelper.handleExplicitName(this.getNamingStrategy(), string2);
            return this.normalizeIdentifierQuoting(string2);
        }
        string2 = namingStrategyHelper.determineImplicitName(this.getNamingStrategy());
        return this.normalizeIdentifierQuoting(string2);
    }

    public String normalizeIdentifierQuoting(String string) {
        if (StringHelper.isEmpty(string)) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return '`' + string.substring(1, string.length() - 1) + '`';
        }
        if (!(!this.isUseQuotedIdentifiersGlobally() || string.startsWith("`") && string.endsWith("`"))) {
            return '`' + string + '`';
        }
        return string;
    }

    protected abstract boolean isUseQuotedIdentifiersGlobally();

    protected abstract NamingStrategy getNamingStrategy();

    public static interface NamingStrategyHelper {
        public String determineImplicitName(NamingStrategy var1);

        public String handleExplicitName(NamingStrategy var1, String var2);
    }
}

