/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.cfg.HbmBinder;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.QuerySecondPass;
import org.hibernate.cfg.ResultSetMappingBinder;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class NamedSQLQuerySecondPass
extends ResultSetMappingBinder
implements QuerySecondPass {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, NamedSQLQuerySecondPass.class.getName());
    private Element queryElem;
    private String path;
    private Mappings mappings;

    public NamedSQLQuerySecondPass(Element element, String string, Mappings mappings) {
        this.queryElem = element;
        this.path = string;
        this.mappings = mappings;
    }

    public void doSecondPass(Map map) throws MappingException {
        NamedSQLQueryDefinition namedSQLQueryDefinition;
        String string;
        String string2 = this.queryElem.attribute("name").getValue();
        if (this.path != null) {
            string2 = this.path + '.' + string2;
        }
        boolean bl = "true".equals(this.queryElem.attributeValue("cacheable"));
        String string3 = this.queryElem.attributeValue("cache-region");
        Attribute attribute = this.queryElem.attribute("timeout");
        Integer n = attribute == null ? null : Integer.valueOf(attribute.getValue());
        Attribute attribute2 = this.queryElem.attribute("fetch-size");
        Integer n2 = attribute2 == null ? null : Integer.valueOf(attribute2.getValue());
        Attribute attribute3 = this.queryElem.attribute("read-only");
        boolean bl2 = attribute3 != null && "true".equals(attribute3.getValue());
        Attribute attribute4 = this.queryElem.attribute("cache-mode");
        String string4 = attribute4 == null ? null : attribute4.getValue();
        Attribute attribute5 = this.queryElem.attribute("comment");
        String string5 = attribute5 == null ? null : attribute5.getValue();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.queryElem.elementIterator("synchronize");
        while (iterator.hasNext()) {
            arrayList.add(((Element)iterator.next()).attributeValue("table"));
        }
        boolean bl3 = "true".equals(this.queryElem.attributeValue("callable"));
        Attribute attribute6 = this.queryElem.attribute("resultset-ref");
        String string6 = string = attribute6 == null ? null : attribute6.getValue();
        if (StringHelper.isNotEmpty(string)) {
            namedSQLQueryDefinition = new NamedSQLQueryDefinition(string2, this.queryElem.getText(), string, arrayList, bl, string3, n, n2, HbmBinder.getFlushMode(this.queryElem.attributeValue("flush-mode")), HbmBinder.getCacheMode(string4), bl2, string5, HbmBinder.getParameterTypes(this.queryElem), bl3);
        } else {
            ResultSetMappingDefinition resultSetMappingDefinition = NamedSQLQuerySecondPass.buildResultSetMappingDefinition(this.queryElem, this.path, this.mappings);
            namedSQLQueryDefinition = new NamedSQLQueryDefinition(string2, this.queryElem.getText(), resultSetMappingDefinition.getQueryReturns(), arrayList, bl, string3, n, n2, HbmBinder.getFlushMode(this.queryElem.attributeValue("flush-mode")), HbmBinder.getCacheMode(string4), bl2, string5, HbmBinder.getParameterTypes(this.queryElem), bl3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Named SQL query: %s -> %s", (Object)namedSQLQueryDefinition.getName(), (Object)namedSQLQueryDefinition.getQueryString());
        }
        this.mappings.addSQLQuery(string2, namedSQLQueryDefinition);
    }
}

