/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyContainer;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.mapping.PersistentClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritanceState {
    private XClass clazz;
    private boolean hasSiblings = false;
    private boolean hasParents = false;
    private InheritanceType type;
    private boolean isEmbeddableSuperclass = false;
    private Map<XClass, InheritanceState> inheritanceStatePerClass;
    private List<XClass> classesToProcessForMappedSuperclass = new ArrayList<XClass>();
    private Mappings mappings;
    private AccessType accessType;
    private ElementsToProcess elementsToProcess;
    private Boolean hasIdClassOrEmbeddedId;

    public InheritanceState(XClass xClass, Map<XClass, InheritanceState> map, Mappings mappings) {
        this.setClazz(xClass);
        this.mappings = mappings;
        this.inheritanceStatePerClass = map;
        this.extractInheritanceType();
    }

    private void extractInheritanceType() {
        XClass xClass = this.getClazz();
        Inheritance inheritance = xClass.getAnnotation(Inheritance.class);
        MappedSuperclass mappedSuperclass = xClass.getAnnotation(MappedSuperclass.class);
        if (mappedSuperclass != null) {
            this.setEmbeddableSuperclass(true);
            this.setType(inheritance == null ? null : inheritance.strategy());
        } else {
            this.setType(inheritance == null ? InheritanceType.SINGLE_TABLE : inheritance.strategy());
        }
    }

    boolean hasTable() {
        return !this.hasParents() || !InheritanceType.SINGLE_TABLE.equals((Object)this.getType());
    }

    boolean hasDenormalizedTable() {
        return this.hasParents() && InheritanceType.TABLE_PER_CLASS.equals((Object)this.getType());
    }

    public static InheritanceState getInheritanceStateOfSuperEntity(XClass xClass, Map<XClass, InheritanceState> map) {
        XClass xClass2 = xClass;
        do {
            InheritanceState inheritanceState;
            if ((inheritanceState = map.get(xClass2 = xClass2.getSuperclass())) == null || inheritanceState.isEmbeddableSuperclass()) continue;
            return inheritanceState;
        } while (xClass2 != null && !Object.class.getName().equals(xClass2.getName()));
        return null;
    }

    public static InheritanceState getSuperclassInheritanceState(XClass xClass, Map<XClass, InheritanceState> map) {
        XClass xClass2 = xClass;
        do {
            InheritanceState inheritanceState;
            if ((inheritanceState = map.get(xClass2 = xClass2.getSuperclass())) == null) continue;
            return inheritanceState;
        } while (xClass2 != null && !Object.class.getName().equals(xClass2.getName()));
        return null;
    }

    public XClass getClazz() {
        return this.clazz;
    }

    public void setClazz(XClass xClass) {
        this.clazz = xClass;
    }

    public boolean hasSiblings() {
        return this.hasSiblings;
    }

    public void setHasSiblings(boolean bl) {
        this.hasSiblings = bl;
    }

    public boolean hasParents() {
        return this.hasParents;
    }

    public void setHasParents(boolean bl) {
        this.hasParents = bl;
    }

    public InheritanceType getType() {
        return this.type;
    }

    public void setType(InheritanceType inheritanceType) {
        this.type = inheritanceType;
    }

    public boolean isEmbeddableSuperclass() {
        return this.isEmbeddableSuperclass;
    }

    public void setEmbeddableSuperclass(boolean bl) {
        this.isEmbeddableSuperclass = bl;
    }

    void postProcess(PersistentClass persistentClass, EntityBinder entityBinder) {
        this.getElementsToProcess();
        this.addMappedSuperClassInMetadata(persistentClass);
        entityBinder.setPropertyAccessType(this.accessType);
    }

    public XClass getClassWithIdClass(boolean bl) {
        if (!bl && this.hasParents()) {
            return null;
        }
        if (this.clazz.isAnnotationPresent(IdClass.class)) {
            return this.clazz;
        }
        InheritanceState inheritanceState = InheritanceState.getSuperclassInheritanceState(this.clazz, this.inheritanceStatePerClass);
        if (inheritanceState != null) {
            return inheritanceState.getClassWithIdClass(true);
        }
        return null;
    }

    public Boolean hasIdClassOrEmbeddedId() {
        if (this.hasIdClassOrEmbeddedId == null) {
            this.hasIdClassOrEmbeddedId = false;
            if (this.getClassWithIdClass(true) != null) {
                this.hasIdClassOrEmbeddedId = true;
            } else {
                ElementsToProcess elementsToProcess = this.getElementsToProcess();
                for (PropertyData propertyData : elementsToProcess.getElements()) {
                    if (!propertyData.getProperty().isAnnotationPresent(EmbeddedId.class)) continue;
                    this.hasIdClassOrEmbeddedId = true;
                    break;
                }
            }
        }
        return this.hasIdClassOrEmbeddedId;
    }

    public ElementsToProcess getElementsToProcess() {
        if (this.elementsToProcess == null) {
            InheritanceState inheritanceState = this.inheritanceStatePerClass.get(this.clazz);
            assert (!inheritanceState.isEmbeddableSuperclass());
            this.getMappedSuperclassesTillNextEntityOrdered();
            this.accessType = this.determineDefaultAccessType();
            ArrayList<PropertyData> arrayList = new ArrayList<PropertyData>();
            int n = this.classesToProcessForMappedSuperclass.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                PropertyContainer propertyContainer = new PropertyContainer(this.classesToProcessForMappedSuperclass.get(i), this.clazz);
                int n3 = AnnotationBinder.addElementsOfClass(arrayList, this.accessType, propertyContainer, this.mappings);
                n2 += n3;
            }
            if (n2 == 0 && !inheritanceState.hasParents()) {
                throw new AnnotationException("No identifier specified for entity: " + this.clazz.getName());
            }
            arrayList.trimToSize();
            this.elementsToProcess = new ElementsToProcess(arrayList, n2);
        }
        return this.elementsToProcess;
    }

    private AccessType determineDefaultAccessType() {
        XClass xClass;
        for (xClass = this.clazz; xClass != null; xClass = xClass.getSuperclass()) {
            if (xClass.getSuperclass() != null && !Object.class.getName().equals(xClass.getSuperclass().getName()) || !xClass.isAnnotationPresent(Entity.class) && !xClass.isAnnotationPresent(MappedSuperclass.class) || !xClass.isAnnotationPresent(Access.class)) continue;
            return AccessType.getAccessStrategy(xClass.getAnnotation(Access.class).value());
        }
        for (xClass = this.clazz; xClass != null && !Object.class.getName().equals(xClass.getName()); xClass = xClass.getSuperclass()) {
            boolean bl;
            if (!xClass.isAnnotationPresent(Entity.class) && !xClass.isAnnotationPresent(MappedSuperclass.class)) continue;
            for (XProperty xProperty : xClass.getDeclaredProperties(AccessType.PROPERTY.getType())) {
                bl = xProperty.isAnnotationPresent(EmbeddedId.class);
                if (!xProperty.isAnnotationPresent(Id.class) && !bl) continue;
                return AccessType.PROPERTY;
            }
            for (XProperty xProperty : xClass.getDeclaredProperties(AccessType.FIELD.getType())) {
                bl = xProperty.isAnnotationPresent(EmbeddedId.class);
                if (!xProperty.isAnnotationPresent(Id.class) && !bl) continue;
                return AccessType.FIELD;
            }
        }
        throw new AnnotationException("No identifier specified for entity: " + this.clazz);
    }

    private void getMappedSuperclassesTillNextEntityOrdered() {
        InheritanceState inheritanceState;
        XClass xClass = this.clazz;
        do {
            this.classesToProcessForMappedSuperclass.add(0, xClass);
            XClass xClass2 = xClass;
            do {
                xClass2 = xClass2.getSuperclass();
                inheritanceState = this.inheritanceStatePerClass.get(xClass2);
            } while (xClass2 != null && !this.mappings.getReflectionManager().equals(xClass2, Object.class) && inheritanceState == null);
            xClass = xClass2;
        } while (inheritanceState != null && inheritanceState.isEmbeddableSuperclass());
    }

    private void addMappedSuperClassInMetadata(PersistentClass persistentClass) {
        org.hibernate.mapping.MappedSuperclass mappedSuperclass = null;
        InheritanceState inheritanceState = InheritanceState.getInheritanceStateOfSuperEntity(this.clazz, this.inheritanceStatePerClass);
        PersistentClass persistentClass2 = inheritanceState != null ? this.mappings.getClass(inheritanceState.getClazz().getName()) : null;
        int n = this.classesToProcessForMappedSuperclass.size() - 1;
        for (int i = 0; i < n; ++i) {
            org.hibernate.mapping.MappedSuperclass mappedSuperclass2 = mappedSuperclass;
            Class clazz = this.mappings.getReflectionManager().toClass(this.classesToProcessForMappedSuperclass.get(i));
            mappedSuperclass = this.mappings.getMappedSuperclass(clazz);
            if (mappedSuperclass != null) continue;
            mappedSuperclass = new org.hibernate.mapping.MappedSuperclass(mappedSuperclass2, persistentClass2);
            mappedSuperclass.setMappedClass(clazz);
            this.mappings.addMappedSuperclass(clazz, mappedSuperclass);
        }
        if (mappedSuperclass != null) {
            persistentClass.setSuperMappedSuperclass(mappedSuperclass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ElementsToProcess {
        private final List<PropertyData> properties;
        private final int idPropertyCount;

        public List<PropertyData> getElements() {
            return this.properties;
        }

        public int getIdPropertyCount() {
            return this.idPropertyCount;
        }

        private ElementsToProcess(List<PropertyData> list, int n) {
            this.properties = list;
            this.idPropertyCount = n;
        }
    }
}

