/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

public class IndexOrUniqueKeySecondPass
implements SecondPass {
    private Table table;
    private final String indexName;
    private final String[] columns;
    private final Mappings mappings;
    private final Ejb3Column column;
    private final boolean unique;

    public IndexOrUniqueKeySecondPass(Table table, String string, String[] stringArray, Mappings mappings) {
        this.table = table;
        this.indexName = string;
        this.columns = stringArray;
        this.mappings = mappings;
        this.column = null;
        this.unique = false;
    }

    public IndexOrUniqueKeySecondPass(String string, Ejb3Column ejb3Column, Mappings mappings) {
        this(string, ejb3Column, mappings, false);
    }

    public IndexOrUniqueKeySecondPass(String string, Ejb3Column ejb3Column, Mappings mappings, boolean bl) {
        this.indexName = string;
        this.column = ejb3Column;
        this.columns = null;
        this.mappings = mappings;
        this.unique = bl;
    }

    public void doSecondPass(Map map) throws MappingException {
        if (this.columns != null) {
            for (String string : this.columns) {
                this.addConstraintToColumn(string);
            }
        }
        if (this.column != null) {
            this.table = this.column.getTable();
            this.addConstraintToColumn(this.mappings.getLogicalColumnName(this.column.getMappingColumn().getQuotedName(), this.table));
        }
    }

    private void addConstraintToColumn(String string) {
        Column column = this.table.getColumn(new Column(this.mappings.getPhysicalColumnName(string, this.table)));
        if (column == null) {
            throw new AnnotationException("@Index references a unknown column: " + string);
        }
        if (this.unique) {
            this.table.getOrCreateUniqueKey(this.indexName).addColumn(column);
        } else {
            this.table.getOrCreateIndex(this.indexName).addColumn(column);
        }
    }
}

