/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.cfg.Configuration;
import org.hibernate.internal.util.config.ConfigurationHelper;

public abstract class ExternalSessionFactoryConfig {
    private String mapResources;
    private String dialect;
    private String defaultSchema;
    private String defaultCatalog;
    private String maximumFetchDepth;
    private String jdbcFetchSize;
    private String jdbcBatchSize;
    private String batchVersionedDataEnabled;
    private String jdbcScrollableResultSetEnabled;
    private String getGeneratedKeysEnabled;
    private String streamsForBinaryEnabled;
    private String reflectionOptimizationEnabled;
    private String querySubstitutions;
    private String showSqlEnabled;
    private String commentsEnabled;
    private String cacheRegionFactory;
    private String cacheProviderConfig;
    private String cacheRegionPrefix;
    private String secondLevelCacheEnabled;
    private String minimalPutsEnabled;
    private String queryCacheEnabled;
    private Map additionalProperties;
    private Set excludedPropertyNames = new HashSet();

    protected Set getExcludedPropertyNames() {
        return this.excludedPropertyNames;
    }

    public final String getMapResources() {
        return this.mapResources;
    }

    public final void setMapResources(String string) {
        this.mapResources = string;
    }

    public void addMapResource(String string) {
        this.mapResources = this.mapResources == null || this.mapResources.length() == 0 ? string.trim() : this.mapResources + ", " + string.trim();
    }

    public final String getDialect() {
        return this.dialect;
    }

    public final void setDialect(String string) {
        this.dialect = string;
    }

    public final String getDefaultSchema() {
        return this.defaultSchema;
    }

    public final void setDefaultSchema(String string) {
        this.defaultSchema = string;
    }

    public final String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public final void setDefaultCatalog(String string) {
        this.defaultCatalog = string;
    }

    public final String getMaximumFetchDepth() {
        return this.maximumFetchDepth;
    }

    public final void setMaximumFetchDepth(String string) {
        this.verifyInt(string);
        this.maximumFetchDepth = string;
    }

    public final String getJdbcFetchSize() {
        return this.jdbcFetchSize;
    }

    public final void setJdbcFetchSize(String string) {
        this.verifyInt(string);
        this.jdbcFetchSize = string;
    }

    public final String getJdbcBatchSize() {
        return this.jdbcBatchSize;
    }

    public final void setJdbcBatchSize(String string) {
        this.verifyInt(string);
        this.jdbcBatchSize = string;
    }

    public final String getBatchVersionedDataEnabled() {
        return this.batchVersionedDataEnabled;
    }

    public final void setBatchVersionedDataEnabled(String string) {
        this.batchVersionedDataEnabled = string;
    }

    public final String getJdbcScrollableResultSetEnabled() {
        return this.jdbcScrollableResultSetEnabled;
    }

    public final void setJdbcScrollableResultSetEnabled(String string) {
        this.jdbcScrollableResultSetEnabled = string;
    }

    public final String getGetGeneratedKeysEnabled() {
        return this.getGeneratedKeysEnabled;
    }

    public final void setGetGeneratedKeysEnabled(String string) {
        this.getGeneratedKeysEnabled = string;
    }

    public final String getStreamsForBinaryEnabled() {
        return this.streamsForBinaryEnabled;
    }

    public final void setStreamsForBinaryEnabled(String string) {
        this.streamsForBinaryEnabled = string;
    }

    public final String getReflectionOptimizationEnabled() {
        return this.reflectionOptimizationEnabled;
    }

    public final void setReflectionOptimizationEnabled(String string) {
        this.reflectionOptimizationEnabled = string;
    }

    public final String getQuerySubstitutions() {
        return this.querySubstitutions;
    }

    public final void setQuerySubstitutions(String string) {
        this.querySubstitutions = string;
    }

    public final String getShowSqlEnabled() {
        return this.showSqlEnabled;
    }

    public final void setShowSqlEnabled(String string) {
        this.showSqlEnabled = string;
    }

    public final String getCommentsEnabled() {
        return this.commentsEnabled;
    }

    public final void setCommentsEnabled(String string) {
        this.commentsEnabled = string;
    }

    public final String getSecondLevelCacheEnabled() {
        return this.secondLevelCacheEnabled;
    }

    public final void setSecondLevelCacheEnabled(String string) {
        this.secondLevelCacheEnabled = string;
    }

    public final String getCacheRegionFactory() {
        return this.cacheRegionFactory;
    }

    public final void setCacheRegionFactory(String string) {
        this.cacheRegionFactory = string;
    }

    public String getCacheProviderConfig() {
        return this.cacheProviderConfig;
    }

    public void setCacheProviderConfig(String string) {
        this.cacheProviderConfig = string;
    }

    public final String getCacheRegionPrefix() {
        return this.cacheRegionPrefix;
    }

    public final void setCacheRegionPrefix(String string) {
        this.cacheRegionPrefix = string;
    }

    public final String getMinimalPutsEnabled() {
        return this.minimalPutsEnabled;
    }

    public final void setMinimalPutsEnabled(String string) {
        this.minimalPutsEnabled = string;
    }

    public final String getQueryCacheEnabled() {
        return this.queryCacheEnabled;
    }

    public final void setQueryCacheEnabled(String string) {
        this.queryCacheEnabled = string;
    }

    public final void addAdditionalProperty(String string, String string2) {
        if (!this.getExcludedPropertyNames().contains(string)) {
            if (this.additionalProperties == null) {
                this.additionalProperties = new HashMap();
            }
            this.additionalProperties.put(string, string2);
        }
    }

    protected final Configuration buildConfiguration() {
        Configuration configuration = new Configuration().setProperties(this.buildProperties());
        String[] stringArray = ConfigurationHelper.toStringArray(this.mapResources, " ,\n\t\r\f");
        for (int i = 0; i < stringArray.length; ++i) {
            configuration.addResource(stringArray[i]);
        }
        return configuration;
    }

    protected final Properties buildProperties() {
        Properties properties = new Properties();
        this.setUnlessNull(properties, "hibernate.dialect", this.dialect);
        this.setUnlessNull(properties, "hibernate.default_schema", this.defaultSchema);
        this.setUnlessNull(properties, "hibernate.default_catalog", this.defaultCatalog);
        this.setUnlessNull(properties, "hibernate.max_fetch_depth", this.maximumFetchDepth);
        this.setUnlessNull(properties, "hibernate.jdbc.fetch_size", this.jdbcFetchSize);
        this.setUnlessNull(properties, "hibernate.jdbc.batch_size", this.jdbcBatchSize);
        this.setUnlessNull(properties, "hibernate.jdbc.batch_versioned_data", this.batchVersionedDataEnabled);
        this.setUnlessNull(properties, "hibernate.jdbc.use_scrollable_resultset", this.jdbcScrollableResultSetEnabled);
        this.setUnlessNull(properties, "hibernate.jdbc.use_get_generated_keys", this.getGeneratedKeysEnabled);
        this.setUnlessNull(properties, "hibernate.jdbc.use_streams_for_binary", this.streamsForBinaryEnabled);
        this.setUnlessNull(properties, "hibernate.bytecode.use_reflection_optimizer", this.reflectionOptimizationEnabled);
        this.setUnlessNull(properties, "hibernate.query.substitutions", this.querySubstitutions);
        this.setUnlessNull(properties, "hibernate.show_sql", this.showSqlEnabled);
        this.setUnlessNull(properties, "hibernate.use_sql_comments", this.commentsEnabled);
        this.setUnlessNull(properties, "hibernate.cache.region.factory_class", this.cacheRegionFactory);
        this.setUnlessNull(properties, "hibernate.cache.provider_configuration_file_resource_path", this.cacheProviderConfig);
        this.setUnlessNull(properties, "hibernate.cache.region_prefix", this.cacheRegionPrefix);
        this.setUnlessNull(properties, "hibernate.cache.use_minimal_puts", this.minimalPutsEnabled);
        this.setUnlessNull(properties, "hibernate.cache.use_second_level_cache", this.secondLevelCacheEnabled);
        this.setUnlessNull(properties, "hibernate.cache.use_query_cache", this.queryCacheEnabled);
        Map map = this.getExtraProperties();
        if (map != null) {
            this.addAll(properties, map);
        }
        if (this.additionalProperties != null) {
            this.addAll(properties, this.additionalProperties);
        }
        return properties;
    }

    protected void addAll(Properties properties, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (string == null || string2 == null || properties.keySet().contains(string) || this.getExcludedPropertyNames().contains(string)) continue;
            properties.put(string, string2);
        }
    }

    protected Map getExtraProperties() {
        return null;
    }

    private void setUnlessNull(Properties properties, String string, String string2) {
        if (string2 != null) {
            properties.setProperty(string, string2);
        }
    }

    private void verifyInt(String string) {
        if (string != null) {
            Integer.parseInt(string);
        }
    }
}

