/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.Version;
import org.hibernate.bytecode.internal.javassist.BytecodeProviderImpl;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.cfg.AvailableSettings;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ConfigHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Environment
implements AvailableSettings {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, Environment.class.getName());
    private static final BytecodeProvider BYTECODE_PROVIDER_INSTANCE;
    private static final boolean ENABLE_BINARY_STREAMS;
    private static final boolean ENABLE_REFLECTION_OPTIMIZER;
    private static final boolean JVM_HAS_TIMESTAMP_BUG;
    private static final Properties GLOBAL_PROPERTIES;
    private static final Map<Integer, String> ISOLATION_LEVELS;
    private static final Map OBSOLETE_PROPERTIES;
    private static final Map RENAMED_PROPERTIES;

    public static void verifyProperties(Map<?, ?> map) {
        HashMap hashMap = new HashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object v;
            Object v2 = OBSOLETE_PROPERTIES.get(entry.getKey());
            if (v2 != null) {
                LOG.unsupportedProperty(entry.getKey(), v2);
            }
            if ((v = RENAMED_PROPERTIES.get(entry.getKey())) == null) continue;
            LOG.renamedProperty(entry.getKey(), v);
            hashMap.put(v, entry.getValue());
        }
        map.putAll(hashMap);
    }

    public static BytecodeProvider getBytecodeProvider() {
        return BYTECODE_PROVIDER_INSTANCE;
    }

    public static boolean jvmHasTimestampBug() {
        return JVM_HAS_TIMESTAMP_BUG;
    }

    public static boolean useStreamsForBinary() {
        return ENABLE_BINARY_STREAMS;
    }

    public static boolean useReflectionOptimizer() {
        return ENABLE_REFLECTION_OPTIMIZER;
    }

    private Environment() {
        throw new UnsupportedOperationException();
    }

    public static Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)GLOBAL_PROPERTIES);
        return properties;
    }

    public static String isolationLevelToString(int n) {
        return ISOLATION_LEVELS.get(n);
    }

    public static BytecodeProvider buildBytecodeProvider(Properties properties) {
        String string = ConfigurationHelper.getString("hibernate.bytecode.provider", properties, "javassist");
        LOG.bytecodeProvider(string);
        return Environment.buildBytecodeProvider(string);
    }

    private static BytecodeProvider buildBytecodeProvider(String string) {
        if ("javassist".equals(string)) {
            return new BytecodeProviderImpl();
        }
        LOG.unknownBytecodeProvider(string);
        return new BytecodeProviderImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        OBSOLETE_PROPERTIES = new HashMap();
        RENAMED_PROPERTIES = new HashMap();
        Version.logVersion();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "NONE");
        hashMap.put(1, "READ_UNCOMMITTED");
        hashMap.put(2, "READ_COMMITTED");
        hashMap.put(4, "REPEATABLE_READ");
        hashMap.put(8, "SERIALIZABLE");
        ISOLATION_LEVELS = Collections.unmodifiableMap(hashMap);
        GLOBAL_PROPERTIES = new Properties();
        GLOBAL_PROPERTIES.setProperty("hibernate.bytecode.use_reflection_optimizer", Boolean.FALSE.toString());
        try {
            InputStream inputStream = ConfigHelper.getResourceAsStream("/hibernate.properties");
            try {
                GLOBAL_PROPERTIES.load(inputStream);
                LOG.propertiesLoaded(ConfigurationHelper.maskOut(GLOBAL_PROPERTIES, "hibernate.connection.password"));
            }
            catch (Exception exception) {
                LOG.unableToLoadProperties();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LOG.unableToCloseStreamError(iOException);
                }
            }
        }
        catch (HibernateException hibernateException) {
            LOG.propertiesNotFound();
        }
        try {
            GLOBAL_PROPERTIES.putAll((Map<?, ?>)System.getProperties());
        }
        catch (SecurityException securityException) {
            LOG.unableToCopySystemProperties();
        }
        Environment.verifyProperties(GLOBAL_PROPERTIES);
        ENABLE_BINARY_STREAMS = ConfigurationHelper.getBoolean("hibernate.jdbc.use_streams_for_binary", GLOBAL_PROPERTIES);
        if (ENABLE_BINARY_STREAMS) {
            LOG.usingStreams();
        }
        if (ENABLE_REFLECTION_OPTIMIZER = ConfigurationHelper.getBoolean("hibernate.bytecode.use_reflection_optimizer", GLOBAL_PROPERTIES)) {
            LOG.usingReflectionOptimizer();
        }
        BYTECODE_PROVIDER_INSTANCE = Environment.buildBytecodeProvider(GLOBAL_PROPERTIES);
        long l = 123456789L;
        boolean bl = JVM_HAS_TIMESTAMP_BUG = new Timestamp(l).getTime() != l;
        if (JVM_HAS_TIMESTAMP_BUG) {
            LOG.usingTimestampWorkaround();
        }
    }
}

